<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDRequestParameters StructType
 * @subpackage Structs
 */
class DIDRequestParameters extends AbstractStructBase
{
    /**
     * The country_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $country_id;
    /**
     * The country_prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_prefix;
    /**
     * The country_iso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_iso;
    /**
     * The city_prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city_prefix;
    /**
     * The area_prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_prefix;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The country_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_name;
    /**
     * The area_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_name;
    /**
     * Constructor method for DIDRequestParameters
     * @uses DIDRequestParameters::setCountry_id()
     * @uses DIDRequestParameters::setCountry_prefix()
     * @uses DIDRequestParameters::setCountry_iso()
     * @uses DIDRequestParameters::setCity_prefix()
     * @uses DIDRequestParameters::setArea_prefix()
     * @uses DIDRequestParameters::setNumber()
     * @uses DIDRequestParameters::setCountry_name()
     * @uses DIDRequestParameters::setArea_name()
     * @param int $country_id
     * @param string $country_prefix
     * @param string $country_iso
     * @param string $city_prefix
     * @param string $area_prefix
     * @param string $number
     * @param string $country_name
     * @param string $area_name
     */
    public function __construct($country_id = null, $country_prefix = null, $country_iso = null, $city_prefix = null, $area_prefix = null, $number = null, $country_name = null, $area_name = null)
    {
        $this
            ->setCountry_id($country_id)
            ->setCountry_prefix($country_prefix)
            ->setCountry_iso($country_iso)
            ->setCity_prefix($city_prefix)
            ->setArea_prefix($area_prefix)
            ->setNumber($number)
            ->setCountry_name($country_name)
            ->setArea_name($area_name);
    }
    /**
     * Get country_id value
     * @return int|null
     */
    public function getCountry_id()
    {
        return $this->country_id;
    }
    /**
     * Set country_id value
     * @param int $country_id
     * @return \StructType\DIDRequestParameters
     */
    public function setCountry_id($country_id = null)
    {
        // validation for constraint: int
        if (!is_null($country_id) && !is_numeric($country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($country_id)), __LINE__);
        }
        $this->country_id = $country_id;
        return $this;
    }
    /**
     * Get country_prefix value
     * @return string|null
     */
    public function getCountry_prefix()
    {
        return $this->country_prefix;
    }
    /**
     * Set country_prefix value
     * @param string $country_prefix
     * @return \StructType\DIDRequestParameters
     */
    public function setCountry_prefix($country_prefix = null)
    {
        // validation for constraint: string
        if (!is_null($country_prefix) && !is_string($country_prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_prefix)), __LINE__);
        }
        $this->country_prefix = $country_prefix;
        return $this;
    }
    /**
     * Get country_iso value
     * @return string|null
     */
    public function getCountry_iso()
    {
        return $this->country_iso;
    }
    /**
     * Set country_iso value
     * @param string $country_iso
     * @return \StructType\DIDRequestParameters
     */
    public function setCountry_iso($country_iso = null)
    {
        // validation for constraint: string
        if (!is_null($country_iso) && !is_string($country_iso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_iso)), __LINE__);
        }
        $this->country_iso = $country_iso;
        return $this;
    }
    /**
     * Get city_prefix value
     * @return string|null
     */
    public function getCity_prefix()
    {
        return $this->city_prefix;
    }
    /**
     * Set city_prefix value
     * @param string $city_prefix
     * @return \StructType\DIDRequestParameters
     */
    public function setCity_prefix($city_prefix = null)
    {
        // validation for constraint: string
        if (!is_null($city_prefix) && !is_string($city_prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city_prefix)), __LINE__);
        }
        $this->city_prefix = $city_prefix;
        return $this;
    }
    /**
     * Get area_prefix value
     * @return string|null
     */
    public function getArea_prefix()
    {
        return $this->area_prefix;
    }
    /**
     * Set area_prefix value
     * @param string $area_prefix
     * @return \StructType\DIDRequestParameters
     */
    public function setArea_prefix($area_prefix = null)
    {
        // validation for constraint: string
        if (!is_null($area_prefix) && !is_string($area_prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_prefix)), __LINE__);
        }
        $this->area_prefix = $area_prefix;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\DIDRequestParameters
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get country_name value
     * @return string|null
     */
    public function getCountry_name()
    {
        return $this->country_name;
    }
    /**
     * Set country_name value
     * @param string $country_name
     * @return \StructType\DIDRequestParameters
     */
    public function setCountry_name($country_name = null)
    {
        // validation for constraint: string
        if (!is_null($country_name) && !is_string($country_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_name)), __LINE__);
        }
        $this->country_name = $country_name;
        return $this;
    }
    /**
     * Get area_name value
     * @return string|null
     */
    public function getArea_name()
    {
        return $this->area_name;
    }
    /**
     * Set area_name value
     * @param string $area_name
     * @return \StructType\DIDRequestParameters
     */
    public function setArea_name($area_name = null)
    {
        // validation for constraint: string
        if (!is_null($area_name) && !is_string($area_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_name)), __LINE__);
        }
        $this->area_name = $area_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDRequestParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
