<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDNumberOrderInfo StructType
 * @subpackage Structs
 */
class DIDNumberOrderInfo extends AbstractStructBase
{
    /**
     * The is_success
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $is_success;
    /**
     * The fault_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fault_code;
    /**
     * The fault_string
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fault_string;
    /**
     * The did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $did_number;
    /**
     * The i_did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_did_number;
    /**
     * The country_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_name;
    /**
     * The area_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $area_name;
    /**
     * The order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $order_id;
    /**
     * The did_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $did_status;
    /**
     * The pricing
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDPricing
     */
    public $pricing;
    /**
     * Constructor method for DIDNumberOrderInfo
     * @uses DIDNumberOrderInfo::setIs_success()
     * @uses DIDNumberOrderInfo::setFault_code()
     * @uses DIDNumberOrderInfo::setFault_string()
     * @uses DIDNumberOrderInfo::setDid_number()
     * @uses DIDNumberOrderInfo::setI_did_number()
     * @uses DIDNumberOrderInfo::setCountry_name()
     * @uses DIDNumberOrderInfo::setArea_name()
     * @uses DIDNumberOrderInfo::setOrder_id()
     * @uses DIDNumberOrderInfo::setDid_status()
     * @uses DIDNumberOrderInfo::setPricing()
     * @param int $is_success
     * @param string $fault_code
     * @param string $fault_string
     * @param string $did_number
     * @param int $i_did_number
     * @param string $country_name
     * @param string $area_name
     * @param string $order_id
     * @param string $did_status
     * @param \StructType\DIDPricing $pricing
     */
    public function __construct($is_success = null, $fault_code = null, $fault_string = null, $did_number = null, $i_did_number = null, $country_name = null, $area_name = null, $order_id = null, $did_status = null, \StructType\DIDPricing $pricing = null)
    {
        $this
            ->setIs_success($is_success)
            ->setFault_code($fault_code)
            ->setFault_string($fault_string)
            ->setDid_number($did_number)
            ->setI_did_number($i_did_number)
            ->setCountry_name($country_name)
            ->setArea_name($area_name)
            ->setOrder_id($order_id)
            ->setDid_status($did_status)
            ->setPricing($pricing);
    }
    /**
     * Get is_success value
     * @return int
     */
    public function getIs_success()
    {
        return $this->is_success;
    }
    /**
     * Set is_success value
     * @param int $is_success
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setIs_success($is_success = null)
    {
        // validation for constraint: int
        if (!is_null($is_success) && !is_numeric($is_success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_success)), __LINE__);
        }
        $this->is_success = $is_success;
        return $this;
    }
    /**
     * Get fault_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFault_code()
    {
        return isset($this->fault_code) ? $this->fault_code : null;
    }
    /**
     * Set fault_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fault_code
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setFault_code($fault_code = null)
    {
        // validation for constraint: string
        if (!is_null($fault_code) && !is_string($fault_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fault_code)), __LINE__);
        }
        if (is_null($fault_code) || (is_array($fault_code) && empty($fault_code))) {
            unset($this->fault_code);
        } else {
            $this->fault_code = $fault_code;
        }
        return $this;
    }
    /**
     * Get fault_string value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFault_string()
    {
        return isset($this->fault_string) ? $this->fault_string : null;
    }
    /**
     * Set fault_string value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fault_string
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setFault_string($fault_string = null)
    {
        // validation for constraint: string
        if (!is_null($fault_string) && !is_string($fault_string)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fault_string)), __LINE__);
        }
        if (is_null($fault_string) || (is_array($fault_string) && empty($fault_string))) {
            unset($this->fault_string);
        } else {
            $this->fault_string = $fault_string;
        }
        return $this;
    }
    /**
     * Get did_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDid_number()
    {
        return isset($this->did_number) ? $this->did_number : null;
    }
    /**
     * Set did_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $did_number
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setDid_number($did_number = null)
    {
        // validation for constraint: string
        if (!is_null($did_number) && !is_string($did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($did_number)), __LINE__);
        }
        if (is_null($did_number) || (is_array($did_number) && empty($did_number))) {
            unset($this->did_number);
        } else {
            $this->did_number = $did_number;
        }
        return $this;
    }
    /**
     * Get i_did_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_did_number()
    {
        return isset($this->i_did_number) ? $this->i_did_number : null;
    }
    /**
     * Set i_did_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_did_number
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setI_did_number($i_did_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_did_number) && !is_numeric($i_did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_did_number)), __LINE__);
        }
        if (is_null($i_did_number) || (is_array($i_did_number) && empty($i_did_number))) {
            unset($this->i_did_number);
        } else {
            $this->i_did_number = $i_did_number;
        }
        return $this;
    }
    /**
     * Get country_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_name()
    {
        return isset($this->country_name) ? $this->country_name : null;
    }
    /**
     * Set country_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_name
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setCountry_name($country_name = null)
    {
        // validation for constraint: string
        if (!is_null($country_name) && !is_string($country_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_name)), __LINE__);
        }
        if (is_null($country_name) || (is_array($country_name) && empty($country_name))) {
            unset($this->country_name);
        } else {
            $this->country_name = $country_name;
        }
        return $this;
    }
    /**
     * Get area_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea_name()
    {
        return isset($this->area_name) ? $this->area_name : null;
    }
    /**
     * Set area_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area_name
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setArea_name($area_name = null)
    {
        // validation for constraint: string
        if (!is_null($area_name) && !is_string($area_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_name)), __LINE__);
        }
        if (is_null($area_name) || (is_array($area_name) && empty($area_name))) {
            unset($this->area_name);
        } else {
            $this->area_name = $area_name;
        }
        return $this;
    }
    /**
     * Get order_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrder_id()
    {
        return isset($this->order_id) ? $this->order_id : null;
    }
    /**
     * Set order_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $order_id
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        if (is_null($order_id) || (is_array($order_id) && empty($order_id))) {
            unset($this->order_id);
        } else {
            $this->order_id = $order_id;
        }
        return $this;
    }
    /**
     * Get did_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDid_status()
    {
        return isset($this->did_status) ? $this->did_status : null;
    }
    /**
     * Set did_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $did_status
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setDid_status($did_status = null)
    {
        // validation for constraint: string
        if (!is_null($did_status) && !is_string($did_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($did_status)), __LINE__);
        }
        if (is_null($did_status) || (is_array($did_status) && empty($did_status))) {
            unset($this->did_status);
        } else {
            $this->did_status = $did_status;
        }
        return $this;
    }
    /**
     * Get pricing value
     * @return \StructType\DIDPricing|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param \StructType\DIDPricing $pricing
     * @return \StructType\DIDNumberOrderInfo
     */
    public function setPricing(\StructType\DIDPricing $pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDNumberOrderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
