<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDCountryInfo StructType
 * @subpackage Structs
 */
class DIDCountryInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $prefix;
    /**
     * The req_params
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDRequestParameters
     */
    public $req_params;
    /**
     * Constructor method for DIDCountryInfo
     * @uses DIDCountryInfo::setId()
     * @uses DIDCountryInfo::setName()
     * @uses DIDCountryInfo::setPrefix()
     * @uses DIDCountryInfo::setReq_params()
     * @param int $id
     * @param string $name
     * @param string $prefix
     * @param \StructType\DIDRequestParameters $req_params
     */
    public function __construct($id = null, $name = null, $prefix = null, \StructType\DIDRequestParameters $req_params = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setPrefix($prefix)
            ->setReq_params($req_params);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DIDCountryInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DIDCountryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get prefix value
     * @return string
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\DIDCountryInfo
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get req_params value
     * @return \StructType\DIDRequestParameters|null
     */
    public function getReq_params()
    {
        return $this->req_params;
    }
    /**
     * Set req_params value
     * @param \StructType\DIDRequestParameters $req_params
     * @return \StructType\DIDCountryInfo
     */
    public function setReq_params(\StructType\DIDRequestParameters $req_params = null)
    {
        $this->req_params = $req_params;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDCountryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
