<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDAreaInfo StructType
 * @subpackage Structs
 */
class DIDAreaInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $prefix;
    /**
     * The req_params
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDRequestParameters
     */
    public $req_params;
    /**
     * The pricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIDPricing
     */
    public $pricing;
    /**
     * Constructor method for DIDAreaInfo
     * @uses DIDAreaInfo::setId()
     * @uses DIDAreaInfo::setName()
     * @uses DIDAreaInfo::setPrefix()
     * @uses DIDAreaInfo::setReq_params()
     * @uses DIDAreaInfo::setPricing()
     * @param int $id
     * @param string $name
     * @param string $prefix
     * @param \StructType\DIDRequestParameters $req_params
     * @param \StructType\DIDPricing $pricing
     */
    public function __construct($id = null, $name = null, $prefix = null, \StructType\DIDRequestParameters $req_params = null, \StructType\DIDPricing $pricing = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setPrefix($prefix)
            ->setReq_params($req_params)
            ->setPricing($pricing);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DIDAreaInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DIDAreaInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get prefix value
     * @return string
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\DIDAreaInfo
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get req_params value
     * @return \StructType\DIDRequestParameters|null
     */
    public function getReq_params()
    {
        return $this->req_params;
    }
    /**
     * Set req_params value
     * @param \StructType\DIDRequestParameters $req_params
     * @return \StructType\DIDAreaInfo
     */
    public function setReq_params(\StructType\DIDRequestParameters $req_params = null)
    {
        $this->req_params = $req_params;
        return $this;
    }
    /**
     * Get pricing value
     * @return \StructType\DIDPricing|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param \StructType\DIDPricing $pricing
     * @return \StructType\DIDAreaInfo
     */
    public function setPricing(\StructType\DIDPricing $pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDAreaInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
