<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDIDProviderIdent StructType
 * @subpackage Structs
 */
class CustomerDIDProviderIdent extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The customer_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customer_batch;
    /**
     * The reseller_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reseller_batch;
    /**
     * Constructor method for CustomerDIDProviderIdent
     * @uses CustomerDIDProviderIdent::setI_customer()
     * @uses CustomerDIDProviderIdent::setCustomer_batch()
     * @uses CustomerDIDProviderIdent::setReseller_batch()
     * @param int $i_customer
     * @param int $customer_batch
     * @param int $reseller_batch
     */
    public function __construct($i_customer = null, $customer_batch = null, $reseller_batch = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setCustomer_batch($customer_batch)
            ->setReseller_batch($reseller_batch);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerDIDProviderIdent
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get customer_batch value
     * @return int|null
     */
    public function getCustomer_batch()
    {
        return $this->customer_batch;
    }
    /**
     * Set customer_batch value
     * @param int $customer_batch
     * @return \StructType\CustomerDIDProviderIdent
     */
    public function setCustomer_batch($customer_batch = null)
    {
        // validation for constraint: int
        if (!is_null($customer_batch) && !is_numeric($customer_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_batch)), __LINE__);
        }
        $this->customer_batch = $customer_batch;
        return $this;
    }
    /**
     * Get reseller_batch value
     * @return int|null
     */
    public function getReseller_batch()
    {
        return $this->reseller_batch;
    }
    /**
     * Set reseller_batch value
     * @param int $reseller_batch
     * @return \StructType\CustomerDIDProviderIdent
     */
    public function setReseller_batch($reseller_batch = null)
    {
        // validation for constraint: int
        if (!is_null($reseller_batch) && !is_numeric($reseller_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reseller_batch)), __LINE__);
        }
        $this->reseller_batch = $reseller_batch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerDIDProviderIdent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
