<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerClassInfo StructType
 * @subpackage Structs
 */
class CustomerClassInfo extends AbstractStructBase
{
    /**
     * The i_customer_class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer_class;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The i_template
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_template;
    /**
     * The grace_period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $grace_period;
    /**
     * The notific_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $notific_days;
    /**
     * The resend_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resend_days;
    /**
     * The recollect_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $recollect_days;
    /**
     * The warning_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $warning_days;
    /**
     * The suspension_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $suspension_days;
    /**
     * The closing_warning_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $closing_warning_days;
    /**
     * The closing_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $closing_days;
    /**
     * The bp_charge_cc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bp_charge_cc;
    /**
     * The i_billing_processor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_billing_processor;
    /**
     * The tax_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tax_info;
    /**
     * The send_invoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $send_invoices;
    /**
     * The send_statistics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $send_statistics;
    /**
     * The default_class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $default_class;
    /**
     * The collection_threshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $collection_threshold;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The review_invoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $review_invoices;
    /**
     * The review_term_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $review_term_days;
    /**
     * The bp_closure_delay_days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $bp_closure_delay_days;
    /**
     * The managed_by
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $managed_by;
    /**
     * Constructor method for CustomerClassInfo
     * @uses CustomerClassInfo::setI_customer_class()
     * @uses CustomerClassInfo::setName()
     * @uses CustomerClassInfo::setI_customer()
     * @uses CustomerClassInfo::setDescription()
     * @uses CustomerClassInfo::setI_template()
     * @uses CustomerClassInfo::setGrace_period()
     * @uses CustomerClassInfo::setNotific_days()
     * @uses CustomerClassInfo::setResend_days()
     * @uses CustomerClassInfo::setRecollect_days()
     * @uses CustomerClassInfo::setWarning_days()
     * @uses CustomerClassInfo::setSuspension_days()
     * @uses CustomerClassInfo::setClosing_warning_days()
     * @uses CustomerClassInfo::setClosing_days()
     * @uses CustomerClassInfo::setBp_charge_cc()
     * @uses CustomerClassInfo::setI_billing_processor()
     * @uses CustomerClassInfo::setTax_info()
     * @uses CustomerClassInfo::setSend_invoices()
     * @uses CustomerClassInfo::setSend_statistics()
     * @uses CustomerClassInfo::setDefault_class()
     * @uses CustomerClassInfo::setCollection_threshold()
     * @uses CustomerClassInfo::setIso_4217()
     * @uses CustomerClassInfo::setReview_invoices()
     * @uses CustomerClassInfo::setReview_term_days()
     * @uses CustomerClassInfo::setBp_closure_delay_days()
     * @uses CustomerClassInfo::setManaged_by()
     * @param int $i_customer_class
     * @param string $name
     * @param int $i_customer
     * @param string $description
     * @param int $i_template
     * @param int $grace_period
     * @param string $notific_days
     * @param string $resend_days
     * @param string $recollect_days
     * @param int $warning_days
     * @param int $suspension_days
     * @param int $closing_warning_days
     * @param int $closing_days
     * @param string $bp_charge_cc
     * @param int $i_billing_processor
     * @param string $tax_info
     * @param string $send_invoices
     * @param string $send_statistics
     * @param string $default_class
     * @param float $collection_threshold
     * @param string $iso_4217
     * @param string $review_invoices
     * @param int $review_term_days
     * @param int $bp_closure_delay_days
     * @param string $managed_by
     */
    public function __construct($i_customer_class = null, $name = null, $i_customer = null, $description = null, $i_template = null, $grace_period = null, $notific_days = null, $resend_days = null, $recollect_days = null, $warning_days = null, $suspension_days = null, $closing_warning_days = null, $closing_days = null, $bp_charge_cc = null, $i_billing_processor = null, $tax_info = null, $send_invoices = null, $send_statistics = null, $default_class = null, $collection_threshold = null, $iso_4217 = null, $review_invoices = null, $review_term_days = null, $bp_closure_delay_days = null, $managed_by = null)
    {
        $this
            ->setI_customer_class($i_customer_class)
            ->setName($name)
            ->setI_customer($i_customer)
            ->setDescription($description)
            ->setI_template($i_template)
            ->setGrace_period($grace_period)
            ->setNotific_days($notific_days)
            ->setResend_days($resend_days)
            ->setRecollect_days($recollect_days)
            ->setWarning_days($warning_days)
            ->setSuspension_days($suspension_days)
            ->setClosing_warning_days($closing_warning_days)
            ->setClosing_days($closing_days)
            ->setBp_charge_cc($bp_charge_cc)
            ->setI_billing_processor($i_billing_processor)
            ->setTax_info($tax_info)
            ->setSend_invoices($send_invoices)
            ->setSend_statistics($send_statistics)
            ->setDefault_class($default_class)
            ->setCollection_threshold($collection_threshold)
            ->setIso_4217($iso_4217)
            ->setReview_invoices($review_invoices)
            ->setReview_term_days($review_term_days)
            ->setBp_closure_delay_days($bp_closure_delay_days)
            ->setManaged_by($managed_by);
    }
    /**
     * Get i_customer_class value
     * @return int|null
     */
    public function getI_customer_class()
    {
        return $this->i_customer_class;
    }
    /**
     * Set i_customer_class value
     * @param int $i_customer_class
     * @return \StructType\CustomerClassInfo
     */
    public function setI_customer_class($i_customer_class = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_class) && !is_numeric($i_customer_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_class)), __LINE__);
        }
        $this->i_customer_class = $i_customer_class;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerClassInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerClassInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomerClassInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get i_template value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_template()
    {
        return isset($this->i_template) ? $this->i_template : null;
    }
    /**
     * Set i_template value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_template
     * @return \StructType\CustomerClassInfo
     */
    public function setI_template($i_template = null)
    {
        // validation for constraint: int
        if (!is_null($i_template) && !is_numeric($i_template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_template)), __LINE__);
        }
        if (is_null($i_template) || (is_array($i_template) && empty($i_template))) {
            unset($this->i_template);
        } else {
            $this->i_template = $i_template;
        }
        return $this;
    }
    /**
     * Get grace_period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGrace_period()
    {
        return isset($this->grace_period) ? $this->grace_period : null;
    }
    /**
     * Set grace_period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $grace_period
     * @return \StructType\CustomerClassInfo
     */
    public function setGrace_period($grace_period = null)
    {
        // validation for constraint: int
        if (!is_null($grace_period) && !is_numeric($grace_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grace_period)), __LINE__);
        }
        if (is_null($grace_period) || (is_array($grace_period) && empty($grace_period))) {
            unset($this->grace_period);
        } else {
            $this->grace_period = $grace_period;
        }
        return $this;
    }
    /**
     * Get notific_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotific_days()
    {
        return isset($this->notific_days) ? $this->notific_days : null;
    }
    /**
     * Set notific_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notific_days
     * @return \StructType\CustomerClassInfo
     */
    public function setNotific_days($notific_days = null)
    {
        // validation for constraint: string
        if (!is_null($notific_days) && !is_string($notific_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notific_days)), __LINE__);
        }
        if (is_null($notific_days) || (is_array($notific_days) && empty($notific_days))) {
            unset($this->notific_days);
        } else {
            $this->notific_days = $notific_days;
        }
        return $this;
    }
    /**
     * Get resend_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResend_days()
    {
        return isset($this->resend_days) ? $this->resend_days : null;
    }
    /**
     * Set resend_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resend_days
     * @return \StructType\CustomerClassInfo
     */
    public function setResend_days($resend_days = null)
    {
        // validation for constraint: string
        if (!is_null($resend_days) && !is_string($resend_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resend_days)), __LINE__);
        }
        if (is_null($resend_days) || (is_array($resend_days) && empty($resend_days))) {
            unset($this->resend_days);
        } else {
            $this->resend_days = $resend_days;
        }
        return $this;
    }
    /**
     * Get recollect_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecollect_days()
    {
        return isset($this->recollect_days) ? $this->recollect_days : null;
    }
    /**
     * Set recollect_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recollect_days
     * @return \StructType\CustomerClassInfo
     */
    public function setRecollect_days($recollect_days = null)
    {
        // validation for constraint: string
        if (!is_null($recollect_days) && !is_string($recollect_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recollect_days)), __LINE__);
        }
        if (is_null($recollect_days) || (is_array($recollect_days) && empty($recollect_days))) {
            unset($this->recollect_days);
        } else {
            $this->recollect_days = $recollect_days;
        }
        return $this;
    }
    /**
     * Get warning_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWarning_days()
    {
        return isset($this->warning_days) ? $this->warning_days : null;
    }
    /**
     * Set warning_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $warning_days
     * @return \StructType\CustomerClassInfo
     */
    public function setWarning_days($warning_days = null)
    {
        // validation for constraint: int
        if (!is_null($warning_days) && !is_numeric($warning_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warning_days)), __LINE__);
        }
        if (is_null($warning_days) || (is_array($warning_days) && empty($warning_days))) {
            unset($this->warning_days);
        } else {
            $this->warning_days = $warning_days;
        }
        return $this;
    }
    /**
     * Get suspension_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuspension_days()
    {
        return isset($this->suspension_days) ? $this->suspension_days : null;
    }
    /**
     * Set suspension_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $suspension_days
     * @return \StructType\CustomerClassInfo
     */
    public function setSuspension_days($suspension_days = null)
    {
        // validation for constraint: int
        if (!is_null($suspension_days) && !is_numeric($suspension_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suspension_days)), __LINE__);
        }
        if (is_null($suspension_days) || (is_array($suspension_days) && empty($suspension_days))) {
            unset($this->suspension_days);
        } else {
            $this->suspension_days = $suspension_days;
        }
        return $this;
    }
    /**
     * Get closing_warning_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClosing_warning_days()
    {
        return isset($this->closing_warning_days) ? $this->closing_warning_days : null;
    }
    /**
     * Set closing_warning_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $closing_warning_days
     * @return \StructType\CustomerClassInfo
     */
    public function setClosing_warning_days($closing_warning_days = null)
    {
        // validation for constraint: int
        if (!is_null($closing_warning_days) && !is_numeric($closing_warning_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($closing_warning_days)), __LINE__);
        }
        if (is_null($closing_warning_days) || (is_array($closing_warning_days) && empty($closing_warning_days))) {
            unset($this->closing_warning_days);
        } else {
            $this->closing_warning_days = $closing_warning_days;
        }
        return $this;
    }
    /**
     * Get closing_days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClosing_days()
    {
        return isset($this->closing_days) ? $this->closing_days : null;
    }
    /**
     * Set closing_days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $closing_days
     * @return \StructType\CustomerClassInfo
     */
    public function setClosing_days($closing_days = null)
    {
        // validation for constraint: int
        if (!is_null($closing_days) && !is_numeric($closing_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($closing_days)), __LINE__);
        }
        if (is_null($closing_days) || (is_array($closing_days) && empty($closing_days))) {
            unset($this->closing_days);
        } else {
            $this->closing_days = $closing_days;
        }
        return $this;
    }
    /**
     * Get bp_charge_cc value
     * @return string|null
     */
    public function getBp_charge_cc()
    {
        return $this->bp_charge_cc;
    }
    /**
     * Set bp_charge_cc value
     * @param string $bp_charge_cc
     * @return \StructType\CustomerClassInfo
     */
    public function setBp_charge_cc($bp_charge_cc = null)
    {
        // validation for constraint: string
        if (!is_null($bp_charge_cc) && !is_string($bp_charge_cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bp_charge_cc)), __LINE__);
        }
        $this->bp_charge_cc = $bp_charge_cc;
        return $this;
    }
    /**
     * Get i_billing_processor value
     * @return int|null
     */
    public function getI_billing_processor()
    {
        return $this->i_billing_processor;
    }
    /**
     * Set i_billing_processor value
     * @param int $i_billing_processor
     * @return \StructType\CustomerClassInfo
     */
    public function setI_billing_processor($i_billing_processor = null)
    {
        // validation for constraint: int
        if (!is_null($i_billing_processor) && !is_numeric($i_billing_processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_billing_processor)), __LINE__);
        }
        $this->i_billing_processor = $i_billing_processor;
        return $this;
    }
    /**
     * Get tax_info value
     * @return string|null
     */
    public function getTax_info()
    {
        return $this->tax_info;
    }
    /**
     * Set tax_info value
     * @param string $tax_info
     * @return \StructType\CustomerClassInfo
     */
    public function setTax_info($tax_info = null)
    {
        // validation for constraint: string
        if (!is_null($tax_info) && !is_string($tax_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_info)), __LINE__);
        }
        $this->tax_info = $tax_info;
        return $this;
    }
    /**
     * Get send_invoices value
     * @return string|null
     */
    public function getSend_invoices()
    {
        return $this->send_invoices;
    }
    /**
     * Set send_invoices value
     * @param string $send_invoices
     * @return \StructType\CustomerClassInfo
     */
    public function setSend_invoices($send_invoices = null)
    {
        // validation for constraint: string
        if (!is_null($send_invoices) && !is_string($send_invoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($send_invoices)), __LINE__);
        }
        $this->send_invoices = $send_invoices;
        return $this;
    }
    /**
     * Get send_statistics value
     * @return string|null
     */
    public function getSend_statistics()
    {
        return $this->send_statistics;
    }
    /**
     * Set send_statistics value
     * @param string $send_statistics
     * @return \StructType\CustomerClassInfo
     */
    public function setSend_statistics($send_statistics = null)
    {
        // validation for constraint: string
        if (!is_null($send_statistics) && !is_string($send_statistics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($send_statistics)), __LINE__);
        }
        $this->send_statistics = $send_statistics;
        return $this;
    }
    /**
     * Get default_class value
     * @return string|null
     */
    public function getDefault_class()
    {
        return $this->default_class;
    }
    /**
     * Set default_class value
     * @param string $default_class
     * @return \StructType\CustomerClassInfo
     */
    public function setDefault_class($default_class = null)
    {
        // validation for constraint: string
        if (!is_null($default_class) && !is_string($default_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_class)), __LINE__);
        }
        $this->default_class = $default_class;
        return $this;
    }
    /**
     * Get collection_threshold value
     * @return float|null
     */
    public function getCollection_threshold()
    {
        return $this->collection_threshold;
    }
    /**
     * Set collection_threshold value
     * @param float $collection_threshold
     * @return \StructType\CustomerClassInfo
     */
    public function setCollection_threshold($collection_threshold = null)
    {
        $this->collection_threshold = $collection_threshold;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\CustomerClassInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get review_invoices value
     * @return string|null
     */
    public function getReview_invoices()
    {
        return $this->review_invoices;
    }
    /**
     * Set review_invoices value
     * @param string $review_invoices
     * @return \StructType\CustomerClassInfo
     */
    public function setReview_invoices($review_invoices = null)
    {
        // validation for constraint: string
        if (!is_null($review_invoices) && !is_string($review_invoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($review_invoices)), __LINE__);
        }
        $this->review_invoices = $review_invoices;
        return $this;
    }
    /**
     * Get review_term_days value
     * @return int|null
     */
    public function getReview_term_days()
    {
        return $this->review_term_days;
    }
    /**
     * Set review_term_days value
     * @param int $review_term_days
     * @return \StructType\CustomerClassInfo
     */
    public function setReview_term_days($review_term_days = null)
    {
        // validation for constraint: int
        if (!is_null($review_term_days) && !is_numeric($review_term_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($review_term_days)), __LINE__);
        }
        $this->review_term_days = $review_term_days;
        return $this;
    }
    /**
     * Get bp_closure_delay_days value
     * @return int|null
     */
    public function getBp_closure_delay_days()
    {
        return $this->bp_closure_delay_days;
    }
    /**
     * Set bp_closure_delay_days value
     * @param int $bp_closure_delay_days
     * @return \StructType\CustomerClassInfo
     */
    public function setBp_closure_delay_days($bp_closure_delay_days = null)
    {
        // validation for constraint: int
        if (!is_null($bp_closure_delay_days) && !is_numeric($bp_closure_delay_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bp_closure_delay_days)), __LINE__);
        }
        $this->bp_closure_delay_days = $bp_closure_delay_days;
        return $this;
    }
    /**
     * Get managed_by value
     * @return string|null
     */
    public function getManaged_by()
    {
        return $this->managed_by;
    }
    /**
     * Set managed_by value
     * @param string $managed_by
     * @return \StructType\CustomerClassInfo
     */
    public function setManaged_by($managed_by = null)
    {
        // validation for constraint: string
        if (!is_null($managed_by) && !is_string($managed_by)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managed_by)), __LINE__);
        }
        $this->managed_by = $managed_by;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerClassInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
