<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CounterInfo StructType
 * @subpackage Structs
 */
class CounterInfo extends AbstractStructBase
{
    /**
     * The i_cvd_counter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_cvd_counter;
    /**
     * The i_avd_counter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_avd_counter;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The dg_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dg_name;
    /**
     * The service_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service_name;
    /**
     * The peak_level
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $peak_level;
    /**
     * The rate_unit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate_unit;
    /**
     * The counter_value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $counter_value;
    /**
     * Constructor method for CounterInfo
     * @uses CounterInfo::setI_cvd_counter()
     * @uses CounterInfo::setI_avd_counter()
     * @uses CounterInfo::setI_customer()
     * @uses CounterInfo::setI_account()
     * @uses CounterInfo::setDg_name()
     * @uses CounterInfo::setService_name()
     * @uses CounterInfo::setPeak_level()
     * @uses CounterInfo::setRate_unit()
     * @uses CounterInfo::setCounter_value()
     * @param int $i_cvd_counter
     * @param int $i_avd_counter
     * @param int $i_customer
     * @param int $i_account
     * @param string $dg_name
     * @param string $service_name
     * @param int $peak_level
     * @param string $rate_unit
     * @param float $counter_value
     */
    public function __construct($i_cvd_counter = null, $i_avd_counter = null, $i_customer = null, $i_account = null, $dg_name = null, $service_name = null, $peak_level = null, $rate_unit = null, $counter_value = null)
    {
        $this
            ->setI_cvd_counter($i_cvd_counter)
            ->setI_avd_counter($i_avd_counter)
            ->setI_customer($i_customer)
            ->setI_account($i_account)
            ->setDg_name($dg_name)
            ->setService_name($service_name)
            ->setPeak_level($peak_level)
            ->setRate_unit($rate_unit)
            ->setCounter_value($counter_value);
    }
    /**
     * Get i_cvd_counter value
     * @return int|null
     */
    public function getI_cvd_counter()
    {
        return $this->i_cvd_counter;
    }
    /**
     * Set i_cvd_counter value
     * @param int $i_cvd_counter
     * @return \StructType\CounterInfo
     */
    public function setI_cvd_counter($i_cvd_counter = null)
    {
        // validation for constraint: int
        if (!is_null($i_cvd_counter) && !is_numeric($i_cvd_counter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_cvd_counter)), __LINE__);
        }
        $this->i_cvd_counter = $i_cvd_counter;
        return $this;
    }
    /**
     * Get i_avd_counter value
     * @return int|null
     */
    public function getI_avd_counter()
    {
        return $this->i_avd_counter;
    }
    /**
     * Set i_avd_counter value
     * @param int $i_avd_counter
     * @return \StructType\CounterInfo
     */
    public function setI_avd_counter($i_avd_counter = null)
    {
        // validation for constraint: int
        if (!is_null($i_avd_counter) && !is_numeric($i_avd_counter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_avd_counter)), __LINE__);
        }
        $this->i_avd_counter = $i_avd_counter;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CounterInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\CounterInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get dg_name value
     * @return string|null
     */
    public function getDg_name()
    {
        return $this->dg_name;
    }
    /**
     * Set dg_name value
     * @param string $dg_name
     * @return \StructType\CounterInfo
     */
    public function setDg_name($dg_name = null)
    {
        // validation for constraint: string
        if (!is_null($dg_name) && !is_string($dg_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dg_name)), __LINE__);
        }
        $this->dg_name = $dg_name;
        return $this;
    }
    /**
     * Get service_name value
     * @return string|null
     */
    public function getService_name()
    {
        return $this->service_name;
    }
    /**
     * Set service_name value
     * @param string $service_name
     * @return \StructType\CounterInfo
     */
    public function setService_name($service_name = null)
    {
        // validation for constraint: string
        if (!is_null($service_name) && !is_string($service_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_name)), __LINE__);
        }
        $this->service_name = $service_name;
        return $this;
    }
    /**
     * Get peak_level value
     * @return int|null
     */
    public function getPeak_level()
    {
        return $this->peak_level;
    }
    /**
     * Set peak_level value
     * @param int $peak_level
     * @return \StructType\CounterInfo
     */
    public function setPeak_level($peak_level = null)
    {
        // validation for constraint: int
        if (!is_null($peak_level) && !is_numeric($peak_level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peak_level)), __LINE__);
        }
        $this->peak_level = $peak_level;
        return $this;
    }
    /**
     * Get rate_unit value
     * @return string|null
     */
    public function getRate_unit()
    {
        return $this->rate_unit;
    }
    /**
     * Set rate_unit value
     * @param string $rate_unit
     * @return \StructType\CounterInfo
     */
    public function setRate_unit($rate_unit = null)
    {
        // validation for constraint: string
        if (!is_null($rate_unit) && !is_string($rate_unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rate_unit)), __LINE__);
        }
        $this->rate_unit = $rate_unit;
        return $this;
    }
    /**
     * Get counter_value value
     * @return float|null
     */
    public function getCounter_value()
    {
        return $this->counter_value;
    }
    /**
     * Set counter_value value
     * @param float $counter_value
     * @return \StructType\CounterInfo
     */
    public function setCounter_value($counter_value = null)
    {
        $this->counter_value = $counter_value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CounterInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
