<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeAccountSubscriptionFeesRequest StructType
 * @subpackage Structs
 */
class ChargeAccountSubscriptionFeesRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The immediately_in_advance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $immediately_in_advance;
    /**
     * Constructor method for ChargeAccountSubscriptionFeesRequest
     * @uses ChargeAccountSubscriptionFeesRequest::setI_account()
     * @uses ChargeAccountSubscriptionFeesRequest::setImmediately_in_advance()
     * @param int $i_account
     * @param int $immediately_in_advance
     */
    public function __construct($i_account = null, $immediately_in_advance = null)
    {
        $this
            ->setI_account($i_account)
            ->setImmediately_in_advance($immediately_in_advance);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\ChargeAccountSubscriptionFeesRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get immediately_in_advance value
     * @return int|null
     */
    public function getImmediately_in_advance()
    {
        return $this->immediately_in_advance;
    }
    /**
     * Set immediately_in_advance value
     * @param int $immediately_in_advance
     * @return \StructType\ChargeAccountSubscriptionFeesRequest
     */
    public function setImmediately_in_advance($immediately_in_advance = null)
    {
        // validation for constraint: int
        if (!is_null($immediately_in_advance) && !is_numeric($immediately_in_advance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($immediately_in_advance)), __LINE__);
        }
        $this->immediately_in_advance = $immediately_in_advance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeAccountSubscriptionFeesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
