<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeAccountPasswordRequest StructType
 * @subpackage Structs
 */
class ChangeAccountPasswordRequest extends AbstractStructBase
{
    /**
     * The new_password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $new_password;
    /**
     * The old_password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $old_password;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * Constructor method for ChangeAccountPasswordRequest
     * @uses ChangeAccountPasswordRequest::setNew_password()
     * @uses ChangeAccountPasswordRequest::setOld_password()
     * @uses ChangeAccountPasswordRequest::setI_account()
     * @param string $new_password
     * @param string $old_password
     * @param int $i_account
     */
    public function __construct($new_password = null, $old_password = null, $i_account = null)
    {
        $this
            ->setNew_password($new_password)
            ->setOld_password($old_password)
            ->setI_account($i_account);
    }
    /**
     * Get new_password value
     * @return string
     */
    public function getNew_password()
    {
        return $this->new_password;
    }
    /**
     * Set new_password value
     * @param string $new_password
     * @return \StructType\ChangeAccountPasswordRequest
     */
    public function setNew_password($new_password = null)
    {
        // validation for constraint: string
        if (!is_null($new_password) && !is_string($new_password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($new_password)), __LINE__);
        }
        $this->new_password = $new_password;
        return $this;
    }
    /**
     * Get old_password value
     * @return string
     */
    public function getOld_password()
    {
        return $this->old_password;
    }
    /**
     * Set old_password value
     * @param string $old_password
     * @return \StructType\ChangeAccountPasswordRequest
     */
    public function setOld_password($old_password = null)
    {
        // validation for constraint: string
        if (!is_null($old_password) && !is_string($old_password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($old_password)), __LINE__);
        }
        $this->old_password = $old_password;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\ChangeAccountPasswordRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeAccountPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
