<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CPRuleInfo StructType
 * @subpackage Structs
 */
class CPRuleInfo extends AbstractStructBase
{
    /**
     * The i_cp_rule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_cp_rule;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The from_number_i_cp_condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $from_number_i_cp_condition;
    /**
     * The to_number_i_cp_condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $to_number_i_cp_condition;
    /**
     * The time_window_i_cp_condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $time_window_i_cp_condition;
    /**
     * The order_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $order_number;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_active;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * Constructor method for CPRuleInfo
     * @uses CPRuleInfo::setI_cp_rule()
     * @uses CPRuleInfo::setI_account()
     * @uses CPRuleInfo::setFrom_number_i_cp_condition()
     * @uses CPRuleInfo::setTo_number_i_cp_condition()
     * @uses CPRuleInfo::setTime_window_i_cp_condition()
     * @uses CPRuleInfo::setOrder_number()
     * @uses CPRuleInfo::setIs_active()
     * @uses CPRuleInfo::setAction()
     * @param int $i_cp_rule
     * @param int $i_account
     * @param int $from_number_i_cp_condition
     * @param int $to_number_i_cp_condition
     * @param int $time_window_i_cp_condition
     * @param int $order_number
     * @param string $is_active
     * @param int $action
     */
    public function __construct($i_cp_rule = null, $i_account = null, $from_number_i_cp_condition = null, $to_number_i_cp_condition = null, $time_window_i_cp_condition = null, $order_number = null, $is_active = null, $action = null)
    {
        $this
            ->setI_cp_rule($i_cp_rule)
            ->setI_account($i_account)
            ->setFrom_number_i_cp_condition($from_number_i_cp_condition)
            ->setTo_number_i_cp_condition($to_number_i_cp_condition)
            ->setTime_window_i_cp_condition($time_window_i_cp_condition)
            ->setOrder_number($order_number)
            ->setIs_active($is_active)
            ->setAction($action);
    }
    /**
     * Get i_cp_rule value
     * @return int|null
     */
    public function getI_cp_rule()
    {
        return $this->i_cp_rule;
    }
    /**
     * Set i_cp_rule value
     * @param int $i_cp_rule
     * @return \StructType\CPRuleInfo
     */
    public function setI_cp_rule($i_cp_rule = null)
    {
        // validation for constraint: int
        if (!is_null($i_cp_rule) && !is_numeric($i_cp_rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_cp_rule)), __LINE__);
        }
        $this->i_cp_rule = $i_cp_rule;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\CPRuleInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get from_number_i_cp_condition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFrom_number_i_cp_condition()
    {
        return isset($this->from_number_i_cp_condition) ? $this->from_number_i_cp_condition : null;
    }
    /**
     * Set from_number_i_cp_condition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $from_number_i_cp_condition
     * @return \StructType\CPRuleInfo
     */
    public function setFrom_number_i_cp_condition($from_number_i_cp_condition = null)
    {
        // validation for constraint: int
        if (!is_null($from_number_i_cp_condition) && !is_numeric($from_number_i_cp_condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($from_number_i_cp_condition)), __LINE__);
        }
        if (is_null($from_number_i_cp_condition) || (is_array($from_number_i_cp_condition) && empty($from_number_i_cp_condition))) {
            unset($this->from_number_i_cp_condition);
        } else {
            $this->from_number_i_cp_condition = $from_number_i_cp_condition;
        }
        return $this;
    }
    /**
     * Get to_number_i_cp_condition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTo_number_i_cp_condition()
    {
        return isset($this->to_number_i_cp_condition) ? $this->to_number_i_cp_condition : null;
    }
    /**
     * Set to_number_i_cp_condition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $to_number_i_cp_condition
     * @return \StructType\CPRuleInfo
     */
    public function setTo_number_i_cp_condition($to_number_i_cp_condition = null)
    {
        // validation for constraint: int
        if (!is_null($to_number_i_cp_condition) && !is_numeric($to_number_i_cp_condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($to_number_i_cp_condition)), __LINE__);
        }
        if (is_null($to_number_i_cp_condition) || (is_array($to_number_i_cp_condition) && empty($to_number_i_cp_condition))) {
            unset($this->to_number_i_cp_condition);
        } else {
            $this->to_number_i_cp_condition = $to_number_i_cp_condition;
        }
        return $this;
    }
    /**
     * Get time_window_i_cp_condition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTime_window_i_cp_condition()
    {
        return isset($this->time_window_i_cp_condition) ? $this->time_window_i_cp_condition : null;
    }
    /**
     * Set time_window_i_cp_condition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $time_window_i_cp_condition
     * @return \StructType\CPRuleInfo
     */
    public function setTime_window_i_cp_condition($time_window_i_cp_condition = null)
    {
        // validation for constraint: int
        if (!is_null($time_window_i_cp_condition) && !is_numeric($time_window_i_cp_condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($time_window_i_cp_condition)), __LINE__);
        }
        if (is_null($time_window_i_cp_condition) || (is_array($time_window_i_cp_condition) && empty($time_window_i_cp_condition))) {
            unset($this->time_window_i_cp_condition);
        } else {
            $this->time_window_i_cp_condition = $time_window_i_cp_condition;
        }
        return $this;
    }
    /**
     * Get order_number value
     * @return int|null
     */
    public function getOrder_number()
    {
        return $this->order_number;
    }
    /**
     * Set order_number value
     * @param int $order_number
     * @return \StructType\CPRuleInfo
     */
    public function setOrder_number($order_number = null)
    {
        // validation for constraint: int
        if (!is_null($order_number) && !is_numeric($order_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_number)), __LINE__);
        }
        $this->order_number = $order_number;
        return $this;
    }
    /**
     * Get is_active value
     * @return string|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param string $is_active
     * @return \StructType\CPRuleInfo
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: string
        if (!is_null($is_active) && !is_string($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\CPRuleInfo
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !is_numeric($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CPRuleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
