<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthzRuleInfo StructType
 * @subpackage Structs
 */
class AuthzRuleInfo extends AbstractStructBase
{
    /**
     * The i_authz_rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_authz_rule;
    /**
     * The order_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $order_number;
    /**
     * The ip_pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ip_pattern;
    /**
     * The cli_pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cli_pattern;
    /**
     * The cld_pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cld_pattern;
    /**
     * The i_authz_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_authz_type;
    /**
     * The auto_link_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $auto_link_type;
    /**
     * The auto_link_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $auto_link_id;
    /**
     * The i_service_policy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service_policy;
    /**
     * Constructor method for AuthzRuleInfo
     * @uses AuthzRuleInfo::setI_authz_rule()
     * @uses AuthzRuleInfo::setOrder_number()
     * @uses AuthzRuleInfo::setIp_pattern()
     * @uses AuthzRuleInfo::setCli_pattern()
     * @uses AuthzRuleInfo::setCld_pattern()
     * @uses AuthzRuleInfo::setI_authz_type()
     * @uses AuthzRuleInfo::setAuto_link_type()
     * @uses AuthzRuleInfo::setAuto_link_id()
     * @uses AuthzRuleInfo::setI_service_policy()
     * @param int $i_authz_rule
     * @param int $order_number
     * @param string $ip_pattern
     * @param string $cli_pattern
     * @param string $cld_pattern
     * @param int $i_authz_type
     * @param string $auto_link_type
     * @param int $auto_link_id
     * @param int $i_service_policy
     */
    public function __construct($i_authz_rule = null, $order_number = null, $ip_pattern = null, $cli_pattern = null, $cld_pattern = null, $i_authz_type = null, $auto_link_type = null, $auto_link_id = null, $i_service_policy = null)
    {
        $this
            ->setI_authz_rule($i_authz_rule)
            ->setOrder_number($order_number)
            ->setIp_pattern($ip_pattern)
            ->setCli_pattern($cli_pattern)
            ->setCld_pattern($cld_pattern)
            ->setI_authz_type($i_authz_type)
            ->setAuto_link_type($auto_link_type)
            ->setAuto_link_id($auto_link_id)
            ->setI_service_policy($i_service_policy);
    }
    /**
     * Get i_authz_rule value
     * @return int|null
     */
    public function getI_authz_rule()
    {
        return $this->i_authz_rule;
    }
    /**
     * Set i_authz_rule value
     * @param int $i_authz_rule
     * @return \StructType\AuthzRuleInfo
     */
    public function setI_authz_rule($i_authz_rule = null)
    {
        // validation for constraint: int
        if (!is_null($i_authz_rule) && !is_numeric($i_authz_rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_authz_rule)), __LINE__);
        }
        $this->i_authz_rule = $i_authz_rule;
        return $this;
    }
    /**
     * Get order_number value
     * @return int|null
     */
    public function getOrder_number()
    {
        return $this->order_number;
    }
    /**
     * Set order_number value
     * @param int $order_number
     * @return \StructType\AuthzRuleInfo
     */
    public function setOrder_number($order_number = null)
    {
        // validation for constraint: int
        if (!is_null($order_number) && !is_numeric($order_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_number)), __LINE__);
        }
        $this->order_number = $order_number;
        return $this;
    }
    /**
     * Get ip_pattern value
     * @return string|null
     */
    public function getIp_pattern()
    {
        return $this->ip_pattern;
    }
    /**
     * Set ip_pattern value
     * @param string $ip_pattern
     * @return \StructType\AuthzRuleInfo
     */
    public function setIp_pattern($ip_pattern = null)
    {
        // validation for constraint: string
        if (!is_null($ip_pattern) && !is_string($ip_pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ip_pattern)), __LINE__);
        }
        $this->ip_pattern = $ip_pattern;
        return $this;
    }
    /**
     * Get cli_pattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCli_pattern()
    {
        return isset($this->cli_pattern) ? $this->cli_pattern : null;
    }
    /**
     * Set cli_pattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cli_pattern
     * @return \StructType\AuthzRuleInfo
     */
    public function setCli_pattern($cli_pattern = null)
    {
        // validation for constraint: string
        if (!is_null($cli_pattern) && !is_string($cli_pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cli_pattern)), __LINE__);
        }
        if (is_null($cli_pattern) || (is_array($cli_pattern) && empty($cli_pattern))) {
            unset($this->cli_pattern);
        } else {
            $this->cli_pattern = $cli_pattern;
        }
        return $this;
    }
    /**
     * Get cld_pattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCld_pattern()
    {
        return isset($this->cld_pattern) ? $this->cld_pattern : null;
    }
    /**
     * Set cld_pattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cld_pattern
     * @return \StructType\AuthzRuleInfo
     */
    public function setCld_pattern($cld_pattern = null)
    {
        // validation for constraint: string
        if (!is_null($cld_pattern) && !is_string($cld_pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cld_pattern)), __LINE__);
        }
        if (is_null($cld_pattern) || (is_array($cld_pattern) && empty($cld_pattern))) {
            unset($this->cld_pattern);
        } else {
            $this->cld_pattern = $cld_pattern;
        }
        return $this;
    }
    /**
     * Get i_authz_type value
     * @return int|null
     */
    public function getI_authz_type()
    {
        return $this->i_authz_type;
    }
    /**
     * Set i_authz_type value
     * @param int $i_authz_type
     * @return \StructType\AuthzRuleInfo
     */
    public function setI_authz_type($i_authz_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_authz_type) && !is_numeric($i_authz_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_authz_type)), __LINE__);
        }
        $this->i_authz_type = $i_authz_type;
        return $this;
    }
    /**
     * Get auto_link_type value
     * @return string|null
     */
    public function getAuto_link_type()
    {
        return $this->auto_link_type;
    }
    /**
     * Set auto_link_type value
     * @param string $auto_link_type
     * @return \StructType\AuthzRuleInfo
     */
    public function setAuto_link_type($auto_link_type = null)
    {
        // validation for constraint: string
        if (!is_null($auto_link_type) && !is_string($auto_link_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auto_link_type)), __LINE__);
        }
        $this->auto_link_type = $auto_link_type;
        return $this;
    }
    /**
     * Get auto_link_id value
     * @return int|null
     */
    public function getAuto_link_id()
    {
        return $this->auto_link_id;
    }
    /**
     * Set auto_link_id value
     * @param int $auto_link_id
     * @return \StructType\AuthzRuleInfo
     */
    public function setAuto_link_id($auto_link_id = null)
    {
        // validation for constraint: int
        if (!is_null($auto_link_id) && !is_numeric($auto_link_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($auto_link_id)), __LINE__);
        }
        $this->auto_link_id = $auto_link_id;
        return $this;
    }
    /**
     * Get i_service_policy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service_policy()
    {
        return isset($this->i_service_policy) ? $this->i_service_policy : null;
    }
    /**
     * Set i_service_policy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service_policy
     * @return \StructType\AuthzRuleInfo
     */
    public function setI_service_policy($i_service_policy = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_policy) && !is_numeric($i_service_policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_policy)), __LINE__);
        }
        if (is_null($i_service_policy) || (is_array($i_service_policy) && empty($i_service_policy))) {
            unset($this->i_service_policy);
        } else {
            $this->i_service_policy = $i_service_policy;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthzRuleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
