<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrangeCPRulesRequest StructType
 * @subpackage Structs
 */
class ArrangeCPRulesRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The rules
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $rules;
    /**
     * Constructor method for ArrangeCPRulesRequest
     * @uses ArrangeCPRulesRequest::setI_account()
     * @uses ArrangeCPRulesRequest::setRules()
     * @param int $i_account
     * @param int[] $rules
     */
    public function __construct($i_account = null, array $rules = array())
    {
        $this
            ->setI_account($i_account)
            ->setRules($rules);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\ArrangeCPRulesRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get rules value
     * @return int[]
     */
    public function getRules()
    {
        return $this->rules;
    }
    /**
     * Set rules value
     * @throws \InvalidArgumentException
     * @param int[] $rules
     * @return \StructType\ArrangeCPRulesRequest
     */
    public function setRules(array $rules = array())
    {
        foreach ($rules as $arrangeCPRulesRequestRulesItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrangeCPRulesRequestRulesItem)) {
                throw new \InvalidArgumentException(sprintf('The rules property can only contain items of int, "%s" given', is_object($arrangeCPRulesRequestRulesItem) ? get_class($arrangeCPRulesRequestRulesItem) : gettype($arrangeCPRulesRequestRulesItem)), __LINE__);
            }
        }
        $this->rules = $rules;
        return $this;
    }
    /**
     * Add item to rules value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ArrangeCPRulesRequest
     */
    public function addToRules($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The rules property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rules[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrangeCPRulesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
