<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerHuntgroupRequest StructType
 * @subpackage Structs
 */
class AddCustomerHuntgroupRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The hunt_sequence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hunt_sequence;
    /**
     * The add_extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: pst:AssignedExtensionsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AssignedExtensionsInfo[]
     */
    public $add_extensions;
    /**
     * The prompt_action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prompt_action;
    /**
     * The pickup_allowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickup_allowed;
    /**
     * The hunt_keep_original_cli
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hunt_keep_original_cli;
    /**
     * Constructor method for AddCustomerHuntgroupRequest
     * @uses AddCustomerHuntgroupRequest::setI_customer()
     * @uses AddCustomerHuntgroupRequest::setId()
     * @uses AddCustomerHuntgroupRequest::setName()
     * @uses AddCustomerHuntgroupRequest::setHunt_sequence()
     * @uses AddCustomerHuntgroupRequest::setAdd_extensions()
     * @uses AddCustomerHuntgroupRequest::setPrompt_action()
     * @uses AddCustomerHuntgroupRequest::setPickup_allowed()
     * @uses AddCustomerHuntgroupRequest::setHunt_keep_original_cli()
     * @param int $i_customer
     * @param string $id
     * @param string $name
     * @param string $hunt_sequence
     * @param \StructType\AssignedExtensionsInfo[] $add_extensions
     * @param string $prompt_action
     * @param string $pickup_allowed
     * @param string $hunt_keep_original_cli
     */
    public function __construct($i_customer = null, $id = null, $name = null, $hunt_sequence = null, array $add_extensions = array(), $prompt_action = null, $pickup_allowed = null, $hunt_keep_original_cli = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setId($id)
            ->setName($name)
            ->setHunt_sequence($hunt_sequence)
            ->setAdd_extensions($add_extensions)
            ->setPrompt_action($prompt_action)
            ->setPickup_allowed($pickup_allowed)
            ->setHunt_keep_original_cli($hunt_keep_original_cli);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hunt_sequence value
     * @return string|null
     */
    public function getHunt_sequence()
    {
        return $this->hunt_sequence;
    }
    /**
     * Set hunt_sequence value
     * @param string $hunt_sequence
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setHunt_sequence($hunt_sequence = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_sequence) && !is_string($hunt_sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_sequence)), __LINE__);
        }
        $this->hunt_sequence = $hunt_sequence;
        return $this;
    }
    /**
     * Get add_extensions value
     * @return \StructType\AssignedExtensionsInfo[]|null
     */
    public function getAdd_extensions()
    {
        return $this->add_extensions;
    }
    /**
     * Set add_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo[] $add_extensions
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setAdd_extensions(array $add_extensions = array())
    {
        foreach ($add_extensions as $addCustomerHuntgroupRequestAdd_extensionsItem) {
            // validation for constraint: itemType
            if (!$addCustomerHuntgroupRequestAdd_extensionsItem instanceof \StructType\AssignedExtensionsInfo) {
                throw new \InvalidArgumentException(sprintf('The add_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($addCustomerHuntgroupRequestAdd_extensionsItem) ? get_class($addCustomerHuntgroupRequestAdd_extensionsItem) : gettype($addCustomerHuntgroupRequestAdd_extensionsItem)), __LINE__);
            }
        }
        $this->add_extensions = $add_extensions;
        return $this;
    }
    /**
     * Add item to add_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo $item
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function addToAdd_extensions(\StructType\AssignedExtensionsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedExtensionsInfo) {
            throw new \InvalidArgumentException(sprintf('The add_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->add_extensions[] = $item;
        return $this;
    }
    /**
     * Get prompt_action value
     * @return string|null
     */
    public function getPrompt_action()
    {
        return $this->prompt_action;
    }
    /**
     * Set prompt_action value
     * @param string $prompt_action
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setPrompt_action($prompt_action = null)
    {
        // validation for constraint: string
        if (!is_null($prompt_action) && !is_string($prompt_action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prompt_action)), __LINE__);
        }
        $this->prompt_action = $prompt_action;
        return $this;
    }
    /**
     * Get pickup_allowed value
     * @return string|null
     */
    public function getPickup_allowed()
    {
        return $this->pickup_allowed;
    }
    /**
     * Set pickup_allowed value
     * @param string $pickup_allowed
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setPickup_allowed($pickup_allowed = null)
    {
        // validation for constraint: string
        if (!is_null($pickup_allowed) && !is_string($pickup_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickup_allowed)), __LINE__);
        }
        $this->pickup_allowed = $pickup_allowed;
        return $this;
    }
    /**
     * Get hunt_keep_original_cli value
     * @return string|null
     */
    public function getHunt_keep_original_cli()
    {
        return $this->hunt_keep_original_cli;
    }
    /**
     * Set hunt_keep_original_cli value
     * @param string $hunt_keep_original_cli
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public function setHunt_keep_original_cli($hunt_keep_original_cli = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_keep_original_cli) && !is_string($hunt_keep_original_cli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_keep_original_cli)), __LINE__);
        }
        $this->hunt_keep_original_cli = $hunt_keep_original_cli;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddCustomerHuntgroupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
