<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountRegisterTransactionRequest StructType
 * @subpackage Structs
 */
class AccountRegisterTransactionRequest extends AbstractStructBase
{
    /**
     * The i_payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_payment_method;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * Constructor method for AccountRegisterTransactionRequest
     * @uses AccountRegisterTransactionRequest::setI_payment_method()
     * @uses AccountRegisterTransactionRequest::setAmount()
     * @uses AccountRegisterTransactionRequest::setI_account()
     * @param int $i_payment_method
     * @param float $amount
     * @param int $i_account
     */
    public function __construct($i_payment_method = null, $amount = null, $i_account = null)
    {
        $this
            ->setI_payment_method($i_payment_method)
            ->setAmount($amount)
            ->setI_account($i_account);
    }
    /**
     * Get i_payment_method value
     * @return int
     */
    public function getI_payment_method()
    {
        return $this->i_payment_method;
    }
    /**
     * Set i_payment_method value
     * @param int $i_payment_method
     * @return \StructType\AccountRegisterTransactionRequest
     */
    public function setI_payment_method($i_payment_method = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_method) && !is_numeric($i_payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_method)), __LINE__);
        }
        $this->i_payment_method = $i_payment_method;
        return $this;
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\AccountRegisterTransactionRequest
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\AccountRegisterTransactionRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountRegisterTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
