<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbbreviatedDialingNumberInfo StructType
 * @subpackage Structs
 */
class AbbreviatedDialingNumberInfo extends AbstractStructBase
{
    /**
     * The i_ab_dialing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_ab_dialing;
    /**
     * The abbreviated_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $abbreviated_number;
    /**
     * The number_to_dial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number_to_dial;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * Constructor method for AbbreviatedDialingNumberInfo
     * @uses AbbreviatedDialingNumberInfo::setI_ab_dialing()
     * @uses AbbreviatedDialingNumberInfo::setAbbreviated_number()
     * @uses AbbreviatedDialingNumberInfo::setNumber_to_dial()
     * @uses AbbreviatedDialingNumberInfo::setDescription()
     * @param int $i_ab_dialing
     * @param string $abbreviated_number
     * @param string $number_to_dial
     * @param string $description
     */
    public function __construct($i_ab_dialing = null, $abbreviated_number = null, $number_to_dial = null, $description = null)
    {
        $this
            ->setI_ab_dialing($i_ab_dialing)
            ->setAbbreviated_number($abbreviated_number)
            ->setNumber_to_dial($number_to_dial)
            ->setDescription($description);
    }
    /**
     * Get i_ab_dialing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_ab_dialing()
    {
        return isset($this->i_ab_dialing) ? $this->i_ab_dialing : null;
    }
    /**
     * Set i_ab_dialing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_ab_dialing
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public function setI_ab_dialing($i_ab_dialing = null)
    {
        // validation for constraint: int
        if (!is_null($i_ab_dialing) && !is_numeric($i_ab_dialing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ab_dialing)), __LINE__);
        }
        if (is_null($i_ab_dialing) || (is_array($i_ab_dialing) && empty($i_ab_dialing))) {
            unset($this->i_ab_dialing);
        } else {
            $this->i_ab_dialing = $i_ab_dialing;
        }
        return $this;
    }
    /**
     * Get abbreviated_number value
     * @return string|null
     */
    public function getAbbreviated_number()
    {
        return $this->abbreviated_number;
    }
    /**
     * Set abbreviated_number value
     * @param string $abbreviated_number
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public function setAbbreviated_number($abbreviated_number = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviated_number) && !is_string($abbreviated_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviated_number)), __LINE__);
        }
        $this->abbreviated_number = $abbreviated_number;
        return $this;
    }
    /**
     * Get number_to_dial value
     * @return string|null
     */
    public function getNumber_to_dial()
    {
        return $this->number_to_dial;
    }
    /**
     * Set number_to_dial value
     * @param string $number_to_dial
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public function setNumber_to_dial($number_to_dial = null)
    {
        // validation for constraint: string
        if (!is_null($number_to_dial) && !is_string($number_to_dial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number_to_dial)), __LINE__);
        }
        $this->number_to_dial = $number_to_dial;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
