<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AuthInfoStructure' => '\\StructType\\AuthInfoStructure',
            'ResetPasswordRequest' => '\\StructType\\ResetPasswordRequest',
            'ResetPasswordResponse' => '\\StructType\\ResetPasswordResponse',
            'CustomerInfo' => '\\StructType\\CustomerInfo',
            'AccountInfo' => '\\StructType\\AccountInfo',
            'DialingRuleOptionsInfo' => '\\StructType\\DialingRuleOptionsInfo',
            'CustomerSubscriptionInfo' => '\\StructType\\CustomerSubscriptionInfo',
            'FollowMeInfo' => '\\StructType\\FollowMeInfo',
            'FollowMeNumberInfo' => '\\StructType\\FollowMeNumberInfo',
            'SipStatusInfo' => '\\StructType\\SipStatusInfo',
            'AccountSubscriptionInfo' => '\\StructType\\AccountSubscriptionInfo',
            'GetCustomerInfoRequest' => '\\StructType\\GetCustomerInfoRequest',
            'GetCustomerInfoResponse' => '\\StructType\\GetCustomerInfoResponse',
            'GetCustomerListRequest' => '\\StructType\\GetCustomerListRequest',
            'GetCustomerListResponse' => '\\StructType\\GetCustomerListResponse',
            'UpdateCustomerRequest' => '\\StructType\\UpdateCustomerRequest',
            'AddCustomerRequest' => '\\StructType\\AddCustomerRequest',
            'ValidateCustomerInfoRequest' => '\\StructType\\ValidateCustomerInfoRequest',
            'ValidateCustomerInfoResponse' => '\\StructType\\ValidateCustomerInfoResponse',
            'AddUpdateCustomerResponse' => '\\StructType\\AddUpdateCustomerResponse',
            'DeleteCustomerRequest' => '\\StructType\\DeleteCustomerRequest',
            'DeleteCustomerResponse' => '\\StructType\\DeleteCustomerResponse',
            'GetCustomerSubscriptionsRequest' => '\\StructType\\GetCustomerSubscriptionsRequest',
            'GetCustomerSubscriptionsResponse' => '\\StructType\\GetCustomerSubscriptionsResponse',
            'AddCustomerSubscriptionRequest' => '\\StructType\\AddCustomerSubscriptionRequest',
            'AddUpdateCustomerSubscriptionResponse' => '\\StructType\\AddUpdateCustomerSubscriptionResponse',
            'UpdateCustomerSubscriptionRequest' => '\\StructType\\UpdateCustomerSubscriptionRequest',
            'CloseCustomerSubscriptionResponse' => '\\StructType\\CloseCustomerSubscriptionResponse',
            'CloseDeleteCustomerSubscriptionRequest' => '\\StructType\\CloseDeleteCustomerSubscriptionRequest',
            'DeleteCustomerSubscriptionResponse' => '\\StructType\\DeleteCustomerSubscriptionResponse',
            'MakeCustomerTransactionRequest' => '\\StructType\\MakeCustomerTransactionRequest',
            'MakeCustomerTransactionResponse' => '\\StructType\\MakeCustomerTransactionResponse',
            'GetAccountInfoRequest' => '\\StructType\\GetAccountInfoRequest',
            'GetAccountFollowMeRequest' => '\\StructType\\GetAccountFollowMeRequest',
            'GetAccountFollowMeResponse' => '\\StructType\\GetAccountFollowMeResponse',
            'UpdateAccountFollowMeRequest' => '\\StructType\\UpdateAccountFollowMeRequest',
            'UpdateAccountFollowMeResponse' => '\\StructType\\UpdateAccountFollowMeResponse',
            'AddFollowMeNumberRequest' => '\\StructType\\AddFollowMeNumberRequest',
            'UpdateFollowMeNumberRequest' => '\\StructType\\UpdateFollowMeNumberRequest',
            'AddUpdateFollowMeNumberResponse' => '\\StructType\\AddUpdateFollowMeNumberResponse',
            'DeleteFollowMeNumberRequest' => '\\StructType\\DeleteFollowMeNumberRequest',
            'DeleteFollowMeNumberResponse' => '\\StructType\\DeleteFollowMeNumberResponse',
            'ArrangeFollowMeNumbersRequest' => '\\StructType\\ArrangeFollowMeNumbersRequest',
            'ArrangeFollowMeNumbersResponse' => '\\StructType\\ArrangeFollowMeNumbersResponse',
            'GetAccountInfoResponse' => '\\StructType\\GetAccountInfoResponse',
            'GetAccountListRequest' => '\\StructType\\GetAccountListRequest',
            'GetAccountListResponse' => '\\StructType\\GetAccountListResponse',
            'UpdateAccountRequest' => '\\StructType\\UpdateAccountRequest',
            'AddAccountRequest' => '\\StructType\\AddAccountRequest',
            'ValidateAccountInfoRequest' => '\\StructType\\ValidateAccountInfoRequest',
            'ValidateAccountInfoResponse' => '\\StructType\\ValidateAccountInfoResponse',
            'AddUpdateAccountResponse' => '\\StructType\\AddUpdateAccountResponse',
            'GetSipStatusRequest' => '\\StructType\\GetSipStatusRequest',
            'GetSipStatusResponse' => '\\StructType\\GetSipStatusResponse',
            'GetAccountSubscriptionsRequest' => '\\StructType\\GetAccountSubscriptionsRequest',
            'GetAccountSubscriptionsResponse' => '\\StructType\\GetAccountSubscriptionsResponse',
            'AddAccountSubscriptionRequest' => '\\StructType\\AddAccountSubscriptionRequest',
            'AddUpdateAccountSubscriptionResponse' => '\\StructType\\AddUpdateAccountSubscriptionResponse',
            'UpdateAccountSubscriptionRequest' => '\\StructType\\UpdateAccountSubscriptionRequest',
            'CloseAccountSubscriptionResponse' => '\\StructType\\CloseAccountSubscriptionResponse',
            'CloseDeleteAccountSubscriptionRequest' => '\\StructType\\CloseDeleteAccountSubscriptionRequest',
            'DeleteAccountSubscriptionResponse' => '\\StructType\\DeleteAccountSubscriptionResponse',
            'ActivateCustomerSubscriptionsRequest' => '\\StructType\\ActivateCustomerSubscriptionsRequest',
            'ActivateCustomerSubscriptionsResponse' => '\\StructType\\ActivateCustomerSubscriptionsResponse',
            'ActivateAccountSubscriptionsRequest' => '\\StructType\\ActivateAccountSubscriptionsRequest',
            'ActivateAccountSubscriptionsResponse' => '\\StructType\\ActivateAccountSubscriptionsResponse',
            'MakeAccountTransactionRequest' => '\\StructType\\MakeAccountTransactionRequest',
            'MakeAccountTransactionResponse' => '\\StructType\\MakeAccountTransactionResponse',
            'GetUAInfoRequest' => '\\StructType\\GetUAInfoRequest',
            'GetUAInfoResponse' => '\\StructType\\GetUAInfoResponse',
            'AssignUARequest' => '\\StructType\\AssignUARequest',
            'AssignUAResponse' => '\\StructType\\AssignUAResponse',
            'ReleaseUARequest' => '\\StructType\\ReleaseUARequest',
            'ReleaseUAResponse' => '\\StructType\\ReleaseUAResponse',
            'GetUAListRequest' => '\\StructType\\GetUAListRequest',
            'UAInfo' => '\\StructType\\UAInfo',
            'GetUAListResponse' => '\\StructType\\GetUAListResponse',
            'GetVendorBatchListRequest' => '\\StructType\\GetVendorBatchListRequest',
            'VendorBatchInfo' => '\\StructType\\VendorBatchInfo',
            'GetVendorBatchListResponse' => '\\StructType\\GetVendorBatchListResponse',
            'GetDIDNumberListRequest' => '\\StructType\\GetDIDNumberListRequest',
            'DIDNumberInfo' => '\\StructType\\DIDNumberInfo',
            'GetDIDNumberListResponse' => '\\StructType\\GetDIDNumberListResponse',
            'GetDIDNumberInfoRequest' => '\\StructType\\GetDIDNumberInfoRequest',
            'GetDIDNumberInfoResponse' => '\\StructType\\GetDIDNumberInfoResponse',
            'ReserveDIDNumberRequest' => '\\StructType\\ReserveDIDNumberRequest',
            'ReserveDIDNumberResponse' => '\\StructType\\ReserveDIDNumberResponse',
            'ReleaseDIDNumberRequest' => '\\StructType\\ReleaseDIDNumberRequest',
            'ReleaseDIDNumberResponse' => '\\StructType\\ReleaseDIDNumberResponse',
            'PaymentMethodInfo' => '\\StructType\\PaymentMethodInfo',
            'UpdateCustomerPaymentMethodRequest' => '\\StructType\\UpdateCustomerPaymentMethodRequest',
            'UpdateCustomerPaymentMethodResponse' => '\\StructType\\UpdateCustomerPaymentMethodResponse',
            'UpdateAccountPaymentMethodRequest' => '\\StructType\\UpdateAccountPaymentMethodRequest',
            'UpdateAccountPaymentMethodResponse' => '\\StructType\\UpdateAccountPaymentMethodResponse',
            'GetProductListRequest' => '\\StructType\\GetProductListRequest',
            'GetProductListResponse' => '\\StructType\\GetProductListResponse',
            'GetProductInfoRequest' => '\\StructType\\GetProductInfoRequest',
            'GetProductInfoResponse' => '\\StructType\\GetProductInfoResponse',
            'ProductInfo' => '\\StructType\\ProductInfo',
            'AddProductRequest' => '\\StructType\\AddProductRequest',
            'AddProductResponse' => '\\StructType\\AddProductResponse',
            'UpdateProductRequest' => '\\StructType\\UpdateProductRequest',
            'UpdateProductResponse' => '\\StructType\\UpdateProductResponse',
            'DeleteProductRequest' => '\\StructType\\DeleteProductRequest',
            'DeleteProductResponse' => '\\StructType\\DeleteProductResponse',
            'GetAccountServiceFeaturesRequest' => '\\StructType\\GetAccountServiceFeaturesRequest',
            'GetAccountServiceFeaturesResponse' => '\\StructType\\GetAccountServiceFeaturesResponse',
            'UpdateAccountServiceFeaturesRequest' => '\\StructType\\UpdateAccountServiceFeaturesRequest',
            'GetCustomerServiceFeaturesRequest' => '\\StructType\\GetCustomerServiceFeaturesRequest',
            'GetCustomerServiceFeaturesResponse' => '\\StructType\\GetCustomerServiceFeaturesResponse',
            'UpdateCustomerServiceFeaturesRequest' => '\\StructType\\UpdateCustomerServiceFeaturesRequest',
            'UpdateAccountServiceFeaturesResponse' => '\\StructType\\UpdateAccountServiceFeaturesResponse',
            'UpdateCustomerServiceFeaturesResponse' => '\\StructType\\UpdateCustomerServiceFeaturesResponse',
            'ServiceFeatureInfo' => '\\StructType\\ServiceFeatureInfo',
            'ServiceAttributeInfo' => '\\StructType\\ServiceAttributeInfo',
            'GetAccountXDRListRequest' => '\\StructType\\GetAccountXDRListRequest',
            'GetAccountXDRListResponse' => '\\StructType\\GetAccountXDRListResponse',
            'XDRInfo' => '\\StructType\\XDRInfo',
            'AliasInfo' => '\\StructType\\AliasInfo',
            'GetAccountAliasListRequest' => '\\StructType\\GetAccountAliasListRequest',
            'GetAccountAliasListResponse' => '\\StructType\\GetAccountAliasListResponse',
            'AddAccountAliasRequest' => '\\StructType\\AddAccountAliasRequest',
            'AddAccountAliasResponse' => '\\StructType\\AddAccountAliasResponse',
            'DeleteAccountAliasRequest' => '\\StructType\\DeleteAccountAliasRequest',
            'DeleteAccountAliasResponse' => '\\StructType\\DeleteAccountAliasResponse',
            'AddUARequest' => '\\StructType\\AddUARequest',
            'AddUAResponse' => '\\StructType\\AddUAResponse',
            'TerminateCustomerRequest' => '\\StructType\\TerminateCustomerRequest',
            'TerminateCustomerResponse' => '\\StructType\\TerminateCustomerResponse',
            'SuspendCustomerRequest' => '\\StructType\\SuspendCustomerRequest',
            'SuspendCustomerResponse' => '\\StructType\\SuspendCustomerResponse',
            'UnsuspendCustomerRequest' => '\\StructType\\UnsuspendCustomerRequest',
            'UnsuspendCustomerResponse' => '\\StructType\\UnsuspendCustomerResponse',
            'TerminateAccountRequest' => '\\StructType\\TerminateAccountRequest',
            'TerminateAccountResponse' => '\\StructType\\TerminateAccountResponse',
            'MoveAccountRequest' => '\\StructType\\MoveAccountRequest',
            'MoveAccountResponse' => '\\StructType\\MoveAccountResponse',
            'GetMyInfoRequest' => '\\StructType\\GetMyInfoRequest',
            'GetMyInfoResponse' => '\\StructType\\GetMyInfoResponse',
            'DeleteUARequest' => '\\StructType\\DeleteUARequest',
            'DeleteUAResponse' => '\\StructType\\DeleteUAResponse',
            'CallBarringRuleInfo' => '\\StructType\\CallBarringRuleInfo',
            'GetCallBarringOptionsRequest' => '\\StructType\\GetCallBarringOptionsRequest',
            'GetCallBarringOptionsResponse' => '\\StructType\\GetCallBarringOptionsResponse',
            'UpdateCallBarringOptionsRequest' => '\\StructType\\UpdateCallBarringOptionsRequest',
            'UpdateCallBarringOptionsResponse' => '\\StructType\\UpdateCallBarringOptionsResponse',
            'GetAccountPaymentMethodInfoRequest' => '\\StructType\\GetAccountPaymentMethodInfoRequest',
            'GetAccountPaymentMethodInfoResponse' => '\\StructType\\GetAccountPaymentMethodInfoResponse',
            'GetCustomerPaymentMethodInfoRequest' => '\\StructType\\GetCustomerPaymentMethodInfoRequest',
            'GetCustomerPaymentMethodInfoResponse' => '\\StructType\\GetCustomerPaymentMethodInfoResponse',
            'GetCustomerAbbreviatedDialingNumberListRequest' => '\\StructType\\GetCustomerAbbreviatedDialingNumberListRequest',
            'GetCustomerAbbreviatedDialingNumberListResponse' => '\\StructType\\GetCustomerAbbreviatedDialingNumberListResponse',
            'AddUpdateCustomerAbbreviatedDialingNumberRequest' => '\\StructType\\AddUpdateCustomerAbbreviatedDialingNumberRequest',
            'AddUpdateCustomerAbbreviatedDialingNumberResponse' => '\\StructType\\AddUpdateCustomerAbbreviatedDialingNumberResponse',
            'DeleteCustomerAbbreviatedDialingNumberRequest' => '\\StructType\\DeleteCustomerAbbreviatedDialingNumberRequest',
            'DeleteCustomerAbbreviatedDialingNumberResponse' => '\\StructType\\DeleteCustomerAbbreviatedDialingNumberResponse',
            'AbbreviatedDialingNumberInfo' => '\\StructType\\AbbreviatedDialingNumberInfo',
            'CPConditionInfo' => '\\StructType\\CPConditionInfo',
            'CPConditionNumberInfo' => '\\StructType\\CPConditionNumberInfo',
            'CPConditionTimeWindowInfo' => '\\StructType\\CPConditionTimeWindowInfo',
            'GetCPConditionListRequest' => '\\StructType\\GetCPConditionListRequest',
            'GetCPConditionListResponse' => '\\StructType\\GetCPConditionListResponse',
            'AddCPConditionRequest' => '\\StructType\\AddCPConditionRequest',
            'AddCPConditionResponse' => '\\StructType\\AddCPConditionResponse',
            'UpdateCPConditionRequest' => '\\StructType\\UpdateCPConditionRequest',
            'UpdateCPConditionResponse' => '\\StructType\\UpdateCPConditionResponse',
            'DeleteCPConditionRequest' => '\\StructType\\DeleteCPConditionRequest',
            'DeleteCPConditionResponse' => '\\StructType\\DeleteCPConditionResponse',
            'CPRuleInfo' => '\\StructType\\CPRuleInfo',
            'AddCPRuleRequest' => '\\StructType\\AddCPRuleRequest',
            'AddCPRuleResponse' => '\\StructType\\AddCPRuleResponse',
            'UpdateCPRuleRequest' => '\\StructType\\UpdateCPRuleRequest',
            'UpdateCPRuleResponse' => '\\StructType\\UpdateCPRuleResponse',
            'DeleteCPRuleRequest' => '\\StructType\\DeleteCPRuleRequest',
            'DeleteCPRuleResponse' => '\\StructType\\DeleteCPRuleResponse',
            'GetCPRuleListRequest' => '\\StructType\\GetCPRuleListRequest',
            'GetCPRuleListResponse' => '\\StructType\\GetCPRuleListResponse',
            'ArrangeCPRulesRequest' => '\\StructType\\ArrangeCPRulesRequest',
            'ArrangeCPRulesResponse' => '\\StructType\\ArrangeCPRulesResponse',
            'GetCustomerTaxationInfoRequest' => '\\StructType\\GetCustomerTaxationInfoRequest',
            'GetCustomerTaxationInfoResponse' => '\\StructType\\GetCustomerTaxationInfoResponse',
            'UpdateCustomerTaxationRequest' => '\\StructType\\UpdateCustomerTaxationRequest',
            'UpdateCustomerTaxationResponse' => '\\StructType\\UpdateCustomerTaxationResponse',
            'TaxationInfo' => '\\StructType\\TaxationInfo',
            'TaxationOptionsVat' => '\\StructType\\TaxationOptionsVat',
            'TaxationOptionsBillsoft' => '\\StructType\\TaxationOptionsBillsoft',
            'GenerateUaProfileRequest' => '\\StructType\\GenerateUaProfileRequest',
            'GenerateUaProfileResponse' => '\\StructType\\GenerateUaProfileResponse',
            'VoucherInfo' => '\\StructType\\VoucherInfo',
            'TopupAccountRequest' => '\\StructType\\TopupAccountRequest',
            'TopupAccountResponse' => '\\StructType\\TopupAccountResponse',
            'RateInfo' => '\\StructType\\RateInfo',
            'AddRateRequest' => '\\StructType\\AddRateRequest',
            'AddRateResponse' => '\\StructType\\AddRateResponse',
            'AddRateGroupRequest' => '\\StructType\\AddRateGroupRequest',
            'AddRateGroupResponse' => '\\StructType\\AddRateGroupResponse',
            'UpdateRateRequest' => '\\StructType\\UpdateRateRequest',
            'UpdateRateResponse' => '\\StructType\\UpdateRateResponse',
            'UpdateRateGroupRequest' => '\\StructType\\UpdateRateGroupRequest',
            'UpdateRateGroupResponse' => '\\StructType\\UpdateRateGroupResponse',
            'DeleteRateRequest' => '\\StructType\\DeleteRateRequest',
            'DeleteRateResponse' => '\\StructType\\DeleteRateResponse',
            'RepresentativeInfo' => '\\StructType\\RepresentativeInfo',
            'GetRepresentativeInfoRequest' => '\\StructType\\GetRepresentativeInfoRequest',
            'GetRepresentativeInfoResponse' => '\\StructType\\GetRepresentativeInfoResponse',
            'GetRepresentativeListRequest' => '\\StructType\\GetRepresentativeListRequest',
            'GetRepresentativeListResponse' => '\\StructType\\GetRepresentativeListResponse',
            'InvoiceInfo' => '\\StructType\\InvoiceInfo',
            'GetInvoiceInfoRequest' => '\\StructType\\GetInvoiceInfoRequest',
            'GetInvoiceInfoResponse' => '\\StructType\\GetInvoiceInfoResponse',
            'GetInvoiceListRequest' => '\\StructType\\GetInvoiceListRequest',
            'GetInvoiceListResponse' => '\\StructType\\GetInvoiceListResponse',
            'CustomerClassInfo' => '\\StructType\\CustomerClassInfo',
            'GetCustomerClassListRequest' => '\\StructType\\GetCustomerClassListRequest',
            'GetCustomerClassListResponse' => '\\StructType\\GetCustomerClassListResponse',
            'GetCustomerClassInfoRequest' => '\\StructType\\GetCustomerClassInfoRequest',
            'GetCustomerClassInfoResponse' => '\\StructType\\GetCustomerClassInfoResponse',
            'GetDefaultCustomerClassRequest' => '\\StructType\\GetDefaultCustomerClassRequest',
            'GetDefaultCustomerClassResponse' => '\\StructType\\GetDefaultCustomerClassResponse',
            'AddUpdateCustomerClassRequest' => '\\StructType\\AddUpdateCustomerClassRequest',
            'AddUpdateCustomerClassResponse' => '\\StructType\\AddUpdateCustomerClassResponse',
            'DeleteCustomerClassRequest' => '\\StructType\\DeleteCustomerClassRequest',
            'DeleteCustomerClassResponse' => '\\StructType\\DeleteCustomerClassResponse',
            'AddDiscountPlanRequest' => '\\StructType\\AddDiscountPlanRequest',
            'AddDiscountPlanResponse' => '\\StructType\\AddDiscountPlanResponse',
            'UpdateDiscountPlanRequest' => '\\StructType\\UpdateDiscountPlanRequest',
            'UpdateDiscountPlanResponse' => '\\StructType\\UpdateDiscountPlanResponse',
            'DeleteDiscountPlanRequest' => '\\StructType\\DeleteDiscountPlanRequest',
            'DeleteDiscountPlanResponse' => '\\StructType\\DeleteDiscountPlanResponse',
            'GetDiscountPlanInfoRequest' => '\\StructType\\GetDiscountPlanInfoRequest',
            'GetDiscountPlanInfoResponse' => '\\StructType\\GetDiscountPlanInfoResponse',
            'DiscountPlanInfo' => '\\StructType\\DiscountPlanInfo',
            'GetDiscountListResponse' => '\\StructType\\GetDiscountListResponse',
            'DiscountInfo' => '\\StructType\\DiscountInfo',
            'GetDiscountListRequest' => '\\StructType\\GetDiscountListRequest',
            'GetAccountVDCounterListRequest' => '\\StructType\\GetAccountVDCounterListRequest',
            'GetCustomerVDCounterListRequest' => '\\StructType\\GetCustomerVDCounterListRequest',
            'GetCustomerVDCounterListResponse' => '\\StructType\\GetCustomerVDCounterListResponse',
            'GetAccountVDCounterListResponse' => '\\StructType\\GetAccountVDCounterListResponse',
            'CounterInfo' => '\\StructType\\CounterInfo',
            'AddVDThresholdRequest' => '\\StructType\\AddVDThresholdRequest',
            'AddVDThresholdResponse' => '\\StructType\\AddVDThresholdResponse',
            'UpdateVDThresholdRequest' => '\\StructType\\UpdateVDThresholdRequest',
            'UpdateVDThresholdResponse' => '\\StructType\\UpdateVDThresholdResponse',
            'DeleteVDThresholdRequest' => '\\StructType\\DeleteVDThresholdRequest',
            'DeleteVDThresholdResponse' => '\\StructType\\DeleteVDThresholdResponse',
            'GetVDThresholdInfoRequest' => '\\StructType\\GetVDThresholdInfoRequest',
            'GetVDThresholdInfoResponse' => '\\StructType\\GetVDThresholdInfoResponse',
            'GetVDThresholdListRequest' => '\\StructType\\GetVDThresholdListRequest',
            'GetVDThresholdListResponse' => '\\StructType\\GetVDThresholdListResponse',
            'VDThresholdInfo' => '\\StructType\\VDThresholdInfo',
            'GetDestinationInfoRequest' => '\\StructType\\GetDestinationInfoRequest',
            'MakeTransferRequest' => '\\StructType\\MakeTransferRequest',
            'GetTransferInfoRequest' => '\\StructType\\GetTransferInfoRequest',
            'GetDestinationInfoResponse' => '\\StructType\\GetDestinationInfoResponse',
            'MatchDestinationGroupsRequest' => '\\StructType\\MatchDestinationGroupsRequest',
            'MatchDestinationGroupsResponse' => '\\StructType\\MatchDestinationGroupsResponse',
            'DestinationGroupInfo' => '\\StructType\\DestinationGroupInfo',
            'MakeTransferResponse' => '\\StructType\\MakeTransferResponse',
            'GetTransferInfoResponse' => '\\StructType\\GetTransferInfoResponse',
            'PriceListInfo' => '\\StructType\\PriceListInfo',
            'GetRetailCustomerXDRListRequest' => '\\StructType\\GetRetailCustomerXDRListRequest',
            'GetRetailCustomerXDRListResponse' => '\\StructType\\GetRetailCustomerXDRListResponse',
            'CustomerXDRInfo' => '\\StructType\\CustomerXDRInfo',
            'GetDialRuleSamplesRequest' => '\\StructType\\GetDialRuleSamplesRequest',
            'GetDialRuleSamplesResponse' => '\\StructType\\GetDialRuleSamplesResponse',
            'SampleDialingRulesInfo' => '\\StructType\\SampleDialingRulesInfo',
            'DialingRuleInfo' => '\\StructType\\DialingRuleInfo',
            'AddUpdateDialingRuleRequest' => '\\StructType\\AddUpdateDialingRuleRequest',
            'AddUpdateDialingRuleResponse' => '\\StructType\\AddUpdateDialingRuleResponse',
            'DeleteDialingRuleRequest' => '\\StructType\\DeleteDialingRuleRequest',
            'DeleteDialingRuleResponse' => '\\StructType\\DeleteDialingRuleResponse',
            'GetDialingRuleInfoRequest' => '\\StructType\\GetDialingRuleInfoRequest',
            'GetDialingRuleInfoResponse' => '\\StructType\\GetDialingRuleInfoResponse',
            'GetDialingRulesListRequest' => '\\StructType\\GetDialingRulesListRequest',
            'GetDialingRulesListResponse' => '\\StructType\\GetDialingRulesListResponse',
            'TestTranslationRuleRequest' => '\\StructType\\TestTranslationRuleRequest',
            'TestTranslationRuleResponse' => '\\StructType\\TestTranslationRuleResponse',
            'GetMOHListInfoRequest' => '\\StructType\\GetMOHListInfoRequest',
            'GetMOHListInfoResponse' => '\\StructType\\GetMOHListInfoResponse',
            'MOHListInfo' => '\\StructType\\MOHListInfo',
            'MOHInfo' => '\\StructType\\MOHInfo',
            'GetPromptFileRequest' => '\\StructType\\GetPromptFileRequest',
            'GetPromptFileResponse' => '\\StructType\\GetPromptFileResponse',
            'GetExtensionsListInfoRequest' => '\\StructType\\GetExtensionsListInfoRequest',
            'GetExtensionsListInfoResponse' => '\\StructType\\GetExtensionsListInfoResponse',
            'ExtensionsInfo' => '\\StructType\\ExtensionsInfo',
            'GetHGListInfoRequest' => '\\StructType\\GetHGListInfoRequest',
            'GetHGListInfoResponse' => '\\StructType\\GetHGListInfoResponse',
            'HGInfo' => '\\StructType\\HGInfo',
            'AssignedExtensionsInfo' => '\\StructType\\AssignedExtensionsInfo',
            'GetAllAccAliasesListInfoRequest' => '\\StructType\\GetAllAccAliasesListInfoRequest',
            'GetAllAccAliasesListInfoResponse' => '\\StructType\\GetAllAccAliasesListInfoResponse',
            'AccAliasesListInfo' => '\\StructType\\AccAliasesListInfo',
            'AddCustomerExtensionRequest' => '\\StructType\\AddCustomerExtensionRequest',
            'UpdateCustomerExtensionRequest' => '\\StructType\\UpdateCustomerExtensionRequest',
            'AddUpdateCustomerExtensionResponse' => '\\StructType\\AddUpdateCustomerExtensionResponse',
            'DeleteCustomerExtensionRequest' => '\\StructType\\DeleteCustomerExtensionRequest',
            'DeleteCustomerExtensionResponse' => '\\StructType\\DeleteCustomerExtensionResponse',
            'GetCustomerInvoicesRequest' => '\\StructType\\GetCustomerInvoicesRequest',
            'GetCustomerInvoicesResponse' => '\\StructType\\GetCustomerInvoicesResponse',
            'CustomerInvoicesListInfo' => '\\StructType\\CustomerInvoicesListInfo',
            'AddCustomerHuntgroupRequest' => '\\StructType\\AddCustomerHuntgroupRequest',
            'UpdateCustomerHuntgroupRequest' => '\\StructType\\UpdateCustomerHuntgroupRequest',
            'AddUpdateCustomerHuntgroupResponse' => '\\StructType\\AddUpdateCustomerHuntgroupResponse',
            'DeleteCustomerHuntgroupRequest' => '\\StructType\\DeleteCustomerHuntgroupRequest',
            'DeleteCustomerHuntgroupResponse' => '\\StructType\\DeleteCustomerHuntgroupResponse',
            'CountryInfo' => '\\StructType\\CountryInfo',
            'GetCountriesListResponse' => '\\StructType\\GetCountriesListResponse',
            'GetCountriesListRequest' => '\\StructType\\GetCountriesListRequest',
            'SubdivisionInfo' => '\\StructType\\SubdivisionInfo',
            'GetSubdivisionsListResponse' => '\\StructType\\GetSubdivisionsListResponse',
            'GetSubdivisionsListRequest' => '\\StructType\\GetSubdivisionsListRequest',
            'GlobalCurrencyInfo' => '\\StructType\\GlobalCurrencyInfo',
            'GetGlobalCurrencyInfoRequest' => '\\StructType\\GetGlobalCurrencyInfoRequest',
            'GetGlobalCurrencyInfoResponse' => '\\StructType\\GetGlobalCurrencyInfoResponse',
            'GetGlobalCurrencyListRequest' => '\\StructType\\GetGlobalCurrencyListRequest',
            'GetGlobalCurrencyListResponse' => '\\StructType\\GetGlobalCurrencyListResponse',
            'ChangeCustomerPasswordRequest' => '\\StructType\\ChangeCustomerPasswordRequest',
            'ChangeAccountPasswordRequest' => '\\StructType\\ChangeAccountPasswordRequest',
            'ChangePasswordResponseErrMessages' => '\\StructType\\ChangePasswordResponseErrMessages',
            'ChangePasswordResponse' => '\\StructType\\ChangePasswordResponse',
            'GetCallProcessingActionsRequest' => '\\StructType\\GetCallProcessingActionsRequest',
            'GetCallProcessingActionsResponse' => '\\StructType\\GetCallProcessingActionsResponse',
            'GetAccountProductInfoRequest' => '\\StructType\\GetAccountProductInfoRequest',
            'GetAccountFullVDCounterListInfoRequest' => '\\StructType\\GetAccountFullVDCounterListInfoRequest',
            'GetCustomerFullVDCounterListInfoRequest' => '\\StructType\\GetCustomerFullVDCounterListInfoRequest',
            'GetFullVDCounterListInfoResponse' => '\\StructType\\GetFullVDCounterListInfoResponse',
            'FullCounterInfo' => '\\StructType\\FullCounterInfo',
            'GetMemberOfHuntgroupsList' => '\\StructType\\GetMemberOfHuntgroupsList',
            'GetRateInfoRequest' => '\\StructType\\GetRateInfoRequest',
            'GetRateInfoResponse' => '\\StructType\\GetRateInfoResponse',
            'GetRateListRequest' => '\\StructType\\GetRateListRequest',
            'GetRateListResponse' => '\\StructType\\GetRateListResponse',
            'AddDestinationPrefixRequest' => '\\StructType\\AddDestinationPrefixRequest',
            'AddDestinationPrefixResponse' => '\\StructType\\AddDestinationPrefixResponse',
            'UpdateDestinationPrefixRequest' => '\\StructType\\UpdateDestinationPrefixRequest',
            'UpdateDestinationPrefixResponse' => '\\StructType\\UpdateDestinationPrefixResponse',
            'GetDestinationPrefixListRequest' => '\\StructType\\GetDestinationPrefixListRequest',
            'GetDestinationPrefixListResponse' => '\\StructType\\GetDestinationPrefixListResponse',
            'GetDestinationPrefixInfoRequest' => '\\StructType\\GetDestinationPrefixInfoRequest',
            'GetDestinationPrefixInfoResponse' => '\\StructType\\GetDestinationPrefixInfoResponse',
            'DestinationPrefixInfo' => '\\StructType\\DestinationPrefixInfo',
            'DestGroupSetInfo' => '\\StructType\\DestGroupSetInfo',
            'GetDestGroupSetListRequest' => '\\StructType\\GetDestGroupSetListRequest',
            'GetDestGroupSetListResponse' => '\\StructType\\GetDestGroupSetListResponse',
            'AddUpdateDestGroupSetRequest' => '\\StructType\\AddUpdateDestGroupSetRequest',
            'AddUpdateDestGroupSetResponse' => '\\StructType\\AddUpdateDestGroupSetResponse',
            'DeleteDestGroupSetRequest' => '\\StructType\\DeleteDestGroupSetRequest',
            'DeleteDestGroupSetResponse' => '\\StructType\\DeleteDestGroupSetResponse',
            'AddDestGroupRequest' => '\\StructType\\AddDestGroupRequest',
            'AddDestGroupResponse' => '\\StructType\\AddDestGroupResponse',
            'UpdateDestGroupRequest' => '\\StructType\\UpdateDestGroupRequest',
            'UpdateDestGroupResponse' => '\\StructType\\UpdateDestGroupResponse',
            'DeleteDestGroupRequest' => '\\StructType\\DeleteDestGroupRequest',
            'DeleteDestGroupResponse' => '\\StructType\\DeleteDestGroupResponse',
            'GetDestGroupListRequest' => '\\StructType\\GetDestGroupListRequest',
            'GetDestGroupListResponse' => '\\StructType\\GetDestGroupListResponse',
            'GetDestGroupInfoRequest' => '\\StructType\\GetDestGroupInfoRequest',
            'GetDestGroupInfoResponse' => '\\StructType\\GetDestGroupInfoResponse',
            'AddTariffRequest' => '\\StructType\\AddTariffRequest',
            'AddTariffResponse' => '\\StructType\\AddTariffResponse',
            'UpdateTariffRequest' => '\\StructType\\UpdateTariffRequest',
            'UpdateTariffResponse' => '\\StructType\\UpdateTariffResponse',
            'DeleteTariffRequest' => '\\StructType\\DeleteTariffRequest',
            'DeleteTariffResponse' => '\\StructType\\DeleteTariffResponse',
            'GetTariffInfoRequest' => '\\StructType\\GetTariffInfoRequest',
            'GetTariffInfoResponse' => '\\StructType\\GetTariffInfoResponse',
            'GetTariffListRequest' => '\\StructType\\GetTariffListRequest',
            'GetTariffListResponse' => '\\StructType\\GetTariffListResponse',
            'TariffInfo' => '\\StructType\\TariffInfo',
            'GetLinesActiveSubscriptionsRequest' => '\\StructType\\GetLinesActiveSubscriptionsRequest',
            'LineSubscriptionInfo' => '\\StructType\\LineSubscriptionInfo',
            'GetLinesActiveSubscriptionsResponse' => '\\StructType\\GetLinesActiveSubscriptionsResponse',
            'UpdateEnvInfoRequest' => '\\StructType\\UpdateEnvInfoRequest',
            'UpdateEnvInfoResponse' => '\\StructType\\UpdateEnvInfoResponse',
            'GetEnvInfoRequest' => '\\StructType\\GetEnvInfoRequest',
            'GetEnvInfoResponse' => '\\StructType\\GetEnvInfoResponse',
            'EnvInfo' => '\\StructType\\EnvInfo',
            'GetAccountCustomFieldsValuesRequest' => '\\StructType\\GetAccountCustomFieldsValuesRequest',
            'GetAccountCustomFieldsValuesResponse' => '\\StructType\\GetAccountCustomFieldsValuesResponse',
            'GetAccountCustomFieldsSchemaRequest' => '\\StructType\\GetAccountCustomFieldsSchemaRequest',
            'GetAccountCustomFieldsSchemaResponse' => '\\StructType\\GetAccountCustomFieldsSchemaResponse',
            'UpdateAccountCustomFieldsValuesRequest' => '\\StructType\\UpdateAccountCustomFieldsValuesRequest',
            'UpdateAccountCustomFieldsValuesResponse' => '\\StructType\\UpdateAccountCustomFieldsValuesResponse',
            'GetCustomerCustomFieldsValuesRequest' => '\\StructType\\GetCustomerCustomFieldsValuesRequest',
            'GetCustomerCustomFieldsValuesResponse' => '\\StructType\\GetCustomerCustomFieldsValuesResponse',
            'GetCustomerCustomFieldsSchemaRequest' => '\\StructType\\GetCustomerCustomFieldsSchemaRequest',
            'GetCustomerCustomFieldsSchemaResponse' => '\\StructType\\GetCustomerCustomFieldsSchemaResponse',
            'CustomFieldsInfo' => '\\StructType\\CustomFieldsInfo',
            'UpdateCustomerCustomFieldsValuesRequest' => '\\StructType\\UpdateCustomerCustomFieldsValuesRequest',
            'UpdateCustomerCustomFieldsValuesResponse' => '\\StructType\\UpdateCustomerCustomFieldsValuesResponse',
            'CustomFieldsValuesInfo' => '\\StructType\\CustomFieldsValuesInfo',
            'GetAccountMOHListInfoRequest' => '\\StructType\\GetAccountMOHListInfoRequest',
            'GetAccountMOHListInfoResponse' => '\\StructType\\GetAccountMOHListInfoResponse',
            'AccountMOHListInfo' => '\\StructType\\AccountMOHListInfo',
            'GetAccountPermittedProxyInfoRequest' => '\\StructType\\GetAccountPermittedProxyInfoRequest',
            'PermittedSipProxiesInfo' => '\\StructType\\PermittedSipProxiesInfo',
            'GetAccountPermittedProxyInfoResponse' => '\\StructType\\GetAccountPermittedProxyInfoResponse',
            'GetCustomerTransactionsTotalInfoRequest' => '\\StructType\\GetCustomerTransactionsTotalInfoRequest',
            'GetAccountTransactionsTotalInfoRequest' => '\\StructType\\GetAccountTransactionsTotalInfoRequest',
            'GetTransactionsTotalInfoResponse' => '\\StructType\\GetTransactionsTotalInfoResponse',
            'PerServiceInfo' => '\\StructType\\PerServiceInfo',
            'TotalTransInfo' => '\\StructType\\TotalTransInfo',
            'GetVersionRequest' => '\\StructType\\GetVersionRequest',
            'GetVersionResponse' => '\\StructType\\GetVersionResponse',
            'CustomerDIDProviderIdent' => '\\StructType\\CustomerDIDProviderIdent',
            'DIDRequestParameters' => '\\StructType\\DIDRequestParameters',
            'DIDCountryInfo' => '\\StructType\\DIDCountryInfo',
            'GetDIDCountriesListResponse' => '\\StructType\\GetDIDCountriesListResponse',
            'GetDIDCountriesListRequest' => '\\StructType\\GetDIDCountriesListRequest',
            'DIDCostsInfo' => '\\StructType\\DIDCostsInfo',
            'DIDPricing' => '\\StructType\\DIDPricing',
            'DIDAreaInfo' => '\\StructType\\DIDAreaInfo',
            'GetDIDAreasListResponse' => '\\StructType\\GetDIDAreasListResponse',
            'GetDIDAreasListRequest' => '\\StructType\\GetDIDAreasListRequest',
            'DIDNumberListInfo' => '\\StructType\\DIDNumberListInfo',
            'GetDIDNumbersListResponse' => '\\StructType\\GetDIDNumbersListResponse',
            'GetDIDNumbersListRequest' => '\\StructType\\GetDIDNumbersListRequest',
            'ProvisionDIDRequest' => '\\StructType\\ProvisionDIDRequest',
            'DIDNumberOrderInfo' => '\\StructType\\DIDNumberOrderInfo',
            'ProvisionDIDResponse' => '\\StructType\\ProvisionDIDResponse',
            'CancelDIDProvisionRequest' => '\\StructType\\CancelDIDProvisionRequest',
            'CancelDIDProvisionResponse' => '\\StructType\\CancelDIDProvisionResponse',
            'GetProviderInfoRequest' => '\\StructType\\GetProviderInfoRequest',
            'DIDProviderInfo' => '\\StructType\\DIDProviderInfo',
            'GetProviderInfoResponse' => '\\StructType\\GetProviderInfoResponse',
            'GetCustomerDIDNumbersRequest' => '\\StructType\\GetCustomerDIDNumbersRequest',
            'CustomerDIDNumberInfo' => '\\StructType\\CustomerDIDNumberInfo',
            'GetCustomerDIDNumbersResponse' => '\\StructType\\GetCustomerDIDNumbersResponse',
            'PhoneBookRecInfo' => '\\StructType\\PhoneBookRecInfo',
            'GetPhoneBookRecordRequest' => '\\StructType\\GetPhoneBookRecordRequest',
            'GetPhoneBookRecordResponse' => '\\StructType\\GetPhoneBookRecordResponse',
            'GetPhoneBookListRequest' => '\\StructType\\GetPhoneBookListRequest',
            'GetPhoneBookListResponse' => '\\StructType\\GetPhoneBookListResponse',
            'AddUpdatePhoneBookRecordRequest' => '\\StructType\\AddUpdatePhoneBookRecordRequest',
            'AddUpdatePhoneBookRecordResponse' => '\\StructType\\AddUpdatePhoneBookRecordResponse',
            'DeletePhoneBookRecordRequest' => '\\StructType\\DeletePhoneBookRecordRequest',
            'DeletePhoneBookRecordResponse' => '\\StructType\\DeletePhoneBookRecordResponse',
            'DeleteDIDNumberRequest' => '\\StructType\\DeleteDIDNumberRequest',
            'DeleteDIDNumberResponse' => '\\StructType\\DeleteDIDNumberResponse',
            'GetAccountStateRequest' => '\\StructType\\GetAccountStateRequest',
            'GetAccountStateResponse' => '\\StructType\\GetAccountStateResponse',
            'SetAccountStateRequest' => '\\StructType\\SetAccountStateRequest',
            'SetAccountStateResponse' => '\\StructType\\SetAccountStateResponse',
            'AssignDIDToAccountRequest' => '\\StructType\\AssignDIDToAccountRequest',
            'AssignDIDToAccountResponse' => '\\StructType\\AssignDIDToAccountResponse',
            'CancelDIDAssignmentRequest' => '\\StructType\\CancelDIDAssignmentRequest',
            'CancelDIDAssignmentResponse' => '\\StructType\\CancelDIDAssignmentResponse',
            'GetServiceFeaturesListRequest' => '\\StructType\\GetServiceFeaturesListRequest',
            'GetServiceFeaturesListResponse' => '\\StructType\\GetServiceFeaturesListResponse',
            'ServiceFeaturesList' => '\\StructType\\ServiceFeaturesList',
            'ServiceFeatureDetails' => '\\StructType\\ServiceFeatureDetails',
            'ServiceFeatureAttributeDetails' => '\\StructType\\ServiceFeatureAttributeDetails',
            'GetBrandPaneRequest' => '\\StructType\\GetBrandPaneRequest',
            'GetBrandPaneResponse' => '\\StructType\\GetBrandPaneResponse',
            'OverrideTariffInfo' => '\\StructType\\OverrideTariffInfo',
            'GetOverrideTariffRequest' => '\\StructType\\GetOverrideTariffRequest',
            'GetOverrideTariffResponse' => '\\StructType\\GetOverrideTariffResponse',
            'GetOverrideTariffListRequest' => '\\StructType\\GetOverrideTariffListRequest',
            'GetOverrideTariffListResponse' => '\\StructType\\GetOverrideTariffListResponse',
            'AddUpdateOverrideTariffRequest' => '\\StructType\\AddUpdateOverrideTariffRequest',
            'AddUpdateOverrideTariffResponse' => '\\StructType\\AddUpdateOverrideTariffResponse',
            'DeleteOverrideTariffRequest' => '\\StructType\\DeleteOverrideTariffRequest',
            'DeleteOverrideTariffResponse' => '\\StructType\\DeleteOverrideTariffResponse',
            'GetMyAclForObjectsRequest' => '\\StructType\\GetMyAclForObjectsRequest',
            'GetMyAclForObjectsResponse' => '\\StructType\\GetMyAclForObjectsResponse',
            'ObjectPermissions' => '\\StructType\\ObjectPermissions',
            'AttributePermission' => '\\StructType\\AttributePermission',
            'GetDiscountPlanListRequest' => '\\StructType\\GetDiscountPlanListRequest',
            'GetDiscountPlanListResponse' => '\\StructType\\GetDiscountPlanListResponse',
            'GetServiceListRequest' => '\\StructType\\GetServiceListRequest',
            'GetServiceListResponse' => '\\StructType\\GetServiceListResponse',
            'ServiceInfo' => '\\StructType\\ServiceInfo',
            'GetAccountConsumedServiceRequest' => '\\StructType\\GetAccountConsumedServiceRequest',
            'GetAccountConsumedServiceResponse' => '\\StructType\\GetAccountConsumedServiceResponse',
            'GetCustomerConsumedServiceRequest' => '\\StructType\\GetCustomerConsumedServiceRequest',
            'GetCustomerConsumedServiceResponse' => '\\StructType\\GetCustomerConsumedServiceResponse',
            'ConsumedServiceInfo' => '\\StructType\\ConsumedServiceInfo',
            'AddPeriodicalPaymentInfoRequest' => '\\StructType\\AddPeriodicalPaymentInfoRequest',
            'AddPeriodicalPaymentInfoResponse' => '\\StructType\\AddPeriodicalPaymentInfoResponse',
            'UpdatePeriodicalPaymentInfoRequest' => '\\StructType\\UpdatePeriodicalPaymentInfoRequest',
            'UpdatePeriodicalPaymentInfoResponse' => '\\StructType\\UpdatePeriodicalPaymentInfoResponse',
            'DeletePeriodicalPaymentRequest' => '\\StructType\\DeletePeriodicalPaymentRequest',
            'DeletePeriodicalPaymentResponse' => '\\StructType\\DeletePeriodicalPaymentResponse',
            'GetPeriodicalPaymentInfoRequest' => '\\StructType\\GetPeriodicalPaymentInfoRequest',
            'GetPeriodicalPaymentInfoResponse' => '\\StructType\\GetPeriodicalPaymentInfoResponse',
            'GetPeriodicalPaymentListRequest' => '\\StructType\\GetPeriodicalPaymentListRequest',
            'GetPeriodicalPaymentListResponse' => '\\StructType\\GetPeriodicalPaymentListResponse',
            'PeriodicalPaymentInfo' => '\\StructType\\PeriodicalPaymentInfo',
            'GetConferenceSettingsRequest' => '\\StructType\\GetConferenceSettingsRequest',
            'GetConferenceSettingsResponse' => '\\StructType\\GetConferenceSettingsResponse',
            'GetPaymentMethodsForOwnerRequest' => '\\StructType\\GetPaymentMethodsForOwnerRequest',
            'GetPaymentMethodsForOwnerResponse' => '\\StructType\\GetPaymentMethodsForOwnerResponse',
            'PaymentSystemInfo' => '\\StructType\\PaymentSystemInfo',
            'RegisterTransactionRequest' => '\\StructType\\RegisterTransactionRequest',
            'AccountRegisterTransactionRequest' => '\\StructType\\AccountRegisterTransactionRequest',
            'CustomerRegisterTransactionRequest' => '\\StructType\\CustomerRegisterTransactionRequest',
            'TransactionInfo' => '\\StructType\\TransactionInfo',
            'RegisterTransactionResponse' => '\\StructType\\RegisterTransactionResponse',
            'AccountRegisterTransactionResponse' => '\\StructType\\AccountRegisterTransactionResponse',
            'CustomerRegisterTransactionResponse' => '\\StructType\\CustomerRegisterTransactionResponse',
            'GetPaymentTransactionRequest' => '\\StructType\\GetPaymentTransactionRequest',
            'GetPaymentTransactionResponse' => '\\StructType\\GetPaymentTransactionResponse',
            'GetActiveCallsRequest' => '\\StructType\\GetActiveCallsRequest',
            'GetCustomerSitesRequest' => '\\StructType\\GetCustomerSitesRequest',
            'GetCustomerSitesResponse' => '\\StructType\\GetCustomerSitesResponse',
            'CustomerSiteInfo' => '\\StructType\\CustomerSiteInfo',
            'GetSiteInfoRequest' => '\\StructType\\GetSiteInfoRequest',
            'GetSiteInfoResponse' => '\\StructType\\GetSiteInfoResponse',
            'AddCustomerSiteRequest' => '\\StructType\\AddCustomerSiteRequest',
            'AddCustomerSiteResponse' => '\\StructType\\AddCustomerSiteResponse',
            'UpdateCustomerSiteRequest' => '\\StructType\\UpdateCustomerSiteRequest',
            'UpdateCustomerSiteResponse' => '\\StructType\\UpdateCustomerSiteResponse',
            'DeleteCustomerSiteRequest' => '\\StructType\\DeleteCustomerSiteRequest',
            'DeleteCustomerSiteResponse' => '\\StructType\\DeleteCustomerSiteResponse',
            'GetNetworkConnectivityListRequest' => '\\StructType\\GetNetworkConnectivityListRequest',
            'GetNetworkConnectivityListResponse' => '\\StructType\\GetNetworkConnectivityListResponse',
            'NetworkConnectivityInfo' => '\\StructType\\NetworkConnectivityInfo',
            'AuthzRuleInfo' => '\\StructType\\AuthzRuleInfo',
            'GetAuthzRuleListRequest' => '\\StructType\\GetAuthzRuleListRequest',
            'GetAuthzRuleListResponse' => '\\StructType\\GetAuthzRuleListResponse',
            'AddUpdateAuthzRuleRequest' => '\\StructType\\AddUpdateAuthzRuleRequest',
            'AddUpdateAuthzRuleResponse' => '\\StructType\\AddUpdateAuthzRuleResponse',
            'DeleteAuthzRuleRequest' => '\\StructType\\DeleteAuthzRuleRequest',
            'DeleteAuthzRuleResponse' => '\\StructType\\DeleteAuthzRuleResponse',
            'GetActiveCallsResponse' => '\\StructType\\GetActiveCallsResponse',
            'ActiveCallInfo' => '\\StructType\\ActiveCallInfo',
            'ManageActiveCallRecordingRequest' => '\\StructType\\ManageActiveCallRecordingRequest',
            'ManageActiveCallRecordingResponse' => '\\StructType\\ManageActiveCallRecordingResponse',
            'GetCustomerStatusHistoryRequest' => '\\StructType\\GetCustomerStatusHistoryRequest',
            'GetCustomerStatusHistoryResponse' => '\\StructType\\GetCustomerStatusHistoryResponse',
            'StatusHistoryInfo' => '\\StructType\\StatusHistoryInfo',
            'InvoiceTemplateInfo' => '\\StructType\\InvoiceTemplateInfo',
            'GetInvoiceTemplateListRequest' => '\\StructType\\GetInvoiceTemplateListRequest',
            'GetInvoiceTemplateListResponse' => '\\StructType\\GetInvoiceTemplateListResponse',
            'AddVendorRequest' => '\\StructType\\AddVendorRequest',
            'AddVendorResponse' => '\\StructType\\AddVendorResponse',
            'UpdateVendorRequest' => '\\StructType\\UpdateVendorRequest',
            'UpdateVendorResponse' => '\\StructType\\UpdateVendorResponse',
            'DeleteVendorRequest' => '\\StructType\\DeleteVendorRequest',
            'DeleteVendorResponse' => '\\StructType\\DeleteVendorResponse',
            'GetVendorInfoRequest' => '\\StructType\\GetVendorInfoRequest',
            'GetVendorInfoResponse' => '\\StructType\\GetVendorInfoResponse',
            'GetVendorListRequest' => '\\StructType\\GetVendorListRequest',
            'GetVendorListResponse' => '\\StructType\\GetVendorListResponse',
            'MakeVendorTransactionRequest' => '\\StructType\\MakeVendorTransactionRequest',
            'MakeVendorTransactionResponse' => '\\StructType\\MakeVendorTransactionResponse',
            'VendorInfo' => '\\StructType\\VendorInfo',
            'AddConnectionRequest' => '\\StructType\\AddConnectionRequest',
            'AddConnectionResponse' => '\\StructType\\AddConnectionResponse',
            'UpdateConnectionRequest' => '\\StructType\\UpdateConnectionRequest',
            'UpdateConnectionResponse' => '\\StructType\\UpdateConnectionResponse',
            'DeleteConnectionRequest' => '\\StructType\\DeleteConnectionRequest',
            'DeleteConnectionResponse' => '\\StructType\\DeleteConnectionResponse',
            'GetConnectionInfoRequest' => '\\StructType\\GetConnectionInfoRequest',
            'GetConnectionInfoResponse' => '\\StructType\\GetConnectionInfoResponse',
            'GetConnectionListRequest' => '\\StructType\\GetConnectionListRequest',
            'GetConnectionListResponse' => '\\StructType\\GetConnectionListResponse',
            'ConnectionInfo' => '\\StructType\\ConnectionInfo',
            'AddUserRequest' => '\\StructType\\AddUserRequest',
            'AddUserResponse' => '\\StructType\\AddUserResponse',
            'UpdateUserRequest' => '\\StructType\\UpdateUserRequest',
            'UpdateUserResponse' => '\\StructType\\UpdateUserResponse',
            'DeleteUserRequest' => '\\StructType\\DeleteUserRequest',
            'DeleteUserResponse' => '\\StructType\\DeleteUserResponse',
            'GetUserInfoRequest' => '\\StructType\\GetUserInfoRequest',
            'GetUserInfoResponse' => '\\StructType\\GetUserInfoResponse',
            'GetUserInfoListRequest' => '\\StructType\\GetUserInfoListRequest',
            'GetUserInfoListResponse' => '\\StructType\\GetUserInfoListResponse',
            'UserInfo' => '\\StructType\\UserInfo',
            'TimeZoneInfo' => '\\StructType\\TimeZoneInfo',
            'GetTimeZoneInfoRequest' => '\\StructType\\GetTimeZoneInfoRequest',
            'GetTimeZoneInfoResponse' => '\\StructType\\GetTimeZoneInfoResponse',
            'GetTimeZoneListRequest' => '\\StructType\\GetTimeZoneListRequest',
            'GetTimeZoneListResponse' => '\\StructType\\GetTimeZoneListResponse',
            'CurrencyInfo' => '\\StructType\\CurrencyInfo',
            'AddCurrencyRequest' => '\\StructType\\AddCurrencyRequest',
            'AddCurrencyResponse' => '\\StructType\\AddCurrencyResponse',
            'UpdateCurrencyRequest' => '\\StructType\\UpdateCurrencyRequest',
            'UpdateCurrencyResponse' => '\\StructType\\UpdateCurrencyResponse',
            'DeleteCurrencyRequest' => '\\StructType\\DeleteCurrencyRequest',
            'DeleteCurrencyResponse' => '\\StructType\\DeleteCurrencyResponse',
            'GetCurrencyInfoRequest' => '\\StructType\\GetCurrencyInfoRequest',
            'GetCurrencyInfoResponse' => '\\StructType\\GetCurrencyInfoResponse',
            'GetCurrencyListRequest' => '\\StructType\\GetCurrencyListRequest',
            'GetCurrencyListResponse' => '\\StructType\\GetCurrencyListResponse',
            'AddDiscountRequest' => '\\StructType\\AddDiscountRequest',
            'AddDiscountResponse' => '\\StructType\\AddDiscountResponse',
            'UpdateDiscountRequest' => '\\StructType\\UpdateDiscountRequest',
            'UpdateDiscountResponse' => '\\StructType\\UpdateDiscountResponse',
            'DeleteDiscountRequest' => '\\StructType\\DeleteDiscountRequest',
            'DeleteDiscountResponse' => '\\StructType\\DeleteDiscountResponse',
            'GetDiscountInfoRequest' => '\\StructType\\GetDiscountInfoRequest',
            'GetDiscountInfoResponse' => '\\StructType\\GetDiscountInfoResponse',
            'ChargeCustomerSubscriptionFeesRequest' => '\\StructType\\ChargeCustomerSubscriptionFeesRequest',
            'ChargeCustomerSubscriptionFeesResponse' => '\\StructType\\ChargeCustomerSubscriptionFeesResponse',
            'ChargeAccountSubscriptionFeesRequest' => '\\StructType\\ChargeAccountSubscriptionFeesRequest',
            'ChargeAccountSubscriptionFeesResponse' => '\\StructType\\ChargeAccountSubscriptionFeesResponse',
            'MarkXdrOutOfTurnRequest' => '\\StructType\\MarkXdrOutOfTurnRequest',
            'MarkXdrOutOfTurnResponse' => '\\StructType\\MarkXdrOutOfTurnResponse',
            'GenerateOutOfTurnInvoiceRequest' => '\\StructType\\GenerateOutOfTurnInvoiceRequest',
            'GenerateOutOfTurnInvoiceResponse' => '\\StructType\\GenerateOutOfTurnInvoiceResponse',
            'OutOfTurnXDRInfo' => '\\StructType\\OutOfTurnXDRInfo',
            'AddServiceAndRatingRequest' => '\\StructType\\AddServiceAndRatingRequest',
            'AddServiceAndRatingResponse' => '\\StructType\\AddServiceAndRatingResponse',
            'UpdateServiceAndRatingRequest' => '\\StructType\\UpdateServiceAndRatingRequest',
            'UpdateServiceAndRatingResponse' => '\\StructType\\UpdateServiceAndRatingResponse',
            'DeleteServiceAndRatingRequest' => '\\StructType\\DeleteServiceAndRatingRequest',
            'DeleteServiceAndRatingResponse' => '\\StructType\\DeleteServiceAndRatingResponse',
            'GetServiceAndRatingInfoRequest' => '\\StructType\\GetServiceAndRatingInfoRequest',
            'GetServiceAndRatingInfoResponse' => '\\StructType\\GetServiceAndRatingInfoResponse',
            'GetServiceAndRatingListRequest' => '\\StructType\\GetServiceAndRatingListRequest',
            'GetServiceAndRatingListResponse' => '\\StructType\\GetServiceAndRatingListResponse',
            'ServiceAndRatingInfo' => '\\StructType\\ServiceAndRatingInfo',
            'ServiceAndRatingRoutingInfo' => '\\StructType\\ServiceAndRatingRoutingInfo',
            'AddVendorAccountRequest' => '\\StructType\\AddVendorAccountRequest',
            'AddVendorAccountResponse' => '\\StructType\\AddVendorAccountResponse',
            'UpdateVendorAccountRequest' => '\\StructType\\UpdateVendorAccountRequest',
            'UpdateVendorAccountResponse' => '\\StructType\\UpdateVendorAccountResponse',
            'DeleteVendorAccountRequest' => '\\StructType\\DeleteVendorAccountRequest',
            'DeleteVendorAccountResponse' => '\\StructType\\DeleteVendorAccountResponse',
            'GetVendorAccountInfoRequest' => '\\StructType\\GetVendorAccountInfoRequest',
            'GetVendorAccountInfoResponse' => '\\StructType\\GetVendorAccountInfoResponse',
            'GetVendorAccountListRequest' => '\\StructType\\GetVendorAccountListRequest',
            'GetVendorAccountListResponse' => '\\StructType\\GetVendorAccountListResponse',
            'VendorAccountInfo' => '\\StructType\\VendorAccountInfo',
            'AutoPaymentInfo' => '\\StructType\\AutoPaymentInfo',
            'AddUpdateAutoPaymentInfoRequest' => '\\StructType\\AddUpdateAutoPaymentInfoRequest',
            'AddUpdateAutoPaymentInfoResponse' => '\\StructType\\AddUpdateAutoPaymentInfoResponse',
            'DeleteAutoPaymentRequest' => '\\StructType\\DeleteAutoPaymentRequest',
            'DeleteAutoPaymentResponse' => '\\StructType\\DeleteAutoPaymentResponse',
            'GetAutoPaymentInfoRequest' => '\\StructType\\GetAutoPaymentInfoRequest',
            'GetAutoPaymentInfoResponse' => '\\StructType\\GetAutoPaymentInfoResponse',
            'RoutingPlanInfo' => '\\StructType\\RoutingPlanInfo',
            'AddUpdateRoutingPlanRequest' => '\\StructType\\AddUpdateRoutingPlanRequest',
            'AddUpdateRoutingPlanResponse' => '\\StructType\\AddUpdateRoutingPlanResponse',
            'DeleteRoutingPlanRequest' => '\\StructType\\DeleteRoutingPlanRequest',
            'DeleteRoutingPlanResponse' => '\\StructType\\DeleteRoutingPlanResponse',
            'GetRoutingPlanInfoRequest' => '\\StructType\\GetRoutingPlanInfoRequest',
            'GetRoutingPlanInfoResponse' => '\\StructType\\GetRoutingPlanInfoResponse',
            'GetRoutingPlanListRequest' => '\\StructType\\GetRoutingPlanListRequest',
            'GetRoutingPlanListResponse' => '\\StructType\\GetRoutingPlanListResponse',
            'RPConnectionInfo' => '\\StructType\\RPConnectionInfo',
            'AddUpdateRPConnectionRequest' => '\\StructType\\AddUpdateRPConnectionRequest',
            'AddUpdateRPConnectionResponse' => '\\StructType\\AddUpdateRPConnectionResponse',
            'DeleteRPConnectionRequest' => '\\StructType\\DeleteRPConnectionRequest',
            'DeleteRPConnectionResponse' => '\\StructType\\DeleteRPConnectionResponse',
            'GetRPConnectionInfoRequest' => '\\StructType\\GetRPConnectionInfoRequest',
            'GetRPConnectionInfoResponse' => '\\StructType\\GetRPConnectionInfoResponse',
            'GetRPConnectionListRequest' => '\\StructType\\GetRPConnectionListRequest',
            'GetRPConnectionListResponse' => '\\StructType\\GetRPConnectionListResponse',
            'RouteInfo' => '\\StructType\\RouteInfo',
            'GetRouteListRequest' => '\\StructType\\GetRouteListRequest',
            'GetRouteListResponse' => '\\StructType\\GetRouteListResponse',
            'XrateInfo' => '\\StructType\\XrateInfo',
            'GetXrateListRequest' => '\\StructType\\GetXrateListRequest',
            'GetXrateListResponse' => '\\StructType\\GetXrateListResponse',
            'ValidateAddonsCombinationRequest' => '\\StructType\\ValidateAddonsCombinationRequest',
            'ValidateAddonsCombinationResponse' => '\\StructType\\ValidateAddonsCombinationResponse',
            'AddonsValidationResults' => '\\StructType\\AddonsValidationResults',
            'DisallowedProducts' => '\\StructType\\DisallowedProducts',
            'ServiceFeaturesConflicts' => '\\StructType\\ServiceFeaturesConflicts',
            'ConflictingAddOns' => '\\StructType\\ConflictingAddOns',
            'GetAllowedAddonsRequest' => '\\StructType\\GetAllowedAddonsRequest',
            'GetAllowedAddonsResponse' => '\\StructType\\GetAllowedAddonsResponse',
            'UpdateAccountTimer' => '\\StructType\\UpdateAccountTimer',
            'UpdateAccountTimerResponse' => '\\StructType\\UpdateAccountTimerResponse',
            'UpdateAccountTimerRequest' => '\\StructType\\UpdateAccountTimerRequest',
            'WCGetSubscriptionPlanInfoRequest' => '\\StructType\\WCGetSubscriptionPlanInfoRequest',
            'WCGetSubscriptionPlanInfoResponse' => '\\StructType\\WCGetSubscriptionPlanInfoResponse',
            'WCAddSubscriptionPlanInfoRequest' => '\\StructType\\WCAddSubscriptionPlanInfoRequest',
            'WCUpdateSubscriptionPlanInfoRequest' => '\\StructType\\WCUpdateSubscriptionPlanInfoRequest',
            'WCAddUpdateSubscriptionPlanInfoResponse' => '\\StructType\\WCAddUpdateSubscriptionPlanInfoResponse',
            'WCSubscriptionPlanInfo' => '\\StructType\\WCSubscriptionPlanInfo',
            'WCSubscriptionFee' => '\\StructType\\WCSubscriptionFee',
            'WCSubscriptionFeeRate' => '\\StructType\\WCSubscriptionFeeRate',
            'WCAddSubscriptionPlanRequest' => '\\StructType\\WCAddSubscriptionPlanRequest',
            'WCGetCardInventoryRequest' => '\\StructType\\WCGetCardInventoryRequest',
            'WCGetCardInventoryResponse' => '\\StructType\\WCGetCardInventoryResponse',
            'WCCardInventoryEntryInfo' => '\\StructType\\WCCardInventoryEntryInfo',
            'WCGetProductTariffsRequest' => '\\StructType\\WCGetProductTariffsRequest',
            'WCGetProductTariffsResponse' => '\\StructType\\WCGetProductTariffsResponse',
            'WCProductTariffInfo' => '\\StructType\\WCProductTariffInfo',
            'WCAddRouteCategoryRequest' => '\\StructType\\WCAddRouteCategoryRequest',
            'WCAddRouteCategoryResponse' => '\\StructType\\WCAddRouteCategoryResponse',
            'WCRouteCategoryInfo' => '\\StructType\\WCRouteCategoryInfo',
            'WCAddRoutingPlanRequest' => '\\StructType\\WCAddRoutingPlanRequest',
            'WCAddRoutingPlanResponse' => '\\StructType\\WCAddRoutingPlanResponse',
            'WCRoutingPlanInfo' => '\\StructType\\WCRoutingPlanInfo',
            'WCAddRoutingPlanCategoryRequest' => '\\StructType\\WCAddRoutingPlanCategoryRequest',
            'WCAddRoutingPlanCategoryResponse' => '\\StructType\\WCAddRoutingPlanCategoryResponse',
            'WCRoutingPlanCategoryInfo' => '\\StructType\\WCRoutingPlanCategoryInfo',
            'WCAddServiceRatingRequest' => '\\StructType\\WCAddServiceRatingRequest',
            'WCAddServiceRatingResponse' => '\\StructType\\WCAddServiceRatingResponse',
            'WCServiceRatingInfo' => '\\StructType\\WCServiceRatingInfo',
            'WCAddTariffTemplateBindingRequest' => '\\StructType\\WCAddTariffTemplateBindingRequest',
            'WCAddTariffTemplateBindingResponse' => '\\StructType\\WCAddTariffTemplateBindingResponse',
            'WCTariffTemplateBindingInfo' => '\\StructType\\WCTariffTemplateBindingInfo',
            'WCGetSubscriptionsRequest' => '\\StructType\\WCGetSubscriptionsRequest',
            'WCGetSubscriptionsResponse' => '\\StructType\\WCGetSubscriptionsResponse',
            'WCSubscriptionInfo' => '\\StructType\\WCSubscriptionInfo',
            'WCUpdateAccountNotepadRequest' => '\\StructType\\WCUpdateAccountNotepadRequest',
            'WCUpdateAccountNotepadResponse' => '\\StructType\\WCUpdateAccountNotepadResponse',
            'WCUpdateCustomerNotepadRequest' => '\\StructType\\WCUpdateCustomerNotepadRequest',
            'WCUpdateCustomerNotepadResponse' => '\\StructType\\WCUpdateCustomerNotepadResponse',
            'WCGetAccountIDRequest' => '\\StructType\\WCGetAccountIDRequest',
            'WCGetAccountIDResponse' => '\\StructType\\WCGetAccountIDResponse',
            'WCIPlifeGetNewWiFiIDRequest' => '\\StructType\\WCIPlifeGetNewWiFiIDRequest',
            'WCIPlifeGetNewWiFiIDResponse' => '\\StructType\\WCIPlifeGetNewWiFiIDResponse',
        );
    }
}
