<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lowbalanceinput StructType
 * @subpackage Structs
 */
class Lowbalanceinput extends AbstractStructBase
{
    /**
     * The airtimeBalance
     * @var string
     */
    public $airtimeBalance;
    /**
     * The lowBalanceType
     * @var int
     */
    public $lowBalanceType;
    /**
     * The MIN
     * @var string
     */
    public $MIN;
    /**
     * The partnerTimestamp
     * @var string
     */
    public $partnerTimestamp;
    /**
     * The transactionID
     * @var string
     */
    public $transactionID;
    /**
     * Constructor method for lowbalanceinput
     * @uses Lowbalanceinput::setAirtimeBalance()
     * @uses Lowbalanceinput::setLowBalanceType()
     * @uses Lowbalanceinput::setMIN()
     * @uses Lowbalanceinput::setPartnerTimestamp()
     * @uses Lowbalanceinput::setTransactionID()
     * @param string $airtimeBalance
     * @param int $lowBalanceType
     * @param string $mIN
     * @param string $partnerTimestamp
     * @param string $transactionID
     */
    public function __construct($airtimeBalance = null, $lowBalanceType = null, $mIN = null, $partnerTimestamp = null, $transactionID = null)
    {
        $this
            ->setAirtimeBalance($airtimeBalance)
            ->setLowBalanceType($lowBalanceType)
            ->setMIN($mIN)
            ->setPartnerTimestamp($partnerTimestamp)
            ->setTransactionID($transactionID);
    }
    /**
     * Get airtimeBalance value
     * @return string|null
     */
    public function getAirtimeBalance()
    {
        return $this->airtimeBalance;
    }
    /**
     * Set airtimeBalance value
     * @param string $airtimeBalance
     * @return \StructType\Lowbalanceinput
     */
    public function setAirtimeBalance($airtimeBalance = null)
    {
        // validation for constraint: string
        if (!is_null($airtimeBalance) && !is_string($airtimeBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airtimeBalance, true), gettype($airtimeBalance)), __LINE__);
        }
        $this->airtimeBalance = $airtimeBalance;
        return $this;
    }
    /**
     * Get lowBalanceType value
     * @return int|null
     */
    public function getLowBalanceType()
    {
        return $this->lowBalanceType;
    }
    /**
     * Set lowBalanceType value
     * @param int $lowBalanceType
     * @return \StructType\Lowbalanceinput
     */
    public function setLowBalanceType($lowBalanceType = null)
    {
        // validation for constraint: int
        if (!is_null($lowBalanceType) && !(is_int($lowBalanceType) || ctype_digit($lowBalanceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lowBalanceType, true), gettype($lowBalanceType)), __LINE__);
        }
        $this->lowBalanceType = $lowBalanceType;
        return $this;
    }
    /**
     * Get MIN value
     * @return string|null
     */
    public function getMIN()
    {
        return $this->MIN;
    }
    /**
     * Set MIN value
     * @param string $mIN
     * @return \StructType\Lowbalanceinput
     */
    public function setMIN($mIN = null)
    {
        // validation for constraint: string
        if (!is_null($mIN) && !is_string($mIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIN, true), gettype($mIN)), __LINE__);
        }
        $this->MIN = $mIN;
        return $this;
    }
    /**
     * Get partnerTimestamp value
     * @return string|null
     */
    public function getPartnerTimestamp()
    {
        return $this->partnerTimestamp;
    }
    /**
     * Set partnerTimestamp value
     * @param string $partnerTimestamp
     * @return \StructType\Lowbalanceinput
     */
    public function setPartnerTimestamp($partnerTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($partnerTimestamp) && !is_string($partnerTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerTimestamp, true), gettype($partnerTimestamp)), __LINE__);
        }
        $this->partnerTimestamp = $partnerTimestamp;
        return $this;
    }
    /**
     * Get transactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->transactionID;
    }
    /**
     * Set transactionID value
     * @param string $transactionID
     * @return \StructType\Lowbalanceinput
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->transactionID = $transactionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lowbalanceinput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
