<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Low ServiceType
 * @subpackage Services
 */
class Low extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lowBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Data_roaming_request $data_roaming_request
     * @return string|bool
     */
    public function lowBalance(\StructType\Data_roaming_request $data_roaming_request)
    {
        try {
            $this->setResult($this->getSoapClient()->lowBalance($data_roaming_request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
