<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \cosolis\CosolisClassMap::get(),
);
/**
 * Samples for Track ServiceType
 */
$track = new \cosolis\ServiceType\CosolisTrack($options);
/**
 * Sample call for track operation/method
 */
if ($track->track(new \cosolis\StructType\CosolisTrackRequest()) !== false) {
    print_r($track->getResult());
} else {
    print_r($track->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \cosolis\ServiceType\CosolisGet($options);
/**
 * Sample call for getTrackingDocuments operation/method
 */
if ($get->getTrackingDocuments(new \cosolis\StructType\CosolisGetTrackingDocumentsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \cosolis\ServiceType\CosolisSend($options);
/**
 * Sample call for sendNotifications operation/method
 */
if ($send->sendNotifications(new \cosolis\StructType\CosolisSendNotificationsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
