<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Weight StructType
 * Meta information extracted from the WSDL
 * - documentation: The descriptive data for the heaviness of an object.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisWeight extends AbstractStructBase
{
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - documentation: Identifies the unit of measure associated with a weight value.
     * - minOccurs: 0
     * @var string
     */
    public $Units;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Identifies the weight value of a package/shipment.
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for Weight
     * @uses CosolisWeight::setUnits()
     * @uses CosolisWeight::setValue()
     * @param string $units
     * @param float $value
     */
    public function __construct($units = null, $value = null)
    {
        $this
            ->setUnits($units)
            ->setValue($value);
    }
    /**
     * Get Units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @uses \cosolis\EnumType\CosolisWeightUnits::valueIsValid()
     * @uses \cosolis\EnumType\CosolisWeightUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $units
     * @return \cosolis\StructType\CosolisWeight
     */
    public function setUnits($units = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisWeightUnits::valueIsValid($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisWeightUnits', is_array($units) ? implode(', ', $units) : var_export($units, true), implode(', ', \cosolis\EnumType\CosolisWeightUnits::getValidValues())), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \cosolis\StructType\CosolisWeight
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisWeight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
