<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebAuthenticationDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Used in authentication of the sender's identity.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisWebAuthenticationDetail extends AbstractStructBase
{
    /**
     * The UserCredential
     * Meta information extracted from the WSDL
     * - documentation: Credential used to authenticate a specific software application. This value is provided by FedEx after registration.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisWebAuthenticationCredential
     */
    public $UserCredential;
    /**
     * The ParentCredential
     * Meta information extracted from the WSDL
     * - documentation: This was renamed from cspCredential.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisWebAuthenticationCredential
     */
    public $ParentCredential;
    /**
     * Constructor method for WebAuthenticationDetail
     * @uses CosolisWebAuthenticationDetail::setUserCredential()
     * @uses CosolisWebAuthenticationDetail::setParentCredential()
     * @param \cosolis\StructType\CosolisWebAuthenticationCredential $userCredential
     * @param \cosolis\StructType\CosolisWebAuthenticationCredential $parentCredential
     */
    public function __construct(\cosolis\StructType\CosolisWebAuthenticationCredential $userCredential = null, \cosolis\StructType\CosolisWebAuthenticationCredential $parentCredential = null)
    {
        $this
            ->setUserCredential($userCredential)
            ->setParentCredential($parentCredential);
    }
    /**
     * Get UserCredential value
     * @return \cosolis\StructType\CosolisWebAuthenticationCredential
     */
    public function getUserCredential()
    {
        return $this->UserCredential;
    }
    /**
     * Set UserCredential value
     * @param \cosolis\StructType\CosolisWebAuthenticationCredential $userCredential
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public function setUserCredential(\cosolis\StructType\CosolisWebAuthenticationCredential $userCredential = null)
    {
        $this->UserCredential = $userCredential;
        return $this;
    }
    /**
     * Get ParentCredential value
     * @return \cosolis\StructType\CosolisWebAuthenticationCredential|null
     */
    public function getParentCredential()
    {
        return $this->ParentCredential;
    }
    /**
     * Set ParentCredential value
     * @param \cosolis\StructType\CosolisWebAuthenticationCredential $parentCredential
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public function setParentCredential(\cosolis\StructType\CosolisWebAuthenticationCredential $parentCredential = null)
    {
        $this->ParentCredential = $parentCredential;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
