<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDocumentSpecification StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackingDocumentSpecification extends AbstractStructBase
{
    /**
     * The DocumentTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DocumentTypes;
    /**
     * The BillOfLadingDocumentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail
     */
    public $BillOfLadingDocumentDetail;
    /**
     * The FreightBillingDocumentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail
     */
    public $FreightBillingDocumentDetail;
    /**
     * The SignatureProofOfDeliveryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail
     */
    public $SignatureProofOfDeliveryDetail;
    /**
     * Constructor method for TrackingDocumentSpecification
     * @uses CosolisTrackingDocumentSpecification::setDocumentTypes()
     * @uses CosolisTrackingDocumentSpecification::setBillOfLadingDocumentDetail()
     * @uses CosolisTrackingDocumentSpecification::setFreightBillingDocumentDetail()
     * @uses CosolisTrackingDocumentSpecification::setSignatureProofOfDeliveryDetail()
     * @param string[] $documentTypes
     * @param \cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail $billOfLadingDocumentDetail
     * @param \cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail $freightBillingDocumentDetail
     * @param \cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail $signatureProofOfDeliveryDetail
     */
    public function __construct(array $documentTypes = array(), \cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail $billOfLadingDocumentDetail = null, \cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail $freightBillingDocumentDetail = null, \cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail $signatureProofOfDeliveryDetail = null)
    {
        $this
            ->setDocumentTypes($documentTypes)
            ->setBillOfLadingDocumentDetail($billOfLadingDocumentDetail)
            ->setFreightBillingDocumentDetail($freightBillingDocumentDetail)
            ->setSignatureProofOfDeliveryDetail($signatureProofOfDeliveryDetail);
    }
    /**
     * Get DocumentTypes value
     * @return string[]|null
     */
    public function getDocumentTypes()
    {
        return $this->DocumentTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentTypesForArrayConstraintsFromSetDocumentTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentSpecificationDocumentTypesItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid($trackingDocumentSpecificationDocumentTypesItem)) {
                $invalidValues[] = is_object($trackingDocumentSpecificationDocumentTypesItem) ? get_class($trackingDocumentSpecificationDocumentTypesItem) : sprintf('%s(%s)', gettype($trackingDocumentSpecificationDocumentTypesItem), var_export($trackingDocumentSpecificationDocumentTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentTypes value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $documentTypes
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public function setDocumentTypes(array $documentTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($documentTypesArrayErrorMessage = self::validateDocumentTypesForArrayConstraintsFromSetDocumentTypes($documentTypes))) {
            throw new \InvalidArgumentException($documentTypesArrayErrorMessage, __LINE__);
        }
        $this->DocumentTypes = $documentTypes;
        return $this;
    }
    /**
     * Add item to DocumentTypes value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public function addToDocumentTypes($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues())), __LINE__);
        }
        $this->DocumentTypes[] = $item;
        return $this;
    }
    /**
     * Get BillOfLadingDocumentDetail value
     * @return \cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail|null
     */
    public function getBillOfLadingDocumentDetail()
    {
        return $this->BillOfLadingDocumentDetail;
    }
    /**
     * Set BillOfLadingDocumentDetail value
     * @param \cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail $billOfLadingDocumentDetail
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public function setBillOfLadingDocumentDetail(\cosolis\StructType\CosolisTrackingBillOfLadingDocumentDetail $billOfLadingDocumentDetail = null)
    {
        $this->BillOfLadingDocumentDetail = $billOfLadingDocumentDetail;
        return $this;
    }
    /**
     * Get FreightBillingDocumentDetail value
     * @return \cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail|null
     */
    public function getFreightBillingDocumentDetail()
    {
        return $this->FreightBillingDocumentDetail;
    }
    /**
     * Set FreightBillingDocumentDetail value
     * @param \cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail $freightBillingDocumentDetail
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public function setFreightBillingDocumentDetail(\cosolis\StructType\CosolisTrackingFreightBillingDocumentDetail $freightBillingDocumentDetail = null)
    {
        $this->FreightBillingDocumentDetail = $freightBillingDocumentDetail;
        return $this;
    }
    /**
     * Get SignatureProofOfDeliveryDetail value
     * @return \cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail|null
     */
    public function getSignatureProofOfDeliveryDetail()
    {
        return $this->SignatureProofOfDeliveryDetail;
    }
    /**
     * Set SignatureProofOfDeliveryDetail value
     * @param \cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail $signatureProofOfDeliveryDetail
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public function setSignatureProofOfDeliveryDetail(\cosolis\StructType\CosolisTrackingSignatureProofOfDeliveryDetail $signatureProofOfDeliveryDetail = null)
    {
        $this->SignatureProofOfDeliveryDetail = $signatureProofOfDeliveryDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
