<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDocumentFormat StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackingDocumentFormat extends AbstractStructBase
{
    /**
     * The Dispositions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingDocumentDispositionDetail[]
     */
    public $Dispositions;
    /**
     * The Grouping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Grouping;
    /**
     * The ImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageType;
    /**
     * The Localization
     * Meta information extracted from the WSDL
     * - documentation: The localization for the generated document.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisLocalization
     */
    public $Localization;
    /**
     * Constructor method for TrackingDocumentFormat
     * @uses CosolisTrackingDocumentFormat::setDispositions()
     * @uses CosolisTrackingDocumentFormat::setGrouping()
     * @uses CosolisTrackingDocumentFormat::setImageType()
     * @uses CosolisTrackingDocumentFormat::setLocalization()
     * @param \cosolis\StructType\CosolisTrackingDocumentDispositionDetail[] $dispositions
     * @param string $grouping
     * @param string $imageType
     * @param \cosolis\StructType\CosolisLocalization $localization
     */
    public function __construct(array $dispositions = array(), $grouping = null, $imageType = null, \cosolis\StructType\CosolisLocalization $localization = null)
    {
        $this
            ->setDispositions($dispositions)
            ->setGrouping($grouping)
            ->setImageType($imageType)
            ->setLocalization($localization);
    }
    /**
     * Get Dispositions value
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail[]|null
     */
    public function getDispositions()
    {
        return $this->Dispositions;
    }
    /**
     * This method is responsible for validating the values passed to the setDispositions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDispositions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDispositionsForArrayConstraintsFromSetDispositions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentFormatDispositionsItem) {
            // validation for constraint: itemType
            if (!$trackingDocumentFormatDispositionsItem instanceof \cosolis\StructType\CosolisTrackingDocumentDispositionDetail) {
                $invalidValues[] = is_object($trackingDocumentFormatDispositionsItem) ? get_class($trackingDocumentFormatDispositionsItem) : sprintf('%s(%s)', gettype($trackingDocumentFormatDispositionsItem), var_export($trackingDocumentFormatDispositionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dispositions property can only contain items of type \cosolis\StructType\CosolisTrackingDocumentDispositionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dispositions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDocumentDispositionDetail[] $dispositions
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public function setDispositions(array $dispositions = array())
    {
        // validation for constraint: array
        if ('' !== ($dispositionsArrayErrorMessage = self::validateDispositionsForArrayConstraintsFromSetDispositions($dispositions))) {
            throw new \InvalidArgumentException($dispositionsArrayErrorMessage, __LINE__);
        }
        $this->Dispositions = $dispositions;
        return $this;
    }
    /**
     * Add item to Dispositions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDocumentDispositionDetail $item
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public function addToDispositions(\cosolis\StructType\CosolisTrackingDocumentDispositionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackingDocumentDispositionDetail) {
            throw new \InvalidArgumentException(sprintf('The Dispositions property can only contain items of type \cosolis\StructType\CosolisTrackingDocumentDispositionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dispositions[] = $item;
        return $this;
    }
    /**
     * Get Grouping value
     * @return string|null
     */
    public function getGrouping()
    {
        return $this->Grouping;
    }
    /**
     * Set Grouping value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentGroupingType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentGroupingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $grouping
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public function setGrouping($grouping = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentGroupingType::valueIsValid($grouping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentGroupingType', is_array($grouping) ? implode(', ', $grouping) : var_export($grouping, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentGroupingType::getValidValues())), __LINE__);
        }
        $this->Grouping = $grouping;
        return $this;
    }
    /**
     * Get ImageType value
     * @return string|null
     */
    public function getImageType()
    {
        return $this->ImageType;
    }
    /**
     * Set ImageType value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentImageType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageType
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public function setImageType($imageType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentImageType::valueIsValid($imageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentImageType', is_array($imageType) ? implode(', ', $imageType) : var_export($imageType, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentImageType::getValidValues())), __LINE__);
        }
        $this->ImageType = $imageType;
        return $this;
    }
    /**
     * Get Localization value
     * @return \cosolis\StructType\CosolisLocalization|null
     */
    public function getLocalization()
    {
        return $this->Localization;
    }
    /**
     * Set Localization value
     * @param \cosolis\StructType\CosolisLocalization $localization
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public function setLocalization(\cosolis\StructType\CosolisLocalization $localization = null)
    {
        $this->Localization = $localization;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackingDocumentFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
