<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDocumentEmailDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackingDocumentEmailDetail extends AbstractStructBase
{
    /**
     * The Recipients
     * Meta information extracted from the WSDL
     * - documentation: Specifies the recipients of the email.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisEMailDetail[]
     */
    public $Recipients;
    /**
     * The Sender
     * Meta information extracted from the WSDL
     * - documentation: Identifies the person initiating the email.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisEMailDetail
     */
    public $Sender;
    /**
     * The Localization
     * Meta information extracted from the WSDL
     * - documentation: This is the localization of the email content.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisLocalization
     */
    public $Localization;
    /**
     * The PersonalMessage
     * Meta information extracted from the WSDL
     * - documentation: A message included in the body of the email.
     * - minOccurs: 0
     * @var string
     */
    public $PersonalMessage;
    /**
     * Constructor method for TrackingDocumentEmailDetail
     * @uses CosolisTrackingDocumentEmailDetail::setRecipients()
     * @uses CosolisTrackingDocumentEmailDetail::setSender()
     * @uses CosolisTrackingDocumentEmailDetail::setLocalization()
     * @uses CosolisTrackingDocumentEmailDetail::setPersonalMessage()
     * @param \cosolis\StructType\CosolisEMailDetail[] $recipients
     * @param \cosolis\StructType\CosolisEMailDetail $sender
     * @param \cosolis\StructType\CosolisLocalization $localization
     * @param string $personalMessage
     */
    public function __construct(array $recipients = array(), \cosolis\StructType\CosolisEMailDetail $sender = null, \cosolis\StructType\CosolisLocalization $localization = null, $personalMessage = null)
    {
        $this
            ->setRecipients($recipients)
            ->setSender($sender)
            ->setLocalization($localization)
            ->setPersonalMessage($personalMessage);
    }
    /**
     * Get Recipients value
     * @return \cosolis\StructType\CosolisEMailDetail[]|null
     */
    public function getRecipients()
    {
        return $this->Recipients;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipients method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipients method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientsForArrayConstraintsFromSetRecipients(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentEmailDetailRecipientsItem) {
            // validation for constraint: itemType
            if (!$trackingDocumentEmailDetailRecipientsItem instanceof \cosolis\StructType\CosolisEMailDetail) {
                $invalidValues[] = is_object($trackingDocumentEmailDetailRecipientsItem) ? get_class($trackingDocumentEmailDetailRecipientsItem) : sprintf('%s(%s)', gettype($trackingDocumentEmailDetailRecipientsItem), var_export($trackingDocumentEmailDetailRecipientsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recipients property can only contain items of type \cosolis\StructType\CosolisEMailDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recipients value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisEMailDetail[] $recipients
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public function setRecipients(array $recipients = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientsArrayErrorMessage = self::validateRecipientsForArrayConstraintsFromSetRecipients($recipients))) {
            throw new \InvalidArgumentException($recipientsArrayErrorMessage, __LINE__);
        }
        $this->Recipients = $recipients;
        return $this;
    }
    /**
     * Add item to Recipients value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisEMailDetail $item
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public function addToRecipients(\cosolis\StructType\CosolisEMailDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisEMailDetail) {
            throw new \InvalidArgumentException(sprintf('The Recipients property can only contain items of type \cosolis\StructType\CosolisEMailDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recipients[] = $item;
        return $this;
    }
    /**
     * Get Sender value
     * @return \cosolis\StructType\CosolisEMailDetail|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param \cosolis\StructType\CosolisEMailDetail $sender
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public function setSender(\cosolis\StructType\CosolisEMailDetail $sender = null)
    {
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get Localization value
     * @return \cosolis\StructType\CosolisLocalization|null
     */
    public function getLocalization()
    {
        return $this->Localization;
    }
    /**
     * Set Localization value
     * @param \cosolis\StructType\CosolisLocalization $localization
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public function setLocalization(\cosolis\StructType\CosolisLocalization $localization = null)
    {
        $this->Localization = $localization;
        return $this;
    }
    /**
     * Get PersonalMessage value
     * @return string|null
     */
    public function getPersonalMessage()
    {
        return $this->PersonalMessage;
    }
    /**
     * Set PersonalMessage value
     * @param string $personalMessage
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public function setPersonalMessage($personalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($personalMessage) && !is_string($personalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalMessage, true), gettype($personalMessage)), __LINE__);
        }
        $this->PersonalMessage = $personalMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
