<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDocumentDispositionDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackingDocumentDispositionDetail extends AbstractStructBase
{
    /**
     * The DispositionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DispositionType;
    /**
     * The EMailDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingDocumentEmailDetail
     */
    public $EMailDetail;
    /**
     * The FaxDetails
     * Meta information extracted from the WSDL
     * - documentation: Specifies the information used to fax the document.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisFaxDetail[]
     */
    public $FaxDetails;
    /**
     * Constructor method for TrackingDocumentDispositionDetail
     * @uses CosolisTrackingDocumentDispositionDetail::setDispositionType()
     * @uses CosolisTrackingDocumentDispositionDetail::setEMailDetail()
     * @uses CosolisTrackingDocumentDispositionDetail::setFaxDetails()
     * @param string $dispositionType
     * @param \cosolis\StructType\CosolisTrackingDocumentEmailDetail $eMailDetail
     * @param \cosolis\StructType\CosolisFaxDetail[] $faxDetails
     */
    public function __construct($dispositionType = null, \cosolis\StructType\CosolisTrackingDocumentEmailDetail $eMailDetail = null, array $faxDetails = array())
    {
        $this
            ->setDispositionType($dispositionType)
            ->setEMailDetail($eMailDetail)
            ->setFaxDetails($faxDetails);
    }
    /**
     * Get DispositionType value
     * @return string|null
     */
    public function getDispositionType()
    {
        return $this->DispositionType;
    }
    /**
     * Set DispositionType value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentDispositionType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentDispositionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dispositionType
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail
     */
    public function setDispositionType($dispositionType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentDispositionType::valueIsValid($dispositionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentDispositionType', is_array($dispositionType) ? implode(', ', $dispositionType) : var_export($dispositionType, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentDispositionType::getValidValues())), __LINE__);
        }
        $this->DispositionType = $dispositionType;
        return $this;
    }
    /**
     * Get EMailDetail value
     * @return \cosolis\StructType\CosolisTrackingDocumentEmailDetail|null
     */
    public function getEMailDetail()
    {
        return $this->EMailDetail;
    }
    /**
     * Set EMailDetail value
     * @param \cosolis\StructType\CosolisTrackingDocumentEmailDetail $eMailDetail
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail
     */
    public function setEMailDetail(\cosolis\StructType\CosolisTrackingDocumentEmailDetail $eMailDetail = null)
    {
        $this->EMailDetail = $eMailDetail;
        return $this;
    }
    /**
     * Get FaxDetails value
     * @return \cosolis\StructType\CosolisFaxDetail[]|null
     */
    public function getFaxDetails()
    {
        return $this->FaxDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setFaxDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFaxDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaxDetailsForArrayConstraintsFromSetFaxDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentDispositionDetailFaxDetailsItem) {
            // validation for constraint: itemType
            if (!$trackingDocumentDispositionDetailFaxDetailsItem instanceof \cosolis\StructType\CosolisFaxDetail) {
                $invalidValues[] = is_object($trackingDocumentDispositionDetailFaxDetailsItem) ? get_class($trackingDocumentDispositionDetailFaxDetailsItem) : sprintf('%s(%s)', gettype($trackingDocumentDispositionDetailFaxDetailsItem), var_export($trackingDocumentDispositionDetailFaxDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FaxDetails property can only contain items of type \cosolis\StructType\CosolisFaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FaxDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisFaxDetail[] $faxDetails
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail
     */
    public function setFaxDetails(array $faxDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($faxDetailsArrayErrorMessage = self::validateFaxDetailsForArrayConstraintsFromSetFaxDetails($faxDetails))) {
            throw new \InvalidArgumentException($faxDetailsArrayErrorMessage, __LINE__);
        }
        $this->FaxDetails = $faxDetails;
        return $this;
    }
    /**
     * Add item to FaxDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisFaxDetail $item
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail
     */
    public function addToFaxDetails(\cosolis\StructType\CosolisFaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisFaxDetail) {
            throw new \InvalidArgumentException(sprintf('The FaxDetails property can only contain items of type \cosolis\StructType\CosolisFaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FaxDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackingDocumentDispositionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
