<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingDocument StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackingDocument extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Localizations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisLocalization[]
     */
    public $Localizations;
    /**
     * The ImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageType;
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Resolution;
    /**
     * The Parts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisDocumentPart[]
     */
    public $Parts;
    /**
     * Constructor method for TrackingDocument
     * @uses CosolisTrackingDocument::setType()
     * @uses CosolisTrackingDocument::setLocalizations()
     * @uses CosolisTrackingDocument::setImageType()
     * @uses CosolisTrackingDocument::setResolution()
     * @uses CosolisTrackingDocument::setParts()
     * @param string $type
     * @param \cosolis\StructType\CosolisLocalization[] $localizations
     * @param string $imageType
     * @param int $resolution
     * @param \cosolis\StructType\CosolisDocumentPart[] $parts
     */
    public function __construct($type = null, array $localizations = array(), $imageType = null, $resolution = null, array $parts = array())
    {
        $this
            ->setType($type)
            ->setLocalizations($localizations)
            ->setImageType($imageType)
            ->setResolution($resolution)
            ->setParts($parts);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Localizations value
     * @return \cosolis\StructType\CosolisLocalization[]|null
     */
    public function getLocalizations()
    {
        return $this->Localizations;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalizations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalizations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalizationsForArrayConstraintsFromSetLocalizations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentLocalizationsItem) {
            // validation for constraint: itemType
            if (!$trackingDocumentLocalizationsItem instanceof \cosolis\StructType\CosolisLocalization) {
                $invalidValues[] = is_object($trackingDocumentLocalizationsItem) ? get_class($trackingDocumentLocalizationsItem) : sprintf('%s(%s)', gettype($trackingDocumentLocalizationsItem), var_export($trackingDocumentLocalizationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Localizations property can only contain items of type \cosolis\StructType\CosolisLocalization, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Localizations value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisLocalization[] $localizations
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function setLocalizations(array $localizations = array())
    {
        // validation for constraint: array
        if ('' !== ($localizationsArrayErrorMessage = self::validateLocalizationsForArrayConstraintsFromSetLocalizations($localizations))) {
            throw new \InvalidArgumentException($localizationsArrayErrorMessage, __LINE__);
        }
        $this->Localizations = $localizations;
        return $this;
    }
    /**
     * Add item to Localizations value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisLocalization $item
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function addToLocalizations(\cosolis\StructType\CosolisLocalization $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisLocalization) {
            throw new \InvalidArgumentException(sprintf('The Localizations property can only contain items of type \cosolis\StructType\CosolisLocalization, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Localizations[] = $item;
        return $this;
    }
    /**
     * Get ImageType value
     * @return string|null
     */
    public function getImageType()
    {
        return $this->ImageType;
    }
    /**
     * Set ImageType value
     * @uses \cosolis\EnumType\CosolisTrackingDocumentImageType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackingDocumentImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageType
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function setImageType($imageType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackingDocumentImageType::valueIsValid($imageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackingDocumentImageType', is_array($imageType) ? implode(', ', $imageType) : var_export($imageType, true), implode(', ', \cosolis\EnumType\CosolisTrackingDocumentImageType::getValidValues())), __LINE__);
        }
        $this->ImageType = $imageType;
        return $this;
    }
    /**
     * Get Resolution value
     * @return int|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param int $resolution
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: int
        if (!is_null($resolution) && !(is_int($resolution) || ctype_digit($resolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get Parts value
     * @return \cosolis\StructType\CosolisDocumentPart[]|null
     */
    public function getParts()
    {
        return $this->Parts;
    }
    /**
     * This method is responsible for validating the values passed to the setParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartsForArrayConstraintsFromSetParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackingDocumentPartsItem) {
            // validation for constraint: itemType
            if (!$trackingDocumentPartsItem instanceof \cosolis\StructType\CosolisDocumentPart) {
                $invalidValues[] = is_object($trackingDocumentPartsItem) ? get_class($trackingDocumentPartsItem) : sprintf('%s(%s)', gettype($trackingDocumentPartsItem), var_export($trackingDocumentPartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parts property can only contain items of type \cosolis\StructType\CosolisDocumentPart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parts value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisDocumentPart[] $parts
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function setParts(array $parts = array())
    {
        // validation for constraint: array
        if ('' !== ($partsArrayErrorMessage = self::validatePartsForArrayConstraintsFromSetParts($parts))) {
            throw new \InvalidArgumentException($partsArrayErrorMessage, __LINE__);
        }
        $this->Parts = $parts;
        return $this;
    }
    /**
     * Add item to Parts value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisDocumentPart $item
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public function addToParts(\cosolis\StructType\CosolisDocumentPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisDocumentPart) {
            throw new \InvalidArgumentException(sprintf('The Parts property can only contain items of type \cosolis\StructType\CosolisDocumentPart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parts[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackingDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
