<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackStatusDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the details about the status of the track information for the shipments being tracked.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackStatusDetail extends AbstractStructBase
{
    /**
     * The CreationTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationTime;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $Location;
    /**
     * The AncillaryDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackStatusAncillaryDetail[]
     */
    public $AncillaryDetails;
    /**
     * Constructor method for TrackStatusDetail
     * @uses CosolisTrackStatusDetail::setCreationTime()
     * @uses CosolisTrackStatusDetail::setCode()
     * @uses CosolisTrackStatusDetail::setDescription()
     * @uses CosolisTrackStatusDetail::setLocation()
     * @uses CosolisTrackStatusDetail::setAncillaryDetails()
     * @param string $creationTime
     * @param string $code
     * @param string $description
     * @param \cosolis\StructType\CosolisAddress $location
     * @param \cosolis\StructType\CosolisTrackStatusAncillaryDetail[] $ancillaryDetails
     */
    public function __construct($creationTime = null, $code = null, $description = null, \cosolis\StructType\CosolisAddress $location = null, array $ancillaryDetails = array())
    {
        $this
            ->setCreationTime($creationTime)
            ->setCode($code)
            ->setDescription($description)
            ->setLocation($location)
            ->setAncillaryDetails($ancillaryDetails);
    }
    /**
     * Get CreationTime value
     * @return string|null
     */
    public function getCreationTime()
    {
        return $this->CreationTime;
    }
    /**
     * Set CreationTime value
     * @param string $creationTime
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function setCreationTime($creationTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationTime) && !is_string($creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationTime, true), gettype($creationTime)), __LINE__);
        }
        $this->CreationTime = $creationTime;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Location value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \cosolis\StructType\CosolisAddress $location
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function setLocation(\cosolis\StructType\CosolisAddress $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get AncillaryDetails value
     * @return \cosolis\StructType\CosolisTrackStatusAncillaryDetail[]|null
     */
    public function getAncillaryDetails()
    {
        return $this->AncillaryDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setAncillaryDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAncillaryDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAncillaryDetailsForArrayConstraintsFromSetAncillaryDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackStatusDetailAncillaryDetailsItem) {
            // validation for constraint: itemType
            if (!$trackStatusDetailAncillaryDetailsItem instanceof \cosolis\StructType\CosolisTrackStatusAncillaryDetail) {
                $invalidValues[] = is_object($trackStatusDetailAncillaryDetailsItem) ? get_class($trackStatusDetailAncillaryDetailsItem) : sprintf('%s(%s)', gettype($trackStatusDetailAncillaryDetailsItem), var_export($trackStatusDetailAncillaryDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AncillaryDetails property can only contain items of type \cosolis\StructType\CosolisTrackStatusAncillaryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AncillaryDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackStatusAncillaryDetail[] $ancillaryDetails
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function setAncillaryDetails(array $ancillaryDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($ancillaryDetailsArrayErrorMessage = self::validateAncillaryDetailsForArrayConstraintsFromSetAncillaryDetails($ancillaryDetails))) {
            throw new \InvalidArgumentException($ancillaryDetailsArrayErrorMessage, __LINE__);
        }
        $this->AncillaryDetails = $ancillaryDetails;
        return $this;
    }
    /**
     * Add item to AncillaryDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackStatusAncillaryDetail $item
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public function addToAncillaryDetails(\cosolis\StructType\CosolisTrackStatusAncillaryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackStatusAncillaryDetail) {
            throw new \InvalidArgumentException(sprintf('The AncillaryDetails property can only contain items of type \cosolis\StructType\CosolisTrackStatusAncillaryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AncillaryDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackStatusDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
