<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackSpecialInstruction StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackSpecialInstruction extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DeliveryOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryOption;
    /**
     * The StatusDetail
     * Meta information extracted from the WSDL
     * - documentation: Specifies the status and status update time of the track special instructions.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisSpecialInstructionStatusDetail
     */
    public $StatusDetail;
    /**
     * The OriginalEstimatedDeliveryTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Specifies the estimated delivery time that was originally estimated when the shipment was shipped.
     * - minOccurs: 0
     * @var string
     */
    public $OriginalEstimatedDeliveryTimestamp;
    /**
     * The OriginalRequestTime
     * Meta information extracted from the WSDL
     * - documentation: Specifies the time the customer requested a change to the shipment.
     * - minOccurs: 0
     * @var string
     */
    public $OriginalRequestTime;
    /**
     * The RequestedAppointmentTime
     * Meta information extracted from the WSDL
     * - documentation: The requested appointment time for delivery.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAppointmentDetail
     */
    public $RequestedAppointmentTime;
    /**
     * Constructor method for TrackSpecialInstruction
     * @uses CosolisTrackSpecialInstruction::setDescription()
     * @uses CosolisTrackSpecialInstruction::setDeliveryOption()
     * @uses CosolisTrackSpecialInstruction::setStatusDetail()
     * @uses CosolisTrackSpecialInstruction::setOriginalEstimatedDeliveryTimestamp()
     * @uses CosolisTrackSpecialInstruction::setOriginalRequestTime()
     * @uses CosolisTrackSpecialInstruction::setRequestedAppointmentTime()
     * @param string $description
     * @param string $deliveryOption
     * @param \cosolis\StructType\CosolisSpecialInstructionStatusDetail $statusDetail
     * @param string $originalEstimatedDeliveryTimestamp
     * @param string $originalRequestTime
     * @param \cosolis\StructType\CosolisAppointmentDetail $requestedAppointmentTime
     */
    public function __construct($description = null, $deliveryOption = null, \cosolis\StructType\CosolisSpecialInstructionStatusDetail $statusDetail = null, $originalEstimatedDeliveryTimestamp = null, $originalRequestTime = null, \cosolis\StructType\CosolisAppointmentDetail $requestedAppointmentTime = null)
    {
        $this
            ->setDescription($description)
            ->setDeliveryOption($deliveryOption)
            ->setStatusDetail($statusDetail)
            ->setOriginalEstimatedDeliveryTimestamp($originalEstimatedDeliveryTimestamp)
            ->setOriginalRequestTime($originalRequestTime)
            ->setRequestedAppointmentTime($requestedAppointmentTime);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DeliveryOption value
     * @return string|null
     */
    public function getDeliveryOption()
    {
        return $this->DeliveryOption;
    }
    /**
     * Set DeliveryOption value
     * @uses \cosolis\EnumType\CosolisTrackDeliveryOptionType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackDeliveryOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryOption
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setDeliveryOption($deliveryOption = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackDeliveryOptionType::valueIsValid($deliveryOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackDeliveryOptionType', is_array($deliveryOption) ? implode(', ', $deliveryOption) : var_export($deliveryOption, true), implode(', ', \cosolis\EnumType\CosolisTrackDeliveryOptionType::getValidValues())), __LINE__);
        }
        $this->DeliveryOption = $deliveryOption;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return \cosolis\StructType\CosolisSpecialInstructionStatusDetail|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param \cosolis\StructType\CosolisSpecialInstructionStatusDetail $statusDetail
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setStatusDetail(\cosolis\StructType\CosolisSpecialInstructionStatusDetail $statusDetail = null)
    {
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Get OriginalEstimatedDeliveryTimestamp value
     * @return string|null
     */
    public function getOriginalEstimatedDeliveryTimestamp()
    {
        return $this->OriginalEstimatedDeliveryTimestamp;
    }
    /**
     * Set OriginalEstimatedDeliveryTimestamp value
     * @param string $originalEstimatedDeliveryTimestamp
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setOriginalEstimatedDeliveryTimestamp($originalEstimatedDeliveryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($originalEstimatedDeliveryTimestamp) && !is_string($originalEstimatedDeliveryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalEstimatedDeliveryTimestamp, true), gettype($originalEstimatedDeliveryTimestamp)), __LINE__);
        }
        $this->OriginalEstimatedDeliveryTimestamp = $originalEstimatedDeliveryTimestamp;
        return $this;
    }
    /**
     * Get OriginalRequestTime value
     * @return string|null
     */
    public function getOriginalRequestTime()
    {
        return $this->OriginalRequestTime;
    }
    /**
     * Set OriginalRequestTime value
     * @param string $originalRequestTime
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setOriginalRequestTime($originalRequestTime = null)
    {
        // validation for constraint: string
        if (!is_null($originalRequestTime) && !is_string($originalRequestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalRequestTime, true), gettype($originalRequestTime)), __LINE__);
        }
        $this->OriginalRequestTime = $originalRequestTime;
        return $this;
    }
    /**
     * Get RequestedAppointmentTime value
     * @return \cosolis\StructType\CosolisAppointmentDetail|null
     */
    public function getRequestedAppointmentTime()
    {
        return $this->RequestedAppointmentTime;
    }
    /**
     * Set RequestedAppointmentTime value
     * @param \cosolis\StructType\CosolisAppointmentDetail $requestedAppointmentTime
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public function setRequestedAppointmentTime(\cosolis\StructType\CosolisAppointmentDetail $requestedAppointmentTime = null)
    {
        $this->RequestedAppointmentTime = $requestedAppointmentTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
