<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackSpecialHandling StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackSpecialHandling extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of track special handling on the package.
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for TrackSpecialHandling
     * @uses CosolisTrackSpecialHandling::setType()
     * @uses CosolisTrackSpecialHandling::setDescription()
     * @uses CosolisTrackSpecialHandling::setPaymentType()
     * @param string $type
     * @param string $description
     * @param string $paymentType
     */
    public function __construct($type = null, $description = null, $paymentType = null)
    {
        $this
            ->setType($type)
            ->setDescription($description)
            ->setPaymentType($paymentType);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \cosolis\StructType\CosolisTrackSpecialHandling
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisTrackSpecialHandling
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \cosolis\EnumType\CosolisTrackPaymentType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackPaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \cosolis\StructType\CosolisTrackSpecialHandling
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackPaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackPaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \cosolis\EnumType\CosolisTrackPaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackSpecialHandling
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
