<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackSelectionDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackSelectionDetail extends AbstractStructBase
{
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: The FedEx operating company (transportation) used for this package's delivery.
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The OperatingCompany
     * Meta information extracted from the WSDL
     * - documentation: Identifies operating transportation company that is the specific to the carrier code.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCompany;
    /**
     * The PackageIdentifier
     * Meta information extracted from the WSDL
     * - documentation: The type and value of the package identifier that is to be used to retrieve the tracking information for a package or group of packages.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackPackageIdentifier
     */
    public $PackageIdentifier;
    /**
     * The TrackingNumberUniqueIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Used to distinguish duplicate FedEx tracking numbers.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumberUniqueIdentifier;
    /**
     * The ShipDateRangeBegin
     * Meta information extracted from the WSDL
     * - documentation: To narrow the search to a period in time the ShipDateRangeBegin and ShipDateRangeEnd can be used to help eliminate duplicates.
     * - minOccurs: 0
     * @var string
     */
    public $ShipDateRangeBegin;
    /**
     * The ShipDateRangeEnd
     * Meta information extracted from the WSDL
     * - documentation: To narrow the search to a period in time the ShipDateRangeBegin and ShipDateRangeEnd can be used to help eliminate duplicates.
     * - minOccurs: 0
     * @var string
     */
    public $ShipDateRangeEnd;
    /**
     * The ShipmentAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: For tracking by references information either the account number or destination postal code and country must be provided.
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentAccountNumber;
    /**
     * The SecureSpodAccount
     * Meta information extracted from the WSDL
     * - documentation: Specifies the SPOD account number for the shipment being tracked.
     * - minOccurs: 0
     * @var string
     */
    public $SecureSpodAccount;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - documentation: For tracking by references information either the account number or destination postal code and country must be provided.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $Destination;
    /**
     * The PagingDetail
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details about how to retrieve the subsequent pages when there is more than one page in the TrackReply.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisPagingDetail
     */
    public $PagingDetail;
    /**
     * The CustomerSpecifiedTimeOutValueInMilliseconds
     * Meta information extracted from the WSDL
     * - documentation: The customer can specify a desired time out value for this particular tracking number.
     * - minOccurs: 0
     * @var int
     */
    public $CustomerSpecifiedTimeOutValueInMilliseconds;
    /**
     * Constructor method for TrackSelectionDetail
     * @uses CosolisTrackSelectionDetail::setCarrierCode()
     * @uses CosolisTrackSelectionDetail::setOperatingCompany()
     * @uses CosolisTrackSelectionDetail::setPackageIdentifier()
     * @uses CosolisTrackSelectionDetail::setTrackingNumberUniqueIdentifier()
     * @uses CosolisTrackSelectionDetail::setShipDateRangeBegin()
     * @uses CosolisTrackSelectionDetail::setShipDateRangeEnd()
     * @uses CosolisTrackSelectionDetail::setShipmentAccountNumber()
     * @uses CosolisTrackSelectionDetail::setSecureSpodAccount()
     * @uses CosolisTrackSelectionDetail::setDestination()
     * @uses CosolisTrackSelectionDetail::setPagingDetail()
     * @uses CosolisTrackSelectionDetail::setCustomerSpecifiedTimeOutValueInMilliseconds()
     * @param string $carrierCode
     * @param string $operatingCompany
     * @param \cosolis\StructType\CosolisTrackPackageIdentifier $packageIdentifier
     * @param string $trackingNumberUniqueIdentifier
     * @param string $shipDateRangeBegin
     * @param string $shipDateRangeEnd
     * @param string $shipmentAccountNumber
     * @param string $secureSpodAccount
     * @param \cosolis\StructType\CosolisAddress $destination
     * @param \cosolis\StructType\CosolisPagingDetail $pagingDetail
     * @param int $customerSpecifiedTimeOutValueInMilliseconds
     */
    public function __construct($carrierCode = null, $operatingCompany = null, \cosolis\StructType\CosolisTrackPackageIdentifier $packageIdentifier = null, $trackingNumberUniqueIdentifier = null, $shipDateRangeBegin = null, $shipDateRangeEnd = null, $shipmentAccountNumber = null, $secureSpodAccount = null, \cosolis\StructType\CosolisAddress $destination = null, \cosolis\StructType\CosolisPagingDetail $pagingDetail = null, $customerSpecifiedTimeOutValueInMilliseconds = null)
    {
        $this
            ->setCarrierCode($carrierCode)
            ->setOperatingCompany($operatingCompany)
            ->setPackageIdentifier($packageIdentifier)
            ->setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier)
            ->setShipDateRangeBegin($shipDateRangeBegin)
            ->setShipDateRangeEnd($shipDateRangeEnd)
            ->setShipmentAccountNumber($shipmentAccountNumber)
            ->setSecureSpodAccount($secureSpodAccount)
            ->setDestination($destination)
            ->setPagingDetail($pagingDetail)
            ->setCustomerSpecifiedTimeOutValueInMilliseconds($customerSpecifiedTimeOutValueInMilliseconds);
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrierCode
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisCarrierCodeType::valueIsValid($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisCarrierCodeType', is_array($carrierCode) ? implode(', ', $carrierCode) : var_export($carrierCode, true), implode(', ', \cosolis\EnumType\CosolisCarrierCodeType::getValidValues())), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return string|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @uses \cosolis\EnumType\CosolisOperatingCompanyType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisOperatingCompanyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatingCompany
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setOperatingCompany($operatingCompany = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisOperatingCompanyType::valueIsValid($operatingCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisOperatingCompanyType', is_array($operatingCompany) ? implode(', ', $operatingCompany) : var_export($operatingCompany, true), implode(', ', \cosolis\EnumType\CosolisOperatingCompanyType::getValidValues())), __LINE__);
        }
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get PackageIdentifier value
     * @return \cosolis\StructType\CosolisTrackPackageIdentifier|null
     */
    public function getPackageIdentifier()
    {
        return $this->PackageIdentifier;
    }
    /**
     * Set PackageIdentifier value
     * @param \cosolis\StructType\CosolisTrackPackageIdentifier $packageIdentifier
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setPackageIdentifier(\cosolis\StructType\CosolisTrackPackageIdentifier $packageIdentifier = null)
    {
        $this->PackageIdentifier = $packageIdentifier;
        return $this;
    }
    /**
     * Get TrackingNumberUniqueIdentifier value
     * @return string|null
     */
    public function getTrackingNumberUniqueIdentifier()
    {
        return $this->TrackingNumberUniqueIdentifier;
    }
    /**
     * Set TrackingNumberUniqueIdentifier value
     * @param string $trackingNumberUniqueIdentifier
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberUniqueIdentifier) && !is_string($trackingNumberUniqueIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumberUniqueIdentifier, true), gettype($trackingNumberUniqueIdentifier)), __LINE__);
        }
        $this->TrackingNumberUniqueIdentifier = $trackingNumberUniqueIdentifier;
        return $this;
    }
    /**
     * Get ShipDateRangeBegin value
     * @return string|null
     */
    public function getShipDateRangeBegin()
    {
        return $this->ShipDateRangeBegin;
    }
    /**
     * Set ShipDateRangeBegin value
     * @param string $shipDateRangeBegin
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setShipDateRangeBegin($shipDateRangeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($shipDateRangeBegin) && !is_string($shipDateRangeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDateRangeBegin, true), gettype($shipDateRangeBegin)), __LINE__);
        }
        $this->ShipDateRangeBegin = $shipDateRangeBegin;
        return $this;
    }
    /**
     * Get ShipDateRangeEnd value
     * @return string|null
     */
    public function getShipDateRangeEnd()
    {
        return $this->ShipDateRangeEnd;
    }
    /**
     * Set ShipDateRangeEnd value
     * @param string $shipDateRangeEnd
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setShipDateRangeEnd($shipDateRangeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($shipDateRangeEnd) && !is_string($shipDateRangeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDateRangeEnd, true), gettype($shipDateRangeEnd)), __LINE__);
        }
        $this->ShipDateRangeEnd = $shipDateRangeEnd;
        return $this;
    }
    /**
     * Get ShipmentAccountNumber value
     * @return string|null
     */
    public function getShipmentAccountNumber()
    {
        return $this->ShipmentAccountNumber;
    }
    /**
     * Set ShipmentAccountNumber value
     * @param string $shipmentAccountNumber
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setShipmentAccountNumber($shipmentAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentAccountNumber) && !is_string($shipmentAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentAccountNumber, true), gettype($shipmentAccountNumber)), __LINE__);
        }
        $this->ShipmentAccountNumber = $shipmentAccountNumber;
        return $this;
    }
    /**
     * Get SecureSpodAccount value
     * @return string|null
     */
    public function getSecureSpodAccount()
    {
        return $this->SecureSpodAccount;
    }
    /**
     * Set SecureSpodAccount value
     * @param string $secureSpodAccount
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setSecureSpodAccount($secureSpodAccount = null)
    {
        // validation for constraint: string
        if (!is_null($secureSpodAccount) && !is_string($secureSpodAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureSpodAccount, true), gettype($secureSpodAccount)), __LINE__);
        }
        $this->SecureSpodAccount = $secureSpodAccount;
        return $this;
    }
    /**
     * Get Destination value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \cosolis\StructType\CosolisAddress $destination
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setDestination(\cosolis\StructType\CosolisAddress $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get PagingDetail value
     * @return \cosolis\StructType\CosolisPagingDetail|null
     */
    public function getPagingDetail()
    {
        return $this->PagingDetail;
    }
    /**
     * Set PagingDetail value
     * @param \cosolis\StructType\CosolisPagingDetail $pagingDetail
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setPagingDetail(\cosolis\StructType\CosolisPagingDetail $pagingDetail = null)
    {
        $this->PagingDetail = $pagingDetail;
        return $this;
    }
    /**
     * Get CustomerSpecifiedTimeOutValueInMilliseconds value
     * @return int|null
     */
    public function getCustomerSpecifiedTimeOutValueInMilliseconds()
    {
        return $this->CustomerSpecifiedTimeOutValueInMilliseconds;
    }
    /**
     * Set CustomerSpecifiedTimeOutValueInMilliseconds value
     * @param int $customerSpecifiedTimeOutValueInMilliseconds
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public function setCustomerSpecifiedTimeOutValueInMilliseconds($customerSpecifiedTimeOutValueInMilliseconds = null)
    {
        // validation for constraint: int
        if (!is_null($customerSpecifiedTimeOutValueInMilliseconds) && !(is_int($customerSpecifiedTimeOutValueInMilliseconds) || ctype_digit($customerSpecifiedTimeOutValueInMilliseconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerSpecifiedTimeOutValueInMilliseconds, true), gettype($customerSpecifiedTimeOutValueInMilliseconds)), __LINE__);
        }
        $this->CustomerSpecifiedTimeOutValueInMilliseconds = $customerSpecifiedTimeOutValueInMilliseconds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackSelectionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
