<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackReturnDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackReturnDetail extends AbstractStructBase
{
    /**
     * The MovementStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MovementStatus;
    /**
     * The LabelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AuthorizationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationName;
    /**
     * Constructor method for TrackReturnDetail
     * @uses CosolisTrackReturnDetail::setMovementStatus()
     * @uses CosolisTrackReturnDetail::setLabelType()
     * @uses CosolisTrackReturnDetail::setDescription()
     * @uses CosolisTrackReturnDetail::setAuthorizationName()
     * @param string $movementStatus
     * @param string $labelType
     * @param string $description
     * @param string $authorizationName
     */
    public function __construct($movementStatus = null, $labelType = null, $description = null, $authorizationName = null)
    {
        $this
            ->setMovementStatus($movementStatus)
            ->setLabelType($labelType)
            ->setDescription($description)
            ->setAuthorizationName($authorizationName);
    }
    /**
     * Get MovementStatus value
     * @return string|null
     */
    public function getMovementStatus()
    {
        return $this->MovementStatus;
    }
    /**
     * Set MovementStatus value
     * @uses \cosolis\EnumType\CosolisTrackReturnMovementStatusType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackReturnMovementStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $movementStatus
     * @return \cosolis\StructType\CosolisTrackReturnDetail
     */
    public function setMovementStatus($movementStatus = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackReturnMovementStatusType::valueIsValid($movementStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackReturnMovementStatusType', is_array($movementStatus) ? implode(', ', $movementStatus) : var_export($movementStatus, true), implode(', ', \cosolis\EnumType\CosolisTrackReturnMovementStatusType::getValidValues())), __LINE__);
        }
        $this->MovementStatus = $movementStatus;
        return $this;
    }
    /**
     * Get LabelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @uses \cosolis\EnumType\CosolisTrackReturnLabelType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackReturnLabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return \cosolis\StructType\CosolisTrackReturnDetail
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackReturnLabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackReturnLabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', \cosolis\EnumType\CosolisTrackReturnLabelType::getValidValues())), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisTrackReturnDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AuthorizationName value
     * @return string|null
     */
    public function getAuthorizationName()
    {
        return $this->AuthorizationName;
    }
    /**
     * Set AuthorizationName value
     * @param string $authorizationName
     * @return \cosolis\StructType\CosolisTrackReturnDetail
     */
    public function setAuthorizationName($authorizationName = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationName) && !is_string($authorizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationName, true), gettype($authorizationName)), __LINE__);
        }
        $this->AuthorizationName = $authorizationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackReturnDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
