<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackRequest StructType
 * Meta information extracted from the WSDL
 * - type: ns:TrackRequest
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackRequest extends AbstractStructBase
{
    /**
     * The WebAuthenticationDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data to be used in authentication of the sender's identity (and right to use FedEx web services).
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public $WebAuthenticationDetail;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data identifying the client submitting the transaction.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisClientDetail
     */
    public $ClientDetail;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: The version of the request being used.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Contains a free form field that is echoed back in the reply to match requests with replies and data that governs the data payload language/translations.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The SelectionDetails
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details needed to select the shipment being requested to be tracked.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackSelectionDetail[]
     */
    public $SelectionDetails;
    /**
     * The TransactionTimeOutValueInMilliseconds
     * Meta information extracted from the WSDL
     * - documentation: The customer can specify a desired time out value for this particular transaction.
     * - minOccurs: 0
     * @var int
     */
    public $TransactionTimeOutValueInMilliseconds;
    /**
     * The ProcessingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ProcessingOptions;
    /**
     * Constructor method for TrackRequest
     * @uses CosolisTrackRequest::setWebAuthenticationDetail()
     * @uses CosolisTrackRequest::setClientDetail()
     * @uses CosolisTrackRequest::setVersion()
     * @uses CosolisTrackRequest::setTransactionDetail()
     * @uses CosolisTrackRequest::setSelectionDetails()
     * @uses CosolisTrackRequest::setTransactionTimeOutValueInMilliseconds()
     * @uses CosolisTrackRequest::setProcessingOptions()
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param \cosolis\StructType\CosolisTrackSelectionDetail[] $selectionDetails
     * @param int $transactionTimeOutValueInMilliseconds
     * @param string[] $processingOptions
     */
    public function __construct(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null, \cosolis\StructType\CosolisClientDetail $clientDetail = null, \cosolis\StructType\CosolisVersionId $version = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, array $selectionDetails = array(), $transactionTimeOutValueInMilliseconds = null, array $processingOptions = array())
    {
        $this
            ->setWebAuthenticationDetail($webAuthenticationDetail)
            ->setClientDetail($clientDetail)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setSelectionDetails($selectionDetails)
            ->setTransactionTimeOutValueInMilliseconds($transactionTimeOutValueInMilliseconds)
            ->setProcessingOptions($processingOptions);
    }
    /**
     * Get WebAuthenticationDetail value
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public function getWebAuthenticationDetail()
    {
        return $this->WebAuthenticationDetail;
    }
    /**
     * Set WebAuthenticationDetail value
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setWebAuthenticationDetail(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null)
    {
        $this->WebAuthenticationDetail = $webAuthenticationDetail;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \cosolis\StructType\CosolisClientDetail
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setClientDetail(\cosolis\StructType\CosolisClientDetail $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get SelectionDetails value
     * @return \cosolis\StructType\CosolisTrackSelectionDetail[]|null
     */
    public function getSelectionDetails()
    {
        return $this->SelectionDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionDetailsForArrayConstraintsFromSetSelectionDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackRequestSelectionDetailsItem) {
            // validation for constraint: itemType
            if (!$trackRequestSelectionDetailsItem instanceof \cosolis\StructType\CosolisTrackSelectionDetail) {
                $invalidValues[] = is_object($trackRequestSelectionDetailsItem) ? get_class($trackRequestSelectionDetailsItem) : sprintf('%s(%s)', gettype($trackRequestSelectionDetailsItem), var_export($trackRequestSelectionDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionDetails property can only contain items of type \cosolis\StructType\CosolisTrackSelectionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSelectionDetail[] $selectionDetails
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setSelectionDetails(array $selectionDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionDetailsArrayErrorMessage = self::validateSelectionDetailsForArrayConstraintsFromSetSelectionDetails($selectionDetails))) {
            throw new \InvalidArgumentException($selectionDetailsArrayErrorMessage, __LINE__);
        }
        $this->SelectionDetails = $selectionDetails;
        return $this;
    }
    /**
     * Add item to SelectionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSelectionDetail $item
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function addToSelectionDetails(\cosolis\StructType\CosolisTrackSelectionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackSelectionDetail) {
            throw new \InvalidArgumentException(sprintf('The SelectionDetails property can only contain items of type \cosolis\StructType\CosolisTrackSelectionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionDetails[] = $item;
        return $this;
    }
    /**
     * Get TransactionTimeOutValueInMilliseconds value
     * @return int|null
     */
    public function getTransactionTimeOutValueInMilliseconds()
    {
        return $this->TransactionTimeOutValueInMilliseconds;
    }
    /**
     * Set TransactionTimeOutValueInMilliseconds value
     * @param int $transactionTimeOutValueInMilliseconds
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setTransactionTimeOutValueInMilliseconds($transactionTimeOutValueInMilliseconds = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTimeOutValueInMilliseconds) && !(is_int($transactionTimeOutValueInMilliseconds) || ctype_digit($transactionTimeOutValueInMilliseconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionTimeOutValueInMilliseconds, true), gettype($transactionTimeOutValueInMilliseconds)), __LINE__);
        }
        $this->TransactionTimeOutValueInMilliseconds = $transactionTimeOutValueInMilliseconds;
        return $this;
    }
    /**
     * Get ProcessingOptions value
     * @return string[]|null
     */
    public function getProcessingOptions()
    {
        return $this->ProcessingOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setProcessingOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcessingOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcessingOptionsForArrayConstraintsFromSetProcessingOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackRequestProcessingOptionsItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisTrackRequestProcessingOptionType::valueIsValid($trackRequestProcessingOptionsItem)) {
                $invalidValues[] = is_object($trackRequestProcessingOptionsItem) ? get_class($trackRequestProcessingOptionsItem) : sprintf('%s(%s)', gettype($trackRequestProcessingOptionsItem), var_export($trackRequestProcessingOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackRequestProcessingOptionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProcessingOptions value
     * @uses \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $processingOptions
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function setProcessingOptions(array $processingOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($processingOptionsArrayErrorMessage = self::validateProcessingOptionsForArrayConstraintsFromSetProcessingOptions($processingOptions))) {
            throw new \InvalidArgumentException($processingOptionsArrayErrorMessage, __LINE__);
        }
        $this->ProcessingOptions = $processingOptions;
        return $this;
    }
    /**
     * Add item to ProcessingOptions value
     * @uses \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public function addToProcessingOptions($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackRequestProcessingOptionType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackRequestProcessingOptionType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisTrackRequestProcessingOptionType::getValidValues())), __LINE__);
        }
        $this->ProcessingOptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
