<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackReply StructType
 * Meta information extracted from the WSDL
 * - type: ns:TrackReply
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackReply extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - documentation: This contains the severity type of the most severe Notification in the Notifications array.
     * - minOccurs: 1
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - documentation: Information about the request/reply such was the transaction successful or not, and any additional information relevant to the request and/or reply. There may be multiple Notifications in a reply.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisNotification[]
     */
    public $Notifications;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Contains the version of the reply being used.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Contains the CustomerTransactionDetail that is echoed back to the caller for matching requests and replies and a Localization element for defining the language/translation used in the reply data.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The CompletedTrackDetails
     * Meta information extracted from the WSDL
     * - documentation: Contains detailed tracking entity information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisCompletedTrackDetail[]
     */
    public $CompletedTrackDetails;
    /**
     * Constructor method for TrackReply
     * @uses CosolisTrackReply::setHighestSeverity()
     * @uses CosolisTrackReply::setNotifications()
     * @uses CosolisTrackReply::setVersion()
     * @uses CosolisTrackReply::setTransactionDetail()
     * @uses CosolisTrackReply::setCompletedTrackDetails()
     * @param string $highestSeverity
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param \cosolis\StructType\CosolisCompletedTrackDetail[] $completedTrackDetails
     */
    public function __construct($highestSeverity = null, array $notifications = array(), \cosolis\StructType\CosolisVersionId $version = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, array $completedTrackDetails = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setCompletedTrackDetails($completedTrackDetails);
    }
    /**
     * Get HighestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \cosolis\StructType\CosolisNotification[]
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackReplyNotificationsItem) {
            // validation for constraint: itemType
            if (!$trackReplyNotificationsItem instanceof \cosolis\StructType\CosolisNotification) {
                $invalidValues[] = is_object($trackReplyNotificationsItem) ? get_class($trackReplyNotificationsItem) : sprintf('%s(%s)', gettype($trackReplyNotificationsItem), var_export($trackReplyNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification $item
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function addToNotifications(\cosolis\StructType\CosolisNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisNotification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get CompletedTrackDetails value
     * @return \cosolis\StructType\CosolisCompletedTrackDetail[]|null
     */
    public function getCompletedTrackDetails()
    {
        return $this->CompletedTrackDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setCompletedTrackDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompletedTrackDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompletedTrackDetailsForArrayConstraintsFromSetCompletedTrackDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackReplyCompletedTrackDetailsItem) {
            // validation for constraint: itemType
            if (!$trackReplyCompletedTrackDetailsItem instanceof \cosolis\StructType\CosolisCompletedTrackDetail) {
                $invalidValues[] = is_object($trackReplyCompletedTrackDetailsItem) ? get_class($trackReplyCompletedTrackDetailsItem) : sprintf('%s(%s)', gettype($trackReplyCompletedTrackDetailsItem), var_export($trackReplyCompletedTrackDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompletedTrackDetails property can only contain items of type \cosolis\StructType\CosolisCompletedTrackDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompletedTrackDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCompletedTrackDetail[] $completedTrackDetails
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function setCompletedTrackDetails(array $completedTrackDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($completedTrackDetailsArrayErrorMessage = self::validateCompletedTrackDetailsForArrayConstraintsFromSetCompletedTrackDetails($completedTrackDetails))) {
            throw new \InvalidArgumentException($completedTrackDetailsArrayErrorMessage, __LINE__);
        }
        $this->CompletedTrackDetails = $completedTrackDetails;
        return $this;
    }
    /**
     * Add item to CompletedTrackDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCompletedTrackDetail $item
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public function addToCompletedTrackDetails(\cosolis\StructType\CosolisCompletedTrackDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisCompletedTrackDetail) {
            throw new \InvalidArgumentException(sprintf('The CompletedTrackDetails property can only contain items of type \cosolis\StructType\CosolisCompletedTrackDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompletedTrackDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
