<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackPayment StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackPayment extends AbstractStructBase
{
    /**
     * The Classification
     * Meta information extracted from the WSDL
     * - documentation: Indicates the classification of the charges being paid.
     * - minOccurs: 0
     * @var string
     */
    public $Classification;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for TrackPayment
     * @uses CosolisTrackPayment::setClassification()
     * @uses CosolisTrackPayment::setType()
     * @uses CosolisTrackPayment::setDescription()
     * @param string $classification
     * @param string $type
     * @param string $description
     */
    public function __construct($classification = null, $type = null, $description = null)
    {
        $this
            ->setClassification($classification)
            ->setType($type)
            ->setDescription($description);
    }
    /**
     * Get Classification value
     * @return string|null
     */
    public function getClassification()
    {
        return $this->Classification;
    }
    /**
     * Set Classification value
     * @uses \cosolis\EnumType\CosolisTrackChargesPaymentClassificationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackChargesPaymentClassificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classification
     * @return \cosolis\StructType\CosolisTrackPayment
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackChargesPaymentClassificationType::valueIsValid($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackChargesPaymentClassificationType', is_array($classification) ? implode(', ', $classification) : var_export($classification, true), implode(', ', \cosolis\EnumType\CosolisTrackChargesPaymentClassificationType::getValidValues())), __LINE__);
        }
        $this->Classification = $classification;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \cosolis\EnumType\CosolisTrackPaymentType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackPaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \cosolis\StructType\CosolisTrackPayment
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackPaymentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackPaymentType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \cosolis\EnumType\CosolisTrackPaymentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisTrackPayment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
