<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackPackageIdentifier StructType
 * Meta information extracted from the WSDL
 * - documentation: The type and value of the package identifier that is to be used to retrieve the tracking information for a package.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackPackageIdentifier extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The type of the Value to be used to retrieve tracking information for a package (e.g. SHIPPER_REFERENCE, PURCHASE_ORDER, TRACKING_NUMBER_OR_DOORTAG, etc..) .
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: The value to be used to retrieve tracking information for a package.
     * - minOccurs: 1
     * @var string
     */
    public $Value;
    /**
     * Constructor method for TrackPackageIdentifier
     * @uses CosolisTrackPackageIdentifier::setType()
     * @uses CosolisTrackPackageIdentifier::setValue()
     * @param string $type
     * @param string $value
     */
    public function __construct($type = null, $value = null)
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \cosolis\EnumType\CosolisTrackIdentifierType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackIdentifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \cosolis\StructType\CosolisTrackPackageIdentifier
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackIdentifierType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackIdentifierType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \cosolis\EnumType\CosolisTrackIdentifierType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \cosolis\StructType\CosolisTrackPackageIdentifier
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackPackageIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
