<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackNotificationRecipientDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Options available for a tracking notification recipient.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackNotificationRecipientDetail extends AbstractStructBase
{
    /**
     * The NotificationEventsAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NotificationEventsAvailable;
    /**
     * Constructor method for TrackNotificationRecipientDetail
     * @uses CosolisTrackNotificationRecipientDetail::setNotificationEventsAvailable()
     * @param string[] $notificationEventsAvailable
     */
    public function __construct(array $notificationEventsAvailable = array())
    {
        $this
            ->setNotificationEventsAvailable($notificationEventsAvailable);
    }
    /**
     * Get NotificationEventsAvailable value
     * @return string[]|null
     */
    public function getNotificationEventsAvailable()
    {
        return $this->NotificationEventsAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setNotificationEventsAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotificationEventsAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationEventsAvailableForArrayConstraintsFromSetNotificationEventsAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackNotificationRecipientDetailNotificationEventsAvailableItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($trackNotificationRecipientDetailNotificationEventsAvailableItem)) {
                $invalidValues[] = is_object($trackNotificationRecipientDetailNotificationEventsAvailableItem) ? get_class($trackNotificationRecipientDetailNotificationEventsAvailableItem) : sprintf('%s(%s)', gettype($trackNotificationRecipientDetailNotificationEventsAvailableItem), var_export($trackNotificationRecipientDetailNotificationEventsAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NotificationEventsAvailable value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $notificationEventsAvailable
     * @return \cosolis\StructType\CosolisTrackNotificationRecipientDetail
     */
    public function setNotificationEventsAvailable(array $notificationEventsAvailable = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationEventsAvailableArrayErrorMessage = self::validateNotificationEventsAvailableForArrayConstraintsFromSetNotificationEventsAvailable($notificationEventsAvailable))) {
            throw new \InvalidArgumentException($notificationEventsAvailableArrayErrorMessage, __LINE__);
        }
        $this->NotificationEventsAvailable = $notificationEventsAvailable;
        return $this;
    }
    /**
     * Add item to NotificationEventsAvailable value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackNotificationRecipientDetail
     */
    public function addToNotificationEventsAvailable($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsAvailable[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackNotificationRecipientDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
