<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackNotificationPackage StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackNotificationPackage extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - documentation: FedEx assigned identifier for a package/shipment.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The TrackingNumberUniqueIdentifiers
     * Meta information extracted from the WSDL
     * - documentation: When duplicate tracking numbers exist this data is returned with summary information for each of the duplicates. The summary information is used to determine which of the duplicates the intended tracking number is. This identifier is
     * used on a subsequent track request to retrieve the tracking data for the desired tracking number.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumberUniqueIdentifiers;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Identification of a FedEx operating company (transportation).
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The ShipDate
     * Meta information extracted from the WSDL
     * - documentation: The date the package was shipped (tendered to FedEx).
     * - minOccurs: 0
     * @var string
     */
    public $ShipDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - documentation: The destination address of this package. Only city, state/province, and country are returned.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $Destination;
    /**
     * The RecipientDetails
     * Meta information extracted from the WSDL
     * - documentation: Options available for a tracking notification recipient.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackNotificationRecipientDetail[]
     */
    public $RecipientDetails;
    /**
     * Constructor method for TrackNotificationPackage
     * @uses CosolisTrackNotificationPackage::setTrackingNumber()
     * @uses CosolisTrackNotificationPackage::setTrackingNumberUniqueIdentifiers()
     * @uses CosolisTrackNotificationPackage::setCarrierCode()
     * @uses CosolisTrackNotificationPackage::setShipDate()
     * @uses CosolisTrackNotificationPackage::setDestination()
     * @uses CosolisTrackNotificationPackage::setRecipientDetails()
     * @param string $trackingNumber
     * @param string $trackingNumberUniqueIdentifiers
     * @param string $carrierCode
     * @param string $shipDate
     * @param \cosolis\StructType\CosolisAddress $destination
     * @param \cosolis\StructType\CosolisTrackNotificationRecipientDetail[] $recipientDetails
     */
    public function __construct($trackingNumber = null, $trackingNumberUniqueIdentifiers = null, $carrierCode = null, $shipDate = null, \cosolis\StructType\CosolisAddress $destination = null, array $recipientDetails = array())
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setTrackingNumberUniqueIdentifiers($trackingNumberUniqueIdentifiers)
            ->setCarrierCode($carrierCode)
            ->setShipDate($shipDate)
            ->setDestination($destination)
            ->setRecipientDetails($recipientDetails);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get TrackingNumberUniqueIdentifiers value
     * @return string|null
     */
    public function getTrackingNumberUniqueIdentifiers()
    {
        return $this->TrackingNumberUniqueIdentifiers;
    }
    /**
     * Set TrackingNumberUniqueIdentifiers value
     * @param string $trackingNumberUniqueIdentifiers
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setTrackingNumberUniqueIdentifiers($trackingNumberUniqueIdentifiers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberUniqueIdentifiers) && !is_string($trackingNumberUniqueIdentifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumberUniqueIdentifiers, true), gettype($trackingNumberUniqueIdentifiers)), __LINE__);
        }
        $this->TrackingNumberUniqueIdentifiers = $trackingNumberUniqueIdentifiers;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrierCode
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisCarrierCodeType::valueIsValid($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisCarrierCodeType', is_array($carrierCode) ? implode(', ', $carrierCode) : var_export($carrierCode, true), implode(', ', \cosolis\EnumType\CosolisCarrierCodeType::getValidValues())), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get ShipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->ShipDate;
    }
    /**
     * Set ShipDate value
     * @param string $shipDate
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->ShipDate = $shipDate;
        return $this;
    }
    /**
     * Get Destination value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \cosolis\StructType\CosolisAddress $destination
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setDestination(\cosolis\StructType\CosolisAddress $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get RecipientDetails value
     * @return \cosolis\StructType\CosolisTrackNotificationRecipientDetail[]|null
     */
    public function getRecipientDetails()
    {
        return $this->RecipientDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientDetailsForArrayConstraintsFromSetRecipientDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackNotificationPackageRecipientDetailsItem) {
            // validation for constraint: itemType
            if (!$trackNotificationPackageRecipientDetailsItem instanceof \cosolis\StructType\CosolisTrackNotificationRecipientDetail) {
                $invalidValues[] = is_object($trackNotificationPackageRecipientDetailsItem) ? get_class($trackNotificationPackageRecipientDetailsItem) : sprintf('%s(%s)', gettype($trackNotificationPackageRecipientDetailsItem), var_export($trackNotificationPackageRecipientDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecipientDetails property can only contain items of type \cosolis\StructType\CosolisTrackNotificationRecipientDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecipientDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackNotificationRecipientDetail[] $recipientDetails
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function setRecipientDetails(array $recipientDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientDetailsArrayErrorMessage = self::validateRecipientDetailsForArrayConstraintsFromSetRecipientDetails($recipientDetails))) {
            throw new \InvalidArgumentException($recipientDetailsArrayErrorMessage, __LINE__);
        }
        $this->RecipientDetails = $recipientDetails;
        return $this;
    }
    /**
     * Add item to RecipientDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackNotificationRecipientDetail $item
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public function addToRecipientDetails(\cosolis\StructType\CosolisTrackNotificationRecipientDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackNotificationRecipientDetail) {
            throw new \InvalidArgumentException(sprintf('The RecipientDetails property can only contain items of type \cosolis\StructType\CosolisTrackNotificationRecipientDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecipientDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackNotificationPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
