<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackEvent StructType
 * Meta information extracted from the WSDL
 * - documentation: FedEx scanning information about a package.
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackEvent extends AbstractStructBase
{
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: The time this event occurred.
     * - minOccurs: 0
     * @var string
     */
    public $Timestamp;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - documentation: Carrier's scan code. Pairs with EventDescription.
     * - minOccurs: 0
     * @var string
     */
    public $EventType;
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - documentation: Literal description that pairs with the EventType.
     * - minOccurs: 0
     * @var string
     */
    public $EventDescription;
    /**
     * The StatusExceptionCode
     * Meta information extracted from the WSDL
     * - documentation: Further defines the Scan Type code's specific type (e.g., DEX08 business closed). Pairs with StatusExceptionDescription.
     * - minOccurs: 0
     * @var string
     */
    public $StatusExceptionCode;
    /**
     * The StatusExceptionDescription
     * Meta information extracted from the WSDL
     * - documentation: Literal description that pairs with the StatusExceptionCode.
     * - minOccurs: 0
     * @var string
     */
    public $StatusExceptionDescription;
    /**
     * The BarcodeEntryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeEntryType;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address information of the station that is responsible for the scan.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $Address;
    /**
     * The StationId
     * Meta information extracted from the WSDL
     * - documentation: FedEx location ID where the scan took place. (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $StationId;
    /**
     * The ArrivalLocation
     * Meta information extracted from the WSDL
     * - documentation: Indicates where the arrival actually occurred.
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalLocation;
    /**
     * Constructor method for TrackEvent
     * @uses CosolisTrackEvent::setTimestamp()
     * @uses CosolisTrackEvent::setEventType()
     * @uses CosolisTrackEvent::setEventDescription()
     * @uses CosolisTrackEvent::setStatusExceptionCode()
     * @uses CosolisTrackEvent::setStatusExceptionDescription()
     * @uses CosolisTrackEvent::setBarcodeEntryType()
     * @uses CosolisTrackEvent::setAddress()
     * @uses CosolisTrackEvent::setStationId()
     * @uses CosolisTrackEvent::setArrivalLocation()
     * @param string $timestamp
     * @param string $eventType
     * @param string $eventDescription
     * @param string $statusExceptionCode
     * @param string $statusExceptionDescription
     * @param string $barcodeEntryType
     * @param \cosolis\StructType\CosolisAddress $address
     * @param string $stationId
     * @param string $arrivalLocation
     */
    public function __construct($timestamp = null, $eventType = null, $eventDescription = null, $statusExceptionCode = null, $statusExceptionDescription = null, $barcodeEntryType = null, \cosolis\StructType\CosolisAddress $address = null, $stationId = null, $arrivalLocation = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setEventType($eventType)
            ->setEventDescription($eventDescription)
            ->setStatusExceptionCode($statusExceptionCode)
            ->setStatusExceptionDescription($statusExceptionDescription)
            ->setBarcodeEntryType($barcodeEntryType)
            ->setAddress($address)
            ->setStationId($stationId)
            ->setArrivalLocation($arrivalLocation);
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @param string $eventType
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get EventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->EventDescription;
    }
    /**
     * Set EventDescription value
     * @param string $eventDescription
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->EventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get StatusExceptionCode value
     * @return string|null
     */
    public function getStatusExceptionCode()
    {
        return $this->StatusExceptionCode;
    }
    /**
     * Set StatusExceptionCode value
     * @param string $statusExceptionCode
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setStatusExceptionCode($statusExceptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusExceptionCode) && !is_string($statusExceptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusExceptionCode, true), gettype($statusExceptionCode)), __LINE__);
        }
        $this->StatusExceptionCode = $statusExceptionCode;
        return $this;
    }
    /**
     * Get StatusExceptionDescription value
     * @return string|null
     */
    public function getStatusExceptionDescription()
    {
        return $this->StatusExceptionDescription;
    }
    /**
     * Set StatusExceptionDescription value
     * @param string $statusExceptionDescription
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setStatusExceptionDescription($statusExceptionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusExceptionDescription) && !is_string($statusExceptionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusExceptionDescription, true), gettype($statusExceptionDescription)), __LINE__);
        }
        $this->StatusExceptionDescription = $statusExceptionDescription;
        return $this;
    }
    /**
     * Get BarcodeEntryType value
     * @return string|null
     */
    public function getBarcodeEntryType()
    {
        return $this->BarcodeEntryType;
    }
    /**
     * Set BarcodeEntryType value
     * @uses \cosolis\EnumType\CosolisBarcodeEntryType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisBarcodeEntryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barcodeEntryType
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setBarcodeEntryType($barcodeEntryType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisBarcodeEntryType::valueIsValid($barcodeEntryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisBarcodeEntryType', is_array($barcodeEntryType) ? implode(', ', $barcodeEntryType) : var_export($barcodeEntryType, true), implode(', ', \cosolis\EnumType\CosolisBarcodeEntryType::getValidValues())), __LINE__);
        }
        $this->BarcodeEntryType = $barcodeEntryType;
        return $this;
    }
    /**
     * Get Address value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \cosolis\StructType\CosolisAddress $address
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setAddress(\cosolis\StructType\CosolisAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get StationId value
     * @return string|null
     */
    public function getStationId()
    {
        return $this->StationId;
    }
    /**
     * Set StationId value
     * @param string $stationId
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setStationId($stationId = null)
    {
        // validation for constraint: string
        if (!is_null($stationId) && !is_string($stationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationId, true), gettype($stationId)), __LINE__);
        }
        $this->StationId = $stationId;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return string|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @uses \cosolis\EnumType\CosolisArrivalLocationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisArrivalLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalLocation
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public function setArrivalLocation($arrivalLocation = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisArrivalLocationType::valueIsValid($arrivalLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisArrivalLocationType', is_array($arrivalLocation) ? implode(', ', $arrivalLocation) : var_export($arrivalLocation, true), implode(', ', \cosolis\EnumType\CosolisArrivalLocationType::getValidValues())), __LINE__);
        }
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
