<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisTrackDetail extends AbstractStructBase
{
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - documentation: To report soft error on an individual track detail.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisNotification
     */
    public $Notification;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - documentation: The FedEx package identifier.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisStringBarcode
     */
    public $Barcode;
    /**
     * The TrackingNumberUniqueIdentifier
     * Meta information extracted from the WSDL
     * - documentation: When duplicate tracking numbers exist this data is returned with summary information for each of the duplicates. The summary information is used to determine which of the duplicates the intended tracking number is. This identifier is
     * used on a subsequent track request to retrieve the tracking data for the desired tracking number.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumberUniqueIdentifier;
    /**
     * The StatusDetail
     * Meta information extracted from the WSDL
     * - documentation: Specifies details about the status of the shipment being tracked.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackStatusDetail
     */
    public $StatusDetail;
    /**
     * The InformationNotes
     * Meta information extracted from the WSDL
     * - documentation: Notifications to the end user that provide additional information relevant to the tracked shipment. For example, a notification may indicate that a change in behavior has occurred.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackInformationNoteDetail[]
     */
    public $InformationNotes;
    /**
     * The CustomerExceptionRequests
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisCustomerExceptionRequestDetail[]
     */
    public $CustomerExceptionRequests;
    /**
     * The Reconciliation
     * Meta information extracted from the WSDL
     * - documentation: Used to report the status of a piece of a multiple piece shipment which is no longer traveling with the rest of the packages in the shipment or has not been accounted for.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackReconciliation
     */
    public $Reconciliation;
    /**
     * The ServiceCommitMessage
     * Meta information extracted from the WSDL
     * - documentation: Used to convey information such as. 1. FedEx has received information about a package but has not yet taken possession of it. 2. FedEx has handed the package off to a third party for final delivery. 3. The package delivery has been
     * cancelled
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCommitMessage;
    /**
     * The DestinationServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationServiceArea;
    /**
     * The DestinationServiceAreaDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationServiceAreaDescription;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies a FedEx operating company (transportation).
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The OperatingCompany
     * Meta information extracted from the WSDL
     * - documentation: Identifies operating transportation company that is the specific to the carrier code.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCompany;
    /**
     * The OperatingCompanyOrCarrierDescription
     * Meta information extracted from the WSDL
     * - documentation: Specifies a detailed description about the carrier or the operating company.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCompanyOrCarrierDescription;
    /**
     * The CartageAgentCompanyName
     * Meta information extracted from the WSDL
     * - documentation: If the package was interlined to a cartage agent, this is the name of the cartage agent. (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $CartageAgentCompanyName;
    /**
     * The ProductionLocationContactAndAddress
     * Meta information extracted from the WSDL
     * - documentation: Specifies the FXO production centre contact and address.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisContactAndAddress
     */
    public $ProductionLocationContactAndAddress;
    /**
     * The OtherIdentifiers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackOtherIdentifierDetail[]
     */
    public $OtherIdentifiers;
    /**
     * The FormId
     * Meta information extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $FormId;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Specifies details about service such as service description and type.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackServiceDescriptionDetail
     */
    public $Service;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - documentation: The weight of this package.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisWeight
     */
    public $PackageWeight;
    /**
     * The PackageDimensions
     * Meta information extracted from the WSDL
     * - documentation: Physical dimensions of the package.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisDimensions
     */
    public $PackageDimensions;
    /**
     * The PackageDimensionalWeight
     * Meta information extracted from the WSDL
     * - documentation: The dimensional weight of the package.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisWeight
     */
    public $PackageDimensionalWeight;
    /**
     * The ShipmentWeight
     * Meta information extracted from the WSDL
     * - documentation: The weight of the entire shipment.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisWeight
     */
    public $ShipmentWeight;
    /**
     * The Packaging
     * Meta information extracted from the WSDL
     * - documentation: Specifies details about packaging such as packaging description and type.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackPackagingDescriptionDetail
     */
    public $Packaging;
    /**
     * The PhysicalPackagingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PhysicalPackagingType;
    /**
     * The PackageSequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The sequence number of this package in a shipment. This would be 2 if it was package number 2 of 4.
     * - minOccurs: 0
     * @var int
     */
    public $PackageSequenceNumber;
    /**
     * The PackageCount
     * Meta information extracted from the WSDL
     * - documentation: The number of packages in this shipment.
     * - minOccurs: 0
     * @var int
     */
    public $PackageCount;
    /**
     * The ShipmentContentPieceCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShipmentContentPieceCount;
    /**
     * The PackageContentPieceCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackageContentPieceCount;
    /**
     * The CreatorSoftwareId
     * Meta information extracted from the WSDL
     * - documentation: FOR FEDEX INTERNAL USE ONLY: Specifies the software id of the device that was used to create this tracked shipment.
     * - minOccurs: 0
     * @var string
     */
    public $CreatorSoftwareId;
    /**
     * The Charges
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details about the SPOC details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackChargeDetail[]
     */
    public $Charges;
    /**
     * The NickName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NickName;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Attributes;
    /**
     * The ShipmentContents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisContentRecord[]
     */
    public $ShipmentContents;
    /**
     * The PackageContents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PackageContents;
    /**
     * The ClearanceLocationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClearanceLocationCode;
    /**
     * The ClearanceBrokerage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClearanceBrokerage;
    /**
     * The Commodities
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisCommodity[]
     */
    public $Commodities;
    /**
     * The ReturnDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackReturnDetail
     */
    public $ReturnDetail;
    /**
     * The CustomsOptionDetails
     * Meta information extracted from the WSDL
     * - documentation: Specifies the reason for return.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisCustomsOptionDetail[]
     */
    public $CustomsOptionDetails;
    /**
     * The AdvanceNotificationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackAdvanceNotificationDetail
     */
    public $AdvanceNotificationDetail;
    /**
     * The SpecialHandlings
     * Meta information extracted from the WSDL
     * - documentation: List of special handlings that applied to this package.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackSpecialHandling[]
     */
    public $SpecialHandlings;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details about the payments for the shipment being tracked.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackPayment[]
     */
    public $Payments;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisContact
     */
    public $Shipper;
    /**
     * The PossessionStatus
     * Meta information extracted from the WSDL
     * - documentation: Indicates last-known possession of package (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $PossessionStatus;
    /**
     * The ShipperAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $ShipperAddress;
    /**
     * The OriginLocationAddress
     * Meta information extracted from the WSDL
     * - documentation: The address of the FedEx pickup location/facility.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $OriginLocationAddress;
    /**
     * The OriginStationId
     * Meta information extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $OriginStationId;
    /**
     * The DatesOrTimes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingDateOrTimestamp[]
     */
    public $DatesOrTimes;
    /**
     * The TotalTransitDistance
     * Meta information extracted from the WSDL
     * - documentation: The distance from the origin to the destination. Returned for Custom Critical shipments.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisDistance
     */
    public $TotalTransitDistance;
    /**
     * The DistanceToDestination
     * Meta information extracted from the WSDL
     * - documentation: Total distance package still has to travel. Returned for Custom Critical shipments.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisDistance
     */
    public $DistanceToDestination;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - documentation: Provides additional details about package delivery.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackSpecialInstruction[]
     */
    public $SpecialInstructions;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisContact
     */
    public $Recipient;
    /**
     * The LastUpdatedDestinationAddress
     * Meta information extracted from the WSDL
     * - documentation: This is the latest updated destination address.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $LastUpdatedDestinationAddress;
    /**
     * The DestinationAddress
     * Meta information extracted from the WSDL
     * - documentation: The address this package is to be (or has been) delivered.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $DestinationAddress;
    /**
     * The HoldAtLocationContact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisContact
     */
    public $HoldAtLocationContact;
    /**
     * The HoldAtLocationAddress
     * Meta information extracted from the WSDL
     * - documentation: The address this package is requested to placed on hold.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $HoldAtLocationAddress;
    /**
     * The DestinationStationId
     * Meta information extracted from the WSDL
     * - documentation: (Returned for CSR SL only.)
     * - minOccurs: 0
     * @var string
     */
    public $DestinationStationId;
    /**
     * The DestinationLocationAddress
     * Meta information extracted from the WSDL
     * - documentation: The address of the FedEx delivery location/facility.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $DestinationLocationAddress;
    /**
     * The DestinationLocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationLocationType;
    /**
     * The DestinationLocationTimeZoneOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationLocationTimeZoneOffset;
    /**
     * The ActualDeliveryAddress
     * Meta information extracted from the WSDL
     * - documentation: Actual address where package was delivered. Differs from destinationAddress, which indicates where the package was to be delivered; This field tells where delivery actually occurred (next door, at station, etc.)
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAddress
     */
    public $ActualDeliveryAddress;
    /**
     * The OfficeOrderDeliveryMethod
     * Meta information extracted from the WSDL
     * - documentation: Identifies the method of office order delivery.
     * - minOccurs: 0
     * @var string
     */
    public $OfficeOrderDeliveryMethod;
    /**
     * The DeliveryLocationType
     * Meta information extracted from the WSDL
     * - documentation: Strict text indicating the delivery location at the delivered to address.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryLocationType;
    /**
     * The DeliveryLocationDescription
     * Meta information extracted from the WSDL
     * - documentation: User/screen friendly representation of the DeliveryLocationType (delivery location at the delivered to address). Can be returned in localized text.
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryLocationDescription;
    /**
     * The DeliveryAttempts
     * Meta information extracted from the WSDL
     * - documentation: Specifies the number of delivery attempts made to deliver the shipment.
     * - minOccurs: 0
     * @var int
     */
    public $DeliveryAttempts;
    /**
     * The DeliverySignatureName
     * Meta information extracted from the WSDL
     * - documentation: This is either the name of the person that signed for the package or "Signature not requested" or "Signature on file".
     * - minOccurs: 0
     * @var string
     */
    public $DeliverySignatureName;
    /**
     * The PieceCountVerificationDetails
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details about the count of the packages delivered at the delivery location and the count of the packages at the origin.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisPieceCountVerificationDetail[]
     */
    public $PieceCountVerificationDetails;
    /**
     * The TotalUniqueAddressCountInConsolidation
     * Meta information extracted from the WSDL
     * - documentation: Specifies the total number of unique addresses on the CRNs in a consolidation.
     * - minOccurs: 0
     * @var int
     */
    public $TotalUniqueAddressCountInConsolidation;
    /**
     * The AvailableImages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisAvailableImagesDetail[]
     */
    public $AvailableImages;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisSignatureImageDetail
     */
    public $Signature;
    /**
     * The NotificationEventsAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NotificationEventsAvailable;
    /**
     * The SplitShipmentParts
     * Meta information extracted from the WSDL
     * - documentation: Returned for cargo shipments only when they are currently split across vehicles.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackSplitShipmentPart[]
     */
    public $SplitShipmentParts;
    /**
     * The DeliveryOptionEligibilityDetails
     * Meta information extracted from the WSDL
     * - documentation: Specifies the details about the eligibility for different delivery options.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail[]
     */
    public $DeliveryOptionEligibilityDetails;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - documentation: Event information for a tracking number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackEvent[]
     */
    public $Events;
    /**
     * Constructor method for TrackDetail
     * @uses CosolisTrackDetail::setNotification()
     * @uses CosolisTrackDetail::setTrackingNumber()
     * @uses CosolisTrackDetail::setBarcode()
     * @uses CosolisTrackDetail::setTrackingNumberUniqueIdentifier()
     * @uses CosolisTrackDetail::setStatusDetail()
     * @uses CosolisTrackDetail::setInformationNotes()
     * @uses CosolisTrackDetail::setCustomerExceptionRequests()
     * @uses CosolisTrackDetail::setReconciliation()
     * @uses CosolisTrackDetail::setServiceCommitMessage()
     * @uses CosolisTrackDetail::setDestinationServiceArea()
     * @uses CosolisTrackDetail::setDestinationServiceAreaDescription()
     * @uses CosolisTrackDetail::setCarrierCode()
     * @uses CosolisTrackDetail::setOperatingCompany()
     * @uses CosolisTrackDetail::setOperatingCompanyOrCarrierDescription()
     * @uses CosolisTrackDetail::setCartageAgentCompanyName()
     * @uses CosolisTrackDetail::setProductionLocationContactAndAddress()
     * @uses CosolisTrackDetail::setOtherIdentifiers()
     * @uses CosolisTrackDetail::setFormId()
     * @uses CosolisTrackDetail::setService()
     * @uses CosolisTrackDetail::setPackageWeight()
     * @uses CosolisTrackDetail::setPackageDimensions()
     * @uses CosolisTrackDetail::setPackageDimensionalWeight()
     * @uses CosolisTrackDetail::setShipmentWeight()
     * @uses CosolisTrackDetail::setPackaging()
     * @uses CosolisTrackDetail::setPhysicalPackagingType()
     * @uses CosolisTrackDetail::setPackageSequenceNumber()
     * @uses CosolisTrackDetail::setPackageCount()
     * @uses CosolisTrackDetail::setShipmentContentPieceCount()
     * @uses CosolisTrackDetail::setPackageContentPieceCount()
     * @uses CosolisTrackDetail::setCreatorSoftwareId()
     * @uses CosolisTrackDetail::setCharges()
     * @uses CosolisTrackDetail::setNickName()
     * @uses CosolisTrackDetail::setNotes()
     * @uses CosolisTrackDetail::setAttributes()
     * @uses CosolisTrackDetail::setShipmentContents()
     * @uses CosolisTrackDetail::setPackageContents()
     * @uses CosolisTrackDetail::setClearanceLocationCode()
     * @uses CosolisTrackDetail::setClearanceBrokerage()
     * @uses CosolisTrackDetail::setCommodities()
     * @uses CosolisTrackDetail::setReturnDetail()
     * @uses CosolisTrackDetail::setCustomsOptionDetails()
     * @uses CosolisTrackDetail::setAdvanceNotificationDetail()
     * @uses CosolisTrackDetail::setSpecialHandlings()
     * @uses CosolisTrackDetail::setPayments()
     * @uses CosolisTrackDetail::setShipper()
     * @uses CosolisTrackDetail::setPossessionStatus()
     * @uses CosolisTrackDetail::setShipperAddress()
     * @uses CosolisTrackDetail::setOriginLocationAddress()
     * @uses CosolisTrackDetail::setOriginStationId()
     * @uses CosolisTrackDetail::setDatesOrTimes()
     * @uses CosolisTrackDetail::setTotalTransitDistance()
     * @uses CosolisTrackDetail::setDistanceToDestination()
     * @uses CosolisTrackDetail::setSpecialInstructions()
     * @uses CosolisTrackDetail::setRecipient()
     * @uses CosolisTrackDetail::setLastUpdatedDestinationAddress()
     * @uses CosolisTrackDetail::setDestinationAddress()
     * @uses CosolisTrackDetail::setHoldAtLocationContact()
     * @uses CosolisTrackDetail::setHoldAtLocationAddress()
     * @uses CosolisTrackDetail::setDestinationStationId()
     * @uses CosolisTrackDetail::setDestinationLocationAddress()
     * @uses CosolisTrackDetail::setDestinationLocationType()
     * @uses CosolisTrackDetail::setDestinationLocationTimeZoneOffset()
     * @uses CosolisTrackDetail::setActualDeliveryAddress()
     * @uses CosolisTrackDetail::setOfficeOrderDeliveryMethod()
     * @uses CosolisTrackDetail::setDeliveryLocationType()
     * @uses CosolisTrackDetail::setDeliveryLocationDescription()
     * @uses CosolisTrackDetail::setDeliveryAttempts()
     * @uses CosolisTrackDetail::setDeliverySignatureName()
     * @uses CosolisTrackDetail::setPieceCountVerificationDetails()
     * @uses CosolisTrackDetail::setTotalUniqueAddressCountInConsolidation()
     * @uses CosolisTrackDetail::setAvailableImages()
     * @uses CosolisTrackDetail::setSignature()
     * @uses CosolisTrackDetail::setNotificationEventsAvailable()
     * @uses CosolisTrackDetail::setSplitShipmentParts()
     * @uses CosolisTrackDetail::setDeliveryOptionEligibilityDetails()
     * @uses CosolisTrackDetail::setEvents()
     * @param \cosolis\StructType\CosolisNotification $notification
     * @param string $trackingNumber
     * @param \cosolis\StructType\CosolisStringBarcode $barcode
     * @param string $trackingNumberUniqueIdentifier
     * @param \cosolis\StructType\CosolisTrackStatusDetail $statusDetail
     * @param \cosolis\StructType\CosolisTrackInformationNoteDetail[] $informationNotes
     * @param \cosolis\StructType\CosolisCustomerExceptionRequestDetail[] $customerExceptionRequests
     * @param \cosolis\StructType\CosolisTrackReconciliation $reconciliation
     * @param string $serviceCommitMessage
     * @param string $destinationServiceArea
     * @param string $destinationServiceAreaDescription
     * @param string $carrierCode
     * @param string $operatingCompany
     * @param string $operatingCompanyOrCarrierDescription
     * @param string $cartageAgentCompanyName
     * @param \cosolis\StructType\CosolisContactAndAddress $productionLocationContactAndAddress
     * @param \cosolis\StructType\CosolisTrackOtherIdentifierDetail[] $otherIdentifiers
     * @param string $formId
     * @param \cosolis\StructType\CosolisTrackServiceDescriptionDetail $service
     * @param \cosolis\StructType\CosolisWeight $packageWeight
     * @param \cosolis\StructType\CosolisDimensions $packageDimensions
     * @param \cosolis\StructType\CosolisWeight $packageDimensionalWeight
     * @param \cosolis\StructType\CosolisWeight $shipmentWeight
     * @param \cosolis\StructType\CosolisTrackPackagingDescriptionDetail $packaging
     * @param string $physicalPackagingType
     * @param int $packageSequenceNumber
     * @param int $packageCount
     * @param int $shipmentContentPieceCount
     * @param int $packageContentPieceCount
     * @param string $creatorSoftwareId
     * @param \cosolis\StructType\CosolisTrackChargeDetail[] $charges
     * @param string $nickName
     * @param string $notes
     * @param string[] $attributes
     * @param \cosolis\StructType\CosolisContentRecord[] $shipmentContents
     * @param string[] $packageContents
     * @param string $clearanceLocationCode
     * @param string $clearanceBrokerage
     * @param \cosolis\StructType\CosolisCommodity[] $commodities
     * @param \cosolis\StructType\CosolisTrackReturnDetail $returnDetail
     * @param \cosolis\StructType\CosolisCustomsOptionDetail[] $customsOptionDetails
     * @param \cosolis\StructType\CosolisTrackAdvanceNotificationDetail $advanceNotificationDetail
     * @param \cosolis\StructType\CosolisTrackSpecialHandling[] $specialHandlings
     * @param \cosolis\StructType\CosolisTrackPayment[] $payments
     * @param \cosolis\StructType\CosolisContact $shipper
     * @param string $possessionStatus
     * @param \cosolis\StructType\CosolisAddress $shipperAddress
     * @param \cosolis\StructType\CosolisAddress $originLocationAddress
     * @param string $originStationId
     * @param \cosolis\StructType\CosolisTrackingDateOrTimestamp[] $datesOrTimes
     * @param \cosolis\StructType\CosolisDistance $totalTransitDistance
     * @param \cosolis\StructType\CosolisDistance $distanceToDestination
     * @param \cosolis\StructType\CosolisTrackSpecialInstruction[] $specialInstructions
     * @param \cosolis\StructType\CosolisContact $recipient
     * @param \cosolis\StructType\CosolisAddress $lastUpdatedDestinationAddress
     * @param \cosolis\StructType\CosolisAddress $destinationAddress
     * @param \cosolis\StructType\CosolisContact $holdAtLocationContact
     * @param \cosolis\StructType\CosolisAddress $holdAtLocationAddress
     * @param string $destinationStationId
     * @param \cosolis\StructType\CosolisAddress $destinationLocationAddress
     * @param string $destinationLocationType
     * @param string $destinationLocationTimeZoneOffset
     * @param \cosolis\StructType\CosolisAddress $actualDeliveryAddress
     * @param string $officeOrderDeliveryMethod
     * @param string $deliveryLocationType
     * @param string $deliveryLocationDescription
     * @param int $deliveryAttempts
     * @param string $deliverySignatureName
     * @param \cosolis\StructType\CosolisPieceCountVerificationDetail[] $pieceCountVerificationDetails
     * @param int $totalUniqueAddressCountInConsolidation
     * @param \cosolis\StructType\CosolisAvailableImagesDetail[] $availableImages
     * @param \cosolis\StructType\CosolisSignatureImageDetail $signature
     * @param string[] $notificationEventsAvailable
     * @param \cosolis\StructType\CosolisTrackSplitShipmentPart[] $splitShipmentParts
     * @param \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail[] $deliveryOptionEligibilityDetails
     * @param \cosolis\StructType\CosolisTrackEvent[] $events
     */
    public function __construct(\cosolis\StructType\CosolisNotification $notification = null, $trackingNumber = null, \cosolis\StructType\CosolisStringBarcode $barcode = null, $trackingNumberUniqueIdentifier = null, \cosolis\StructType\CosolisTrackStatusDetail $statusDetail = null, array $informationNotes = array(), array $customerExceptionRequests = array(), \cosolis\StructType\CosolisTrackReconciliation $reconciliation = null, $serviceCommitMessage = null, $destinationServiceArea = null, $destinationServiceAreaDescription = null, $carrierCode = null, $operatingCompany = null, $operatingCompanyOrCarrierDescription = null, $cartageAgentCompanyName = null, \cosolis\StructType\CosolisContactAndAddress $productionLocationContactAndAddress = null, array $otherIdentifiers = array(), $formId = null, \cosolis\StructType\CosolisTrackServiceDescriptionDetail $service = null, \cosolis\StructType\CosolisWeight $packageWeight = null, \cosolis\StructType\CosolisDimensions $packageDimensions = null, \cosolis\StructType\CosolisWeight $packageDimensionalWeight = null, \cosolis\StructType\CosolisWeight $shipmentWeight = null, \cosolis\StructType\CosolisTrackPackagingDescriptionDetail $packaging = null, $physicalPackagingType = null, $packageSequenceNumber = null, $packageCount = null, $shipmentContentPieceCount = null, $packageContentPieceCount = null, $creatorSoftwareId = null, array $charges = array(), $nickName = null, $notes = null, array $attributes = array(), array $shipmentContents = array(), array $packageContents = array(), $clearanceLocationCode = null, $clearanceBrokerage = null, array $commodities = array(), \cosolis\StructType\CosolisTrackReturnDetail $returnDetail = null, array $customsOptionDetails = array(), \cosolis\StructType\CosolisTrackAdvanceNotificationDetail $advanceNotificationDetail = null, array $specialHandlings = array(), array $payments = array(), \cosolis\StructType\CosolisContact $shipper = null, $possessionStatus = null, \cosolis\StructType\CosolisAddress $shipperAddress = null, \cosolis\StructType\CosolisAddress $originLocationAddress = null, $originStationId = null, array $datesOrTimes = array(), \cosolis\StructType\CosolisDistance $totalTransitDistance = null, \cosolis\StructType\CosolisDistance $distanceToDestination = null, array $specialInstructions = array(), \cosolis\StructType\CosolisContact $recipient = null, \cosolis\StructType\CosolisAddress $lastUpdatedDestinationAddress = null, \cosolis\StructType\CosolisAddress $destinationAddress = null, \cosolis\StructType\CosolisContact $holdAtLocationContact = null, \cosolis\StructType\CosolisAddress $holdAtLocationAddress = null, $destinationStationId = null, \cosolis\StructType\CosolisAddress $destinationLocationAddress = null, $destinationLocationType = null, $destinationLocationTimeZoneOffset = null, \cosolis\StructType\CosolisAddress $actualDeliveryAddress = null, $officeOrderDeliveryMethod = null, $deliveryLocationType = null, $deliveryLocationDescription = null, $deliveryAttempts = null, $deliverySignatureName = null, array $pieceCountVerificationDetails = array(), $totalUniqueAddressCountInConsolidation = null, array $availableImages = array(), \cosolis\StructType\CosolisSignatureImageDetail $signature = null, array $notificationEventsAvailable = array(), array $splitShipmentParts = array(), array $deliveryOptionEligibilityDetails = array(), array $events = array())
    {
        $this
            ->setNotification($notification)
            ->setTrackingNumber($trackingNumber)
            ->setBarcode($barcode)
            ->setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier)
            ->setStatusDetail($statusDetail)
            ->setInformationNotes($informationNotes)
            ->setCustomerExceptionRequests($customerExceptionRequests)
            ->setReconciliation($reconciliation)
            ->setServiceCommitMessage($serviceCommitMessage)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setDestinationServiceAreaDescription($destinationServiceAreaDescription)
            ->setCarrierCode($carrierCode)
            ->setOperatingCompany($operatingCompany)
            ->setOperatingCompanyOrCarrierDescription($operatingCompanyOrCarrierDescription)
            ->setCartageAgentCompanyName($cartageAgentCompanyName)
            ->setProductionLocationContactAndAddress($productionLocationContactAndAddress)
            ->setOtherIdentifiers($otherIdentifiers)
            ->setFormId($formId)
            ->setService($service)
            ->setPackageWeight($packageWeight)
            ->setPackageDimensions($packageDimensions)
            ->setPackageDimensionalWeight($packageDimensionalWeight)
            ->setShipmentWeight($shipmentWeight)
            ->setPackaging($packaging)
            ->setPhysicalPackagingType($physicalPackagingType)
            ->setPackageSequenceNumber($packageSequenceNumber)
            ->setPackageCount($packageCount)
            ->setShipmentContentPieceCount($shipmentContentPieceCount)
            ->setPackageContentPieceCount($packageContentPieceCount)
            ->setCreatorSoftwareId($creatorSoftwareId)
            ->setCharges($charges)
            ->setNickName($nickName)
            ->setNotes($notes)
            ->setAttributes($attributes)
            ->setShipmentContents($shipmentContents)
            ->setPackageContents($packageContents)
            ->setClearanceLocationCode($clearanceLocationCode)
            ->setClearanceBrokerage($clearanceBrokerage)
            ->setCommodities($commodities)
            ->setReturnDetail($returnDetail)
            ->setCustomsOptionDetails($customsOptionDetails)
            ->setAdvanceNotificationDetail($advanceNotificationDetail)
            ->setSpecialHandlings($specialHandlings)
            ->setPayments($payments)
            ->setShipper($shipper)
            ->setPossessionStatus($possessionStatus)
            ->setShipperAddress($shipperAddress)
            ->setOriginLocationAddress($originLocationAddress)
            ->setOriginStationId($originStationId)
            ->setDatesOrTimes($datesOrTimes)
            ->setTotalTransitDistance($totalTransitDistance)
            ->setDistanceToDestination($distanceToDestination)
            ->setSpecialInstructions($specialInstructions)
            ->setRecipient($recipient)
            ->setLastUpdatedDestinationAddress($lastUpdatedDestinationAddress)
            ->setDestinationAddress($destinationAddress)
            ->setHoldAtLocationContact($holdAtLocationContact)
            ->setHoldAtLocationAddress($holdAtLocationAddress)
            ->setDestinationStationId($destinationStationId)
            ->setDestinationLocationAddress($destinationLocationAddress)
            ->setDestinationLocationType($destinationLocationType)
            ->setDestinationLocationTimeZoneOffset($destinationLocationTimeZoneOffset)
            ->setActualDeliveryAddress($actualDeliveryAddress)
            ->setOfficeOrderDeliveryMethod($officeOrderDeliveryMethod)
            ->setDeliveryLocationType($deliveryLocationType)
            ->setDeliveryLocationDescription($deliveryLocationDescription)
            ->setDeliveryAttempts($deliveryAttempts)
            ->setDeliverySignatureName($deliverySignatureName)
            ->setPieceCountVerificationDetails($pieceCountVerificationDetails)
            ->setTotalUniqueAddressCountInConsolidation($totalUniqueAddressCountInConsolidation)
            ->setAvailableImages($availableImages)
            ->setSignature($signature)
            ->setNotificationEventsAvailable($notificationEventsAvailable)
            ->setSplitShipmentParts($splitShipmentParts)
            ->setDeliveryOptionEligibilityDetails($deliveryOptionEligibilityDetails)
            ->setEvents($events);
    }
    /**
     * Get Notification value
     * @return \cosolis\StructType\CosolisNotification|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \cosolis\StructType\CosolisNotification $notification
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setNotification(\cosolis\StructType\CosolisNotification $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get Barcode value
     * @return \cosolis\StructType\CosolisStringBarcode|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param \cosolis\StructType\CosolisStringBarcode $barcode
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setBarcode(\cosolis\StructType\CosolisStringBarcode $barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get TrackingNumberUniqueIdentifier value
     * @return string|null
     */
    public function getTrackingNumberUniqueIdentifier()
    {
        return $this->TrackingNumberUniqueIdentifier;
    }
    /**
     * Set TrackingNumberUniqueIdentifier value
     * @param string $trackingNumberUniqueIdentifier
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setTrackingNumberUniqueIdentifier($trackingNumberUniqueIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberUniqueIdentifier) && !is_string($trackingNumberUniqueIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumberUniqueIdentifier, true), gettype($trackingNumberUniqueIdentifier)), __LINE__);
        }
        $this->TrackingNumberUniqueIdentifier = $trackingNumberUniqueIdentifier;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return \cosolis\StructType\CosolisTrackStatusDetail|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param \cosolis\StructType\CosolisTrackStatusDetail $statusDetail
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setStatusDetail(\cosolis\StructType\CosolisTrackStatusDetail $statusDetail = null)
    {
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Get InformationNotes value
     * @return \cosolis\StructType\CosolisTrackInformationNoteDetail[]|null
     */
    public function getInformationNotes()
    {
        return $this->InformationNotes;
    }
    /**
     * This method is responsible for validating the values passed to the setInformationNotes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformationNotes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationNotesForArrayConstraintsFromSetInformationNotes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailInformationNotesItem) {
            // validation for constraint: itemType
            if (!$trackDetailInformationNotesItem instanceof \cosolis\StructType\CosolisTrackInformationNoteDetail) {
                $invalidValues[] = is_object($trackDetailInformationNotesItem) ? get_class($trackDetailInformationNotesItem) : sprintf('%s(%s)', gettype($trackDetailInformationNotesItem), var_export($trackDetailInformationNotesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InformationNotes property can only contain items of type \cosolis\StructType\CosolisTrackInformationNoteDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InformationNotes value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackInformationNoteDetail[] $informationNotes
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setInformationNotes(array $informationNotes = array())
    {
        // validation for constraint: array
        if ('' !== ($informationNotesArrayErrorMessage = self::validateInformationNotesForArrayConstraintsFromSetInformationNotes($informationNotes))) {
            throw new \InvalidArgumentException($informationNotesArrayErrorMessage, __LINE__);
        }
        $this->InformationNotes = $informationNotes;
        return $this;
    }
    /**
     * Add item to InformationNotes value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackInformationNoteDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToInformationNotes(\cosolis\StructType\CosolisTrackInformationNoteDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackInformationNoteDetail) {
            throw new \InvalidArgumentException(sprintf('The InformationNotes property can only contain items of type \cosolis\StructType\CosolisTrackInformationNoteDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InformationNotes[] = $item;
        return $this;
    }
    /**
     * Get CustomerExceptionRequests value
     * @return \cosolis\StructType\CosolisCustomerExceptionRequestDetail[]|null
     */
    public function getCustomerExceptionRequests()
    {
        return $this->CustomerExceptionRequests;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerExceptionRequests method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerExceptionRequests method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerExceptionRequestsForArrayConstraintsFromSetCustomerExceptionRequests(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailCustomerExceptionRequestsItem) {
            // validation for constraint: itemType
            if (!$trackDetailCustomerExceptionRequestsItem instanceof \cosolis\StructType\CosolisCustomerExceptionRequestDetail) {
                $invalidValues[] = is_object($trackDetailCustomerExceptionRequestsItem) ? get_class($trackDetailCustomerExceptionRequestsItem) : sprintf('%s(%s)', gettype($trackDetailCustomerExceptionRequestsItem), var_export($trackDetailCustomerExceptionRequestsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerExceptionRequests property can only contain items of type \cosolis\StructType\CosolisCustomerExceptionRequestDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerExceptionRequests value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCustomerExceptionRequestDetail[] $customerExceptionRequests
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCustomerExceptionRequests(array $customerExceptionRequests = array())
    {
        // validation for constraint: array
        if ('' !== ($customerExceptionRequestsArrayErrorMessage = self::validateCustomerExceptionRequestsForArrayConstraintsFromSetCustomerExceptionRequests($customerExceptionRequests))) {
            throw new \InvalidArgumentException($customerExceptionRequestsArrayErrorMessage, __LINE__);
        }
        $this->CustomerExceptionRequests = $customerExceptionRequests;
        return $this;
    }
    /**
     * Add item to CustomerExceptionRequests value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCustomerExceptionRequestDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToCustomerExceptionRequests(\cosolis\StructType\CosolisCustomerExceptionRequestDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisCustomerExceptionRequestDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomerExceptionRequests property can only contain items of type \cosolis\StructType\CosolisCustomerExceptionRequestDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerExceptionRequests[] = $item;
        return $this;
    }
    /**
     * Get Reconciliation value
     * @return \cosolis\StructType\CosolisTrackReconciliation|null
     */
    public function getReconciliation()
    {
        return $this->Reconciliation;
    }
    /**
     * Set Reconciliation value
     * @param \cosolis\StructType\CosolisTrackReconciliation $reconciliation
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setReconciliation(\cosolis\StructType\CosolisTrackReconciliation $reconciliation = null)
    {
        $this->Reconciliation = $reconciliation;
        return $this;
    }
    /**
     * Get ServiceCommitMessage value
     * @return string|null
     */
    public function getServiceCommitMessage()
    {
        return $this->ServiceCommitMessage;
    }
    /**
     * Set ServiceCommitMessage value
     * @param string $serviceCommitMessage
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setServiceCommitMessage($serviceCommitMessage = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCommitMessage) && !is_string($serviceCommitMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCommitMessage, true), gettype($serviceCommitMessage)), __LINE__);
        }
        $this->ServiceCommitMessage = $serviceCommitMessage;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return string|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param string $destinationServiceArea
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationServiceArea($destinationServiceArea = null)
    {
        // validation for constraint: string
        if (!is_null($destinationServiceArea) && !is_string($destinationServiceArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationServiceArea, true), gettype($destinationServiceArea)), __LINE__);
        }
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceAreaDescription value
     * @return string|null
     */
    public function getDestinationServiceAreaDescription()
    {
        return $this->DestinationServiceAreaDescription;
    }
    /**
     * Set DestinationServiceAreaDescription value
     * @param string $destinationServiceAreaDescription
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationServiceAreaDescription($destinationServiceAreaDescription = null)
    {
        // validation for constraint: string
        if (!is_null($destinationServiceAreaDescription) && !is_string($destinationServiceAreaDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationServiceAreaDescription, true), gettype($destinationServiceAreaDescription)), __LINE__);
        }
        $this->DestinationServiceAreaDescription = $destinationServiceAreaDescription;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisCarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrierCode
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisCarrierCodeType::valueIsValid($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisCarrierCodeType', is_array($carrierCode) ? implode(', ', $carrierCode) : var_export($carrierCode, true), implode(', ', \cosolis\EnumType\CosolisCarrierCodeType::getValidValues())), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return string|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @uses \cosolis\EnumType\CosolisOperatingCompanyType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisOperatingCompanyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatingCompany
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOperatingCompany($operatingCompany = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisOperatingCompanyType::valueIsValid($operatingCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisOperatingCompanyType', is_array($operatingCompany) ? implode(', ', $operatingCompany) : var_export($operatingCompany, true), implode(', ', \cosolis\EnumType\CosolisOperatingCompanyType::getValidValues())), __LINE__);
        }
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get OperatingCompanyOrCarrierDescription value
     * @return string|null
     */
    public function getOperatingCompanyOrCarrierDescription()
    {
        return $this->OperatingCompanyOrCarrierDescription;
    }
    /**
     * Set OperatingCompanyOrCarrierDescription value
     * @param string $operatingCompanyOrCarrierDescription
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOperatingCompanyOrCarrierDescription($operatingCompanyOrCarrierDescription = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCompanyOrCarrierDescription) && !is_string($operatingCompanyOrCarrierDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCompanyOrCarrierDescription, true), gettype($operatingCompanyOrCarrierDescription)), __LINE__);
        }
        $this->OperatingCompanyOrCarrierDescription = $operatingCompanyOrCarrierDescription;
        return $this;
    }
    /**
     * Get CartageAgentCompanyName value
     * @return string|null
     */
    public function getCartageAgentCompanyName()
    {
        return $this->CartageAgentCompanyName;
    }
    /**
     * Set CartageAgentCompanyName value
     * @param string $cartageAgentCompanyName
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCartageAgentCompanyName($cartageAgentCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($cartageAgentCompanyName) && !is_string($cartageAgentCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartageAgentCompanyName, true), gettype($cartageAgentCompanyName)), __LINE__);
        }
        $this->CartageAgentCompanyName = $cartageAgentCompanyName;
        return $this;
    }
    /**
     * Get ProductionLocationContactAndAddress value
     * @return \cosolis\StructType\CosolisContactAndAddress|null
     */
    public function getProductionLocationContactAndAddress()
    {
        return $this->ProductionLocationContactAndAddress;
    }
    /**
     * Set ProductionLocationContactAndAddress value
     * @param \cosolis\StructType\CosolisContactAndAddress $productionLocationContactAndAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setProductionLocationContactAndAddress(\cosolis\StructType\CosolisContactAndAddress $productionLocationContactAndAddress = null)
    {
        $this->ProductionLocationContactAndAddress = $productionLocationContactAndAddress;
        return $this;
    }
    /**
     * Get OtherIdentifiers value
     * @return \cosolis\StructType\CosolisTrackOtherIdentifierDetail[]|null
     */
    public function getOtherIdentifiers()
    {
        return $this->OtherIdentifiers;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherIdentifiers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherIdentifiers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherIdentifiersForArrayConstraintsFromSetOtherIdentifiers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailOtherIdentifiersItem) {
            // validation for constraint: itemType
            if (!$trackDetailOtherIdentifiersItem instanceof \cosolis\StructType\CosolisTrackOtherIdentifierDetail) {
                $invalidValues[] = is_object($trackDetailOtherIdentifiersItem) ? get_class($trackDetailOtherIdentifiersItem) : sprintf('%s(%s)', gettype($trackDetailOtherIdentifiersItem), var_export($trackDetailOtherIdentifiersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherIdentifiers property can only contain items of type \cosolis\StructType\CosolisTrackOtherIdentifierDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherIdentifiers value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackOtherIdentifierDetail[] $otherIdentifiers
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOtherIdentifiers(array $otherIdentifiers = array())
    {
        // validation for constraint: array
        if ('' !== ($otherIdentifiersArrayErrorMessage = self::validateOtherIdentifiersForArrayConstraintsFromSetOtherIdentifiers($otherIdentifiers))) {
            throw new \InvalidArgumentException($otherIdentifiersArrayErrorMessage, __LINE__);
        }
        $this->OtherIdentifiers = $otherIdentifiers;
        return $this;
    }
    /**
     * Add item to OtherIdentifiers value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackOtherIdentifierDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToOtherIdentifiers(\cosolis\StructType\CosolisTrackOtherIdentifierDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackOtherIdentifierDetail) {
            throw new \InvalidArgumentException(sprintf('The OtherIdentifiers property can only contain items of type \cosolis\StructType\CosolisTrackOtherIdentifierDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherIdentifiers[] = $item;
        return $this;
    }
    /**
     * Get FormId value
     * @return string|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param string $formId
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: string
        if (!is_null($formId) && !is_string($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formId, true), gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get Service value
     * @return \cosolis\StructType\CosolisTrackServiceDescriptionDetail|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \cosolis\StructType\CosolisTrackServiceDescriptionDetail $service
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setService(\cosolis\StructType\CosolisTrackServiceDescriptionDetail $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \cosolis\StructType\CosolisWeight|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \cosolis\StructType\CosolisWeight $packageWeight
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageWeight(\cosolis\StructType\CosolisWeight $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get PackageDimensions value
     * @return \cosolis\StructType\CosolisDimensions|null
     */
    public function getPackageDimensions()
    {
        return $this->PackageDimensions;
    }
    /**
     * Set PackageDimensions value
     * @param \cosolis\StructType\CosolisDimensions $packageDimensions
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageDimensions(\cosolis\StructType\CosolisDimensions $packageDimensions = null)
    {
        $this->PackageDimensions = $packageDimensions;
        return $this;
    }
    /**
     * Get PackageDimensionalWeight value
     * @return \cosolis\StructType\CosolisWeight|null
     */
    public function getPackageDimensionalWeight()
    {
        return $this->PackageDimensionalWeight;
    }
    /**
     * Set PackageDimensionalWeight value
     * @param \cosolis\StructType\CosolisWeight $packageDimensionalWeight
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageDimensionalWeight(\cosolis\StructType\CosolisWeight $packageDimensionalWeight = null)
    {
        $this->PackageDimensionalWeight = $packageDimensionalWeight;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return \cosolis\StructType\CosolisWeight|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param \cosolis\StructType\CosolisWeight $shipmentWeight
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setShipmentWeight(\cosolis\StructType\CosolisWeight $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get Packaging value
     * @return \cosolis\StructType\CosolisTrackPackagingDescriptionDetail|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param \cosolis\StructType\CosolisTrackPackagingDescriptionDetail $packaging
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackaging(\cosolis\StructType\CosolisTrackPackagingDescriptionDetail $packaging = null)
    {
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get PhysicalPackagingType value
     * @return string|null
     */
    public function getPhysicalPackagingType()
    {
        return $this->PhysicalPackagingType;
    }
    /**
     * Set PhysicalPackagingType value
     * @uses \cosolis\EnumType\CosolisPhysicalPackagingType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisPhysicalPackagingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $physicalPackagingType
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPhysicalPackagingType($physicalPackagingType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisPhysicalPackagingType::valueIsValid($physicalPackagingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisPhysicalPackagingType', is_array($physicalPackagingType) ? implode(', ', $physicalPackagingType) : var_export($physicalPackagingType, true), implode(', ', \cosolis\EnumType\CosolisPhysicalPackagingType::getValidValues())), __LINE__);
        }
        $this->PhysicalPackagingType = $physicalPackagingType;
        return $this;
    }
    /**
     * Get PackageSequenceNumber value
     * @return int|null
     */
    public function getPackageSequenceNumber()
    {
        return $this->PackageSequenceNumber;
    }
    /**
     * Set PackageSequenceNumber value
     * @param int $packageSequenceNumber
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageSequenceNumber($packageSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($packageSequenceNumber) && !(is_int($packageSequenceNumber) || ctype_digit($packageSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageSequenceNumber, true), gettype($packageSequenceNumber)), __LINE__);
        }
        $this->PackageSequenceNumber = $packageSequenceNumber;
        return $this;
    }
    /**
     * Get PackageCount value
     * @return int|null
     */
    public function getPackageCount()
    {
        return $this->PackageCount;
    }
    /**
     * Set PackageCount value
     * @param int $packageCount
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageCount($packageCount = null)
    {
        // validation for constraint: int
        if (!is_null($packageCount) && !(is_int($packageCount) || ctype_digit($packageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageCount, true), gettype($packageCount)), __LINE__);
        }
        $this->PackageCount = $packageCount;
        return $this;
    }
    /**
     * Get ShipmentContentPieceCount value
     * @return int|null
     */
    public function getShipmentContentPieceCount()
    {
        return $this->ShipmentContentPieceCount;
    }
    /**
     * Set ShipmentContentPieceCount value
     * @param int $shipmentContentPieceCount
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setShipmentContentPieceCount($shipmentContentPieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentContentPieceCount) && !(is_int($shipmentContentPieceCount) || ctype_digit($shipmentContentPieceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentContentPieceCount, true), gettype($shipmentContentPieceCount)), __LINE__);
        }
        $this->ShipmentContentPieceCount = $shipmentContentPieceCount;
        return $this;
    }
    /**
     * Get PackageContentPieceCount value
     * @return int|null
     */
    public function getPackageContentPieceCount()
    {
        return $this->PackageContentPieceCount;
    }
    /**
     * Set PackageContentPieceCount value
     * @param int $packageContentPieceCount
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageContentPieceCount($packageContentPieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($packageContentPieceCount) && !(is_int($packageContentPieceCount) || ctype_digit($packageContentPieceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageContentPieceCount, true), gettype($packageContentPieceCount)), __LINE__);
        }
        $this->PackageContentPieceCount = $packageContentPieceCount;
        return $this;
    }
    /**
     * Get CreatorSoftwareId value
     * @return string|null
     */
    public function getCreatorSoftwareId()
    {
        return $this->CreatorSoftwareId;
    }
    /**
     * Set CreatorSoftwareId value
     * @param string $creatorSoftwareId
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCreatorSoftwareId($creatorSoftwareId = null)
    {
        // validation for constraint: string
        if (!is_null($creatorSoftwareId) && !is_string($creatorSoftwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorSoftwareId, true), gettype($creatorSoftwareId)), __LINE__);
        }
        $this->CreatorSoftwareId = $creatorSoftwareId;
        return $this;
    }
    /**
     * Get Charges value
     * @return \cosolis\StructType\CosolisTrackChargeDetail[]|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * This method is responsible for validating the values passed to the setCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargesForArrayConstraintsFromSetCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailChargesItem) {
            // validation for constraint: itemType
            if (!$trackDetailChargesItem instanceof \cosolis\StructType\CosolisTrackChargeDetail) {
                $invalidValues[] = is_object($trackDetailChargesItem) ? get_class($trackDetailChargesItem) : sprintf('%s(%s)', gettype($trackDetailChargesItem), var_export($trackDetailChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charges property can only contain items of type \cosolis\StructType\CosolisTrackChargeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charges value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackChargeDetail[] $charges
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCharges(array $charges = array())
    {
        // validation for constraint: array
        if ('' !== ($chargesArrayErrorMessage = self::validateChargesForArrayConstraintsFromSetCharges($charges))) {
            throw new \InvalidArgumentException($chargesArrayErrorMessage, __LINE__);
        }
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Add item to Charges value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackChargeDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToCharges(\cosolis\StructType\CosolisTrackChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The Charges property can only contain items of type \cosolis\StructType\CosolisTrackChargeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Charges[] = $item;
        return $this;
    }
    /**
     * Get NickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->NickName;
    }
    /**
     * Set NickName value
     * @param string $nickName
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickName, true), gettype($nickName)), __LINE__);
        }
        $this->NickName = $nickName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Attributes value
     * @return string[]|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributesForArrayConstraintsFromSetAttributes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailAttributesItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisTrackDetailAttributeType::valueIsValid($trackDetailAttributesItem)) {
                $invalidValues[] = is_object($trackDetailAttributesItem) ? get_class($trackDetailAttributesItem) : sprintf('%s(%s)', gettype($trackDetailAttributesItem), var_export($trackDetailAttributesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackDetailAttributeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisTrackDetailAttributeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attributes value
     * @uses \cosolis\EnumType\CosolisTrackDetailAttributeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackDetailAttributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $attributes
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setAttributes(array $attributes = array())
    {
        // validation for constraint: array
        if ('' !== ($attributesArrayErrorMessage = self::validateAttributesForArrayConstraintsFromSetAttributes($attributes))) {
            throw new \InvalidArgumentException($attributesArrayErrorMessage, __LINE__);
        }
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Add item to Attributes value
     * @uses \cosolis\EnumType\CosolisTrackDetailAttributeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackDetailAttributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToAttributes($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackDetailAttributeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackDetailAttributeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisTrackDetailAttributeType::getValidValues())), __LINE__);
        }
        $this->Attributes[] = $item;
        return $this;
    }
    /**
     * Get ShipmentContents value
     * @return \cosolis\StructType\CosolisContentRecord[]|null
     */
    public function getShipmentContents()
    {
        return $this->ShipmentContents;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentContents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentContentsForArrayConstraintsFromSetShipmentContents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailShipmentContentsItem) {
            // validation for constraint: itemType
            if (!$trackDetailShipmentContentsItem instanceof \cosolis\StructType\CosolisContentRecord) {
                $invalidValues[] = is_object($trackDetailShipmentContentsItem) ? get_class($trackDetailShipmentContentsItem) : sprintf('%s(%s)', gettype($trackDetailShipmentContentsItem), var_export($trackDetailShipmentContentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentContents property can only contain items of type \cosolis\StructType\CosolisContentRecord, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentContents value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisContentRecord[] $shipmentContents
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setShipmentContents(array $shipmentContents = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentContentsArrayErrorMessage = self::validateShipmentContentsForArrayConstraintsFromSetShipmentContents($shipmentContents))) {
            throw new \InvalidArgumentException($shipmentContentsArrayErrorMessage, __LINE__);
        }
        $this->ShipmentContents = $shipmentContents;
        return $this;
    }
    /**
     * Add item to ShipmentContents value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisContentRecord $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToShipmentContents(\cosolis\StructType\CosolisContentRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisContentRecord) {
            throw new \InvalidArgumentException(sprintf('The ShipmentContents property can only contain items of type \cosolis\StructType\CosolisContentRecord, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentContents[] = $item;
        return $this;
    }
    /**
     * Get PackageContents value
     * @return string[]|null
     */
    public function getPackageContents()
    {
        return $this->PackageContents;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageContents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageContentsForArrayConstraintsFromSetPackageContents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailPackageContentsItem) {
            // validation for constraint: itemType
            if (!is_string($trackDetailPackageContentsItem)) {
                $invalidValues[] = is_object($trackDetailPackageContentsItem) ? get_class($trackDetailPackageContentsItem) : sprintf('%s(%s)', gettype($trackDetailPackageContentsItem), var_export($trackDetailPackageContentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageContents property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageContents value
     * @throws \InvalidArgumentException
     * @param string[] $packageContents
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPackageContents(array $packageContents = array())
    {
        // validation for constraint: array
        if ('' !== ($packageContentsArrayErrorMessage = self::validatePackageContentsForArrayConstraintsFromSetPackageContents($packageContents))) {
            throw new \InvalidArgumentException($packageContentsArrayErrorMessage, __LINE__);
        }
        $this->PackageContents = $packageContents;
        return $this;
    }
    /**
     * Add item to PackageContents value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToPackageContents($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PackageContents property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageContents[] = $item;
        return $this;
    }
    /**
     * Get ClearanceLocationCode value
     * @return string|null
     */
    public function getClearanceLocationCode()
    {
        return $this->ClearanceLocationCode;
    }
    /**
     * Set ClearanceLocationCode value
     * @param string $clearanceLocationCode
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setClearanceLocationCode($clearanceLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($clearanceLocationCode) && !is_string($clearanceLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearanceLocationCode, true), gettype($clearanceLocationCode)), __LINE__);
        }
        $this->ClearanceLocationCode = $clearanceLocationCode;
        return $this;
    }
    /**
     * Get ClearanceBrokerage value
     * @return string|null
     */
    public function getClearanceBrokerage()
    {
        return $this->ClearanceBrokerage;
    }
    /**
     * Set ClearanceBrokerage value
     * @uses \cosolis\EnumType\CosolisClearanceBrokerageType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisClearanceBrokerageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearanceBrokerage
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setClearanceBrokerage($clearanceBrokerage = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisClearanceBrokerageType::valueIsValid($clearanceBrokerage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisClearanceBrokerageType', is_array($clearanceBrokerage) ? implode(', ', $clearanceBrokerage) : var_export($clearanceBrokerage, true), implode(', ', \cosolis\EnumType\CosolisClearanceBrokerageType::getValidValues())), __LINE__);
        }
        $this->ClearanceBrokerage = $clearanceBrokerage;
        return $this;
    }
    /**
     * Get Commodities value
     * @return \cosolis\StructType\CosolisCommodity[]|null
     */
    public function getCommodities()
    {
        return $this->Commodities;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommoditiesForArrayConstraintsFromSetCommodities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailCommoditiesItem) {
            // validation for constraint: itemType
            if (!$trackDetailCommoditiesItem instanceof \cosolis\StructType\CosolisCommodity) {
                $invalidValues[] = is_object($trackDetailCommoditiesItem) ? get_class($trackDetailCommoditiesItem) : sprintf('%s(%s)', gettype($trackDetailCommoditiesItem), var_export($trackDetailCommoditiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodities property can only contain items of type \cosolis\StructType\CosolisCommodity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodities value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCommodity[] $commodities
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCommodities(array $commodities = array())
    {
        // validation for constraint: array
        if ('' !== ($commoditiesArrayErrorMessage = self::validateCommoditiesForArrayConstraintsFromSetCommodities($commodities))) {
            throw new \InvalidArgumentException($commoditiesArrayErrorMessage, __LINE__);
        }
        $this->Commodities = $commodities;
        return $this;
    }
    /**
     * Add item to Commodities value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCommodity $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToCommodities(\cosolis\StructType\CosolisCommodity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisCommodity) {
            throw new \InvalidArgumentException(sprintf('The Commodities property can only contain items of type \cosolis\StructType\CosolisCommodity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodities[] = $item;
        return $this;
    }
    /**
     * Get ReturnDetail value
     * @return \cosolis\StructType\CosolisTrackReturnDetail|null
     */
    public function getReturnDetail()
    {
        return $this->ReturnDetail;
    }
    /**
     * Set ReturnDetail value
     * @param \cosolis\StructType\CosolisTrackReturnDetail $returnDetail
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setReturnDetail(\cosolis\StructType\CosolisTrackReturnDetail $returnDetail = null)
    {
        $this->ReturnDetail = $returnDetail;
        return $this;
    }
    /**
     * Get CustomsOptionDetails value
     * @return \cosolis\StructType\CosolisCustomsOptionDetail[]|null
     */
    public function getCustomsOptionDetails()
    {
        return $this->CustomsOptionDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsOptionDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsOptionDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsOptionDetailsForArrayConstraintsFromSetCustomsOptionDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailCustomsOptionDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailCustomsOptionDetailsItem instanceof \cosolis\StructType\CosolisCustomsOptionDetail) {
                $invalidValues[] = is_object($trackDetailCustomsOptionDetailsItem) ? get_class($trackDetailCustomsOptionDetailsItem) : sprintf('%s(%s)', gettype($trackDetailCustomsOptionDetailsItem), var_export($trackDetailCustomsOptionDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsOptionDetails property can only contain items of type \cosolis\StructType\CosolisCustomsOptionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsOptionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCustomsOptionDetail[] $customsOptionDetails
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setCustomsOptionDetails(array $customsOptionDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($customsOptionDetailsArrayErrorMessage = self::validateCustomsOptionDetailsForArrayConstraintsFromSetCustomsOptionDetails($customsOptionDetails))) {
            throw new \InvalidArgumentException($customsOptionDetailsArrayErrorMessage, __LINE__);
        }
        $this->CustomsOptionDetails = $customsOptionDetails;
        return $this;
    }
    /**
     * Add item to CustomsOptionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisCustomsOptionDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToCustomsOptionDetails(\cosolis\StructType\CosolisCustomsOptionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisCustomsOptionDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomsOptionDetails property can only contain items of type \cosolis\StructType\CosolisCustomsOptionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsOptionDetails[] = $item;
        return $this;
    }
    /**
     * Get AdvanceNotificationDetail value
     * @return \cosolis\StructType\CosolisTrackAdvanceNotificationDetail|null
     */
    public function getAdvanceNotificationDetail()
    {
        return $this->AdvanceNotificationDetail;
    }
    /**
     * Set AdvanceNotificationDetail value
     * @param \cosolis\StructType\CosolisTrackAdvanceNotificationDetail $advanceNotificationDetail
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setAdvanceNotificationDetail(\cosolis\StructType\CosolisTrackAdvanceNotificationDetail $advanceNotificationDetail = null)
    {
        $this->AdvanceNotificationDetail = $advanceNotificationDetail;
        return $this;
    }
    /**
     * Get SpecialHandlings value
     * @return \cosolis\StructType\CosolisTrackSpecialHandling[]|null
     */
    public function getSpecialHandlings()
    {
        return $this->SpecialHandlings;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialHandlings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialHandlings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialHandlingsForArrayConstraintsFromSetSpecialHandlings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailSpecialHandlingsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSpecialHandlingsItem instanceof \cosolis\StructType\CosolisTrackSpecialHandling) {
                $invalidValues[] = is_object($trackDetailSpecialHandlingsItem) ? get_class($trackDetailSpecialHandlingsItem) : sprintf('%s(%s)', gettype($trackDetailSpecialHandlingsItem), var_export($trackDetailSpecialHandlingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialHandlings property can only contain items of type \cosolis\StructType\CosolisTrackSpecialHandling, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialHandlings value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSpecialHandling[] $specialHandlings
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setSpecialHandlings(array $specialHandlings = array())
    {
        // validation for constraint: array
        if ('' !== ($specialHandlingsArrayErrorMessage = self::validateSpecialHandlingsForArrayConstraintsFromSetSpecialHandlings($specialHandlings))) {
            throw new \InvalidArgumentException($specialHandlingsArrayErrorMessage, __LINE__);
        }
        $this->SpecialHandlings = $specialHandlings;
        return $this;
    }
    /**
     * Add item to SpecialHandlings value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSpecialHandling $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToSpecialHandlings(\cosolis\StructType\CosolisTrackSpecialHandling $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackSpecialHandling) {
            throw new \InvalidArgumentException(sprintf('The SpecialHandlings property can only contain items of type \cosolis\StructType\CosolisTrackSpecialHandling, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialHandlings[] = $item;
        return $this;
    }
    /**
     * Get Payments value
     * @return \cosolis\StructType\CosolisTrackPayment[]|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailPaymentsItem) {
            // validation for constraint: itemType
            if (!$trackDetailPaymentsItem instanceof \cosolis\StructType\CosolisTrackPayment) {
                $invalidValues[] = is_object($trackDetailPaymentsItem) ? get_class($trackDetailPaymentsItem) : sprintf('%s(%s)', gettype($trackDetailPaymentsItem), var_export($trackDetailPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payments property can only contain items of type \cosolis\StructType\CosolisTrackPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payments value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackPayment[] $payments
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Add item to Payments value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackPayment $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToPayments(\cosolis\StructType\CosolisTrackPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackPayment) {
            throw new \InvalidArgumentException(sprintf('The Payments property can only contain items of type \cosolis\StructType\CosolisTrackPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payments[] = $item;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \cosolis\StructType\CosolisContact|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \cosolis\StructType\CosolisContact $shipper
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setShipper(\cosolis\StructType\CosolisContact $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get PossessionStatus value
     * @return string|null
     */
    public function getPossessionStatus()
    {
        return $this->PossessionStatus;
    }
    /**
     * Set PossessionStatus value
     * @uses \cosolis\EnumType\CosolisTrackPossessionStatusType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackPossessionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $possessionStatus
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPossessionStatus($possessionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackPossessionStatusType::valueIsValid($possessionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackPossessionStatusType', is_array($possessionStatus) ? implode(', ', $possessionStatus) : var_export($possessionStatus, true), implode(', ', \cosolis\EnumType\CosolisTrackPossessionStatusType::getValidValues())), __LINE__);
        }
        $this->PossessionStatus = $possessionStatus;
        return $this;
    }
    /**
     * Get ShipperAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getShipperAddress()
    {
        return $this->ShipperAddress;
    }
    /**
     * Set ShipperAddress value
     * @param \cosolis\StructType\CosolisAddress $shipperAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setShipperAddress(\cosolis\StructType\CosolisAddress $shipperAddress = null)
    {
        $this->ShipperAddress = $shipperAddress;
        return $this;
    }
    /**
     * Get OriginLocationAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getOriginLocationAddress()
    {
        return $this->OriginLocationAddress;
    }
    /**
     * Set OriginLocationAddress value
     * @param \cosolis\StructType\CosolisAddress $originLocationAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOriginLocationAddress(\cosolis\StructType\CosolisAddress $originLocationAddress = null)
    {
        $this->OriginLocationAddress = $originLocationAddress;
        return $this;
    }
    /**
     * Get OriginStationId value
     * @return string|null
     */
    public function getOriginStationId()
    {
        return $this->OriginStationId;
    }
    /**
     * Set OriginStationId value
     * @param string $originStationId
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOriginStationId($originStationId = null)
    {
        // validation for constraint: string
        if (!is_null($originStationId) && !is_string($originStationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originStationId, true), gettype($originStationId)), __LINE__);
        }
        $this->OriginStationId = $originStationId;
        return $this;
    }
    /**
     * Get DatesOrTimes value
     * @return \cosolis\StructType\CosolisTrackingDateOrTimestamp[]|null
     */
    public function getDatesOrTimes()
    {
        return $this->DatesOrTimes;
    }
    /**
     * This method is responsible for validating the values passed to the setDatesOrTimes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatesOrTimes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatesOrTimesForArrayConstraintsFromSetDatesOrTimes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailDatesOrTimesItem) {
            // validation for constraint: itemType
            if (!$trackDetailDatesOrTimesItem instanceof \cosolis\StructType\CosolisTrackingDateOrTimestamp) {
                $invalidValues[] = is_object($trackDetailDatesOrTimesItem) ? get_class($trackDetailDatesOrTimesItem) : sprintf('%s(%s)', gettype($trackDetailDatesOrTimesItem), var_export($trackDetailDatesOrTimesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatesOrTimes property can only contain items of type \cosolis\StructType\CosolisTrackingDateOrTimestamp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatesOrTimes value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDateOrTimestamp[] $datesOrTimes
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDatesOrTimes(array $datesOrTimes = array())
    {
        // validation for constraint: array
        if ('' !== ($datesOrTimesArrayErrorMessage = self::validateDatesOrTimesForArrayConstraintsFromSetDatesOrTimes($datesOrTimes))) {
            throw new \InvalidArgumentException($datesOrTimesArrayErrorMessage, __LINE__);
        }
        $this->DatesOrTimes = $datesOrTimes;
        return $this;
    }
    /**
     * Add item to DatesOrTimes value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackingDateOrTimestamp $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToDatesOrTimes(\cosolis\StructType\CosolisTrackingDateOrTimestamp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackingDateOrTimestamp) {
            throw new \InvalidArgumentException(sprintf('The DatesOrTimes property can only contain items of type \cosolis\StructType\CosolisTrackingDateOrTimestamp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatesOrTimes[] = $item;
        return $this;
    }
    /**
     * Get TotalTransitDistance value
     * @return \cosolis\StructType\CosolisDistance|null
     */
    public function getTotalTransitDistance()
    {
        return $this->TotalTransitDistance;
    }
    /**
     * Set TotalTransitDistance value
     * @param \cosolis\StructType\CosolisDistance $totalTransitDistance
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setTotalTransitDistance(\cosolis\StructType\CosolisDistance $totalTransitDistance = null)
    {
        $this->TotalTransitDistance = $totalTransitDistance;
        return $this;
    }
    /**
     * Get DistanceToDestination value
     * @return \cosolis\StructType\CosolisDistance|null
     */
    public function getDistanceToDestination()
    {
        return $this->DistanceToDestination;
    }
    /**
     * Set DistanceToDestination value
     * @param \cosolis\StructType\CosolisDistance $distanceToDestination
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDistanceToDestination(\cosolis\StructType\CosolisDistance $distanceToDestination = null)
    {
        $this->DistanceToDestination = $distanceToDestination;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \cosolis\StructType\CosolisTrackSpecialInstruction[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSpecialInstructionsItem instanceof \cosolis\StructType\CosolisTrackSpecialInstruction) {
                $invalidValues[] = is_object($trackDetailSpecialInstructionsItem) ? get_class($trackDetailSpecialInstructionsItem) : sprintf('%s(%s)', gettype($trackDetailSpecialInstructionsItem), var_export($trackDetailSpecialInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialInstructions property can only contain items of type \cosolis\StructType\CosolisTrackSpecialInstruction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSpecialInstruction[] $specialInstructions
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionsArrayErrorMessage = self::validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions($specialInstructions))) {
            throw new \InvalidArgumentException($specialInstructionsArrayErrorMessage, __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSpecialInstruction $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToSpecialInstructions(\cosolis\StructType\CosolisTrackSpecialInstruction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackSpecialInstruction) {
            throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of type \cosolis\StructType\CosolisTrackSpecialInstruction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get Recipient value
     * @return \cosolis\StructType\CosolisContact|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param \cosolis\StructType\CosolisContact $recipient
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setRecipient(\cosolis\StructType\CosolisContact $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get LastUpdatedDestinationAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getLastUpdatedDestinationAddress()
    {
        return $this->LastUpdatedDestinationAddress;
    }
    /**
     * Set LastUpdatedDestinationAddress value
     * @param \cosolis\StructType\CosolisAddress $lastUpdatedDestinationAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setLastUpdatedDestinationAddress(\cosolis\StructType\CosolisAddress $lastUpdatedDestinationAddress = null)
    {
        $this->LastUpdatedDestinationAddress = $lastUpdatedDestinationAddress;
        return $this;
    }
    /**
     * Get DestinationAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param \cosolis\StructType\CosolisAddress $destinationAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationAddress(\cosolis\StructType\CosolisAddress $destinationAddress = null)
    {
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get HoldAtLocationContact value
     * @return \cosolis\StructType\CosolisContact|null
     */
    public function getHoldAtLocationContact()
    {
        return $this->HoldAtLocationContact;
    }
    /**
     * Set HoldAtLocationContact value
     * @param \cosolis\StructType\CosolisContact $holdAtLocationContact
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setHoldAtLocationContact(\cosolis\StructType\CosolisContact $holdAtLocationContact = null)
    {
        $this->HoldAtLocationContact = $holdAtLocationContact;
        return $this;
    }
    /**
     * Get HoldAtLocationAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getHoldAtLocationAddress()
    {
        return $this->HoldAtLocationAddress;
    }
    /**
     * Set HoldAtLocationAddress value
     * @param \cosolis\StructType\CosolisAddress $holdAtLocationAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setHoldAtLocationAddress(\cosolis\StructType\CosolisAddress $holdAtLocationAddress = null)
    {
        $this->HoldAtLocationAddress = $holdAtLocationAddress;
        return $this;
    }
    /**
     * Get DestinationStationId value
     * @return string|null
     */
    public function getDestinationStationId()
    {
        return $this->DestinationStationId;
    }
    /**
     * Set DestinationStationId value
     * @param string $destinationStationId
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationStationId($destinationStationId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationStationId) && !is_string($destinationStationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationStationId, true), gettype($destinationStationId)), __LINE__);
        }
        $this->DestinationStationId = $destinationStationId;
        return $this;
    }
    /**
     * Get DestinationLocationAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getDestinationLocationAddress()
    {
        return $this->DestinationLocationAddress;
    }
    /**
     * Set DestinationLocationAddress value
     * @param \cosolis\StructType\CosolisAddress $destinationLocationAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationLocationAddress(\cosolis\StructType\CosolisAddress $destinationLocationAddress = null)
    {
        $this->DestinationLocationAddress = $destinationLocationAddress;
        return $this;
    }
    /**
     * Get DestinationLocationType value
     * @return string|null
     */
    public function getDestinationLocationType()
    {
        return $this->DestinationLocationType;
    }
    /**
     * Set DestinationLocationType value
     * @uses \cosolis\EnumType\CosolisFedExLocationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisFedExLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationLocationType
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationLocationType($destinationLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisFedExLocationType::valueIsValid($destinationLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisFedExLocationType', is_array($destinationLocationType) ? implode(', ', $destinationLocationType) : var_export($destinationLocationType, true), implode(', ', \cosolis\EnumType\CosolisFedExLocationType::getValidValues())), __LINE__);
        }
        $this->DestinationLocationType = $destinationLocationType;
        return $this;
    }
    /**
     * Get DestinationLocationTimeZoneOffset value
     * @return string|null
     */
    public function getDestinationLocationTimeZoneOffset()
    {
        return $this->DestinationLocationTimeZoneOffset;
    }
    /**
     * Set DestinationLocationTimeZoneOffset value
     * @param string $destinationLocationTimeZoneOffset
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDestinationLocationTimeZoneOffset($destinationLocationTimeZoneOffset = null)
    {
        // validation for constraint: string
        if (!is_null($destinationLocationTimeZoneOffset) && !is_string($destinationLocationTimeZoneOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationLocationTimeZoneOffset, true), gettype($destinationLocationTimeZoneOffset)), __LINE__);
        }
        $this->DestinationLocationTimeZoneOffset = $destinationLocationTimeZoneOffset;
        return $this;
    }
    /**
     * Get ActualDeliveryAddress value
     * @return \cosolis\StructType\CosolisAddress|null
     */
    public function getActualDeliveryAddress()
    {
        return $this->ActualDeliveryAddress;
    }
    /**
     * Set ActualDeliveryAddress value
     * @param \cosolis\StructType\CosolisAddress $actualDeliveryAddress
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setActualDeliveryAddress(\cosolis\StructType\CosolisAddress $actualDeliveryAddress = null)
    {
        $this->ActualDeliveryAddress = $actualDeliveryAddress;
        return $this;
    }
    /**
     * Get OfficeOrderDeliveryMethod value
     * @return string|null
     */
    public function getOfficeOrderDeliveryMethod()
    {
        return $this->OfficeOrderDeliveryMethod;
    }
    /**
     * Set OfficeOrderDeliveryMethod value
     * @uses \cosolis\EnumType\CosolisOfficeOrderDeliveryMethodType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisOfficeOrderDeliveryMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeOrderDeliveryMethod
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setOfficeOrderDeliveryMethod($officeOrderDeliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisOfficeOrderDeliveryMethodType::valueIsValid($officeOrderDeliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisOfficeOrderDeliveryMethodType', is_array($officeOrderDeliveryMethod) ? implode(', ', $officeOrderDeliveryMethod) : var_export($officeOrderDeliveryMethod, true), implode(', ', \cosolis\EnumType\CosolisOfficeOrderDeliveryMethodType::getValidValues())), __LINE__);
        }
        $this->OfficeOrderDeliveryMethod = $officeOrderDeliveryMethod;
        return $this;
    }
    /**
     * Get DeliveryLocationType value
     * @return string|null
     */
    public function getDeliveryLocationType()
    {
        return $this->DeliveryLocationType;
    }
    /**
     * Set DeliveryLocationType value
     * @uses \cosolis\EnumType\CosolisTrackDeliveryLocationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisTrackDeliveryLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryLocationType
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDeliveryLocationType($deliveryLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisTrackDeliveryLocationType::valueIsValid($deliveryLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisTrackDeliveryLocationType', is_array($deliveryLocationType) ? implode(', ', $deliveryLocationType) : var_export($deliveryLocationType, true), implode(', ', \cosolis\EnumType\CosolisTrackDeliveryLocationType::getValidValues())), __LINE__);
        }
        $this->DeliveryLocationType = $deliveryLocationType;
        return $this;
    }
    /**
     * Get DeliveryLocationDescription value
     * @return string|null
     */
    public function getDeliveryLocationDescription()
    {
        return $this->DeliveryLocationDescription;
    }
    /**
     * Set DeliveryLocationDescription value
     * @param string $deliveryLocationDescription
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDeliveryLocationDescription($deliveryLocationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryLocationDescription) && !is_string($deliveryLocationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryLocationDescription, true), gettype($deliveryLocationDescription)), __LINE__);
        }
        $this->DeliveryLocationDescription = $deliveryLocationDescription;
        return $this;
    }
    /**
     * Get DeliveryAttempts value
     * @return int|null
     */
    public function getDeliveryAttempts()
    {
        return $this->DeliveryAttempts;
    }
    /**
     * Set DeliveryAttempts value
     * @param int $deliveryAttempts
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDeliveryAttempts($deliveryAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryAttempts) && !(is_int($deliveryAttempts) || ctype_digit($deliveryAttempts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryAttempts, true), gettype($deliveryAttempts)), __LINE__);
        }
        $this->DeliveryAttempts = $deliveryAttempts;
        return $this;
    }
    /**
     * Get DeliverySignatureName value
     * @return string|null
     */
    public function getDeliverySignatureName()
    {
        return $this->DeliverySignatureName;
    }
    /**
     * Set DeliverySignatureName value
     * @param string $deliverySignatureName
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDeliverySignatureName($deliverySignatureName = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySignatureName) && !is_string($deliverySignatureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySignatureName, true), gettype($deliverySignatureName)), __LINE__);
        }
        $this->DeliverySignatureName = $deliverySignatureName;
        return $this;
    }
    /**
     * Get PieceCountVerificationDetails value
     * @return \cosolis\StructType\CosolisPieceCountVerificationDetail[]|null
     */
    public function getPieceCountVerificationDetails()
    {
        return $this->PieceCountVerificationDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setPieceCountVerificationDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPieceCountVerificationDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePieceCountVerificationDetailsForArrayConstraintsFromSetPieceCountVerificationDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailPieceCountVerificationDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailPieceCountVerificationDetailsItem instanceof \cosolis\StructType\CosolisPieceCountVerificationDetail) {
                $invalidValues[] = is_object($trackDetailPieceCountVerificationDetailsItem) ? get_class($trackDetailPieceCountVerificationDetailsItem) : sprintf('%s(%s)', gettype($trackDetailPieceCountVerificationDetailsItem), var_export($trackDetailPieceCountVerificationDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PieceCountVerificationDetails property can only contain items of type \cosolis\StructType\CosolisPieceCountVerificationDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PieceCountVerificationDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisPieceCountVerificationDetail[] $pieceCountVerificationDetails
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setPieceCountVerificationDetails(array $pieceCountVerificationDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($pieceCountVerificationDetailsArrayErrorMessage = self::validatePieceCountVerificationDetailsForArrayConstraintsFromSetPieceCountVerificationDetails($pieceCountVerificationDetails))) {
            throw new \InvalidArgumentException($pieceCountVerificationDetailsArrayErrorMessage, __LINE__);
        }
        $this->PieceCountVerificationDetails = $pieceCountVerificationDetails;
        return $this;
    }
    /**
     * Add item to PieceCountVerificationDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisPieceCountVerificationDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToPieceCountVerificationDetails(\cosolis\StructType\CosolisPieceCountVerificationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisPieceCountVerificationDetail) {
            throw new \InvalidArgumentException(sprintf('The PieceCountVerificationDetails property can only contain items of type \cosolis\StructType\CosolisPieceCountVerificationDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PieceCountVerificationDetails[] = $item;
        return $this;
    }
    /**
     * Get TotalUniqueAddressCountInConsolidation value
     * @return int|null
     */
    public function getTotalUniqueAddressCountInConsolidation()
    {
        return $this->TotalUniqueAddressCountInConsolidation;
    }
    /**
     * Set TotalUniqueAddressCountInConsolidation value
     * @param int $totalUniqueAddressCountInConsolidation
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setTotalUniqueAddressCountInConsolidation($totalUniqueAddressCountInConsolidation = null)
    {
        // validation for constraint: int
        if (!is_null($totalUniqueAddressCountInConsolidation) && !(is_int($totalUniqueAddressCountInConsolidation) || ctype_digit($totalUniqueAddressCountInConsolidation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalUniqueAddressCountInConsolidation, true), gettype($totalUniqueAddressCountInConsolidation)), __LINE__);
        }
        $this->TotalUniqueAddressCountInConsolidation = $totalUniqueAddressCountInConsolidation;
        return $this;
    }
    /**
     * Get AvailableImages value
     * @return \cosolis\StructType\CosolisAvailableImagesDetail[]|null
     */
    public function getAvailableImages()
    {
        return $this->AvailableImages;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailableImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailableImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailableImagesForArrayConstraintsFromSetAvailableImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailAvailableImagesItem) {
            // validation for constraint: itemType
            if (!$trackDetailAvailableImagesItem instanceof \cosolis\StructType\CosolisAvailableImagesDetail) {
                $invalidValues[] = is_object($trackDetailAvailableImagesItem) ? get_class($trackDetailAvailableImagesItem) : sprintf('%s(%s)', gettype($trackDetailAvailableImagesItem), var_export($trackDetailAvailableImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AvailableImages property can only contain items of type \cosolis\StructType\CosolisAvailableImagesDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AvailableImages value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisAvailableImagesDetail[] $availableImages
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setAvailableImages(array $availableImages = array())
    {
        // validation for constraint: array
        if ('' !== ($availableImagesArrayErrorMessage = self::validateAvailableImagesForArrayConstraintsFromSetAvailableImages($availableImages))) {
            throw new \InvalidArgumentException($availableImagesArrayErrorMessage, __LINE__);
        }
        $this->AvailableImages = $availableImages;
        return $this;
    }
    /**
     * Add item to AvailableImages value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisAvailableImagesDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToAvailableImages(\cosolis\StructType\CosolisAvailableImagesDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisAvailableImagesDetail) {
            throw new \InvalidArgumentException(sprintf('The AvailableImages property can only contain items of type \cosolis\StructType\CosolisAvailableImagesDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AvailableImages[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \cosolis\StructType\CosolisSignatureImageDetail|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \cosolis\StructType\CosolisSignatureImageDetail $signature
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setSignature(\cosolis\StructType\CosolisSignatureImageDetail $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get NotificationEventsAvailable value
     * @return string[]|null
     */
    public function getNotificationEventsAvailable()
    {
        return $this->NotificationEventsAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setNotificationEventsAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotificationEventsAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationEventsAvailableForArrayConstraintsFromSetNotificationEventsAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailNotificationEventsAvailableItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($trackDetailNotificationEventsAvailableItem)) {
                $invalidValues[] = is_object($trackDetailNotificationEventsAvailableItem) ? get_class($trackDetailNotificationEventsAvailableItem) : sprintf('%s(%s)', gettype($trackDetailNotificationEventsAvailableItem), var_export($trackDetailNotificationEventsAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NotificationEventsAvailable value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $notificationEventsAvailable
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setNotificationEventsAvailable(array $notificationEventsAvailable = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationEventsAvailableArrayErrorMessage = self::validateNotificationEventsAvailableForArrayConstraintsFromSetNotificationEventsAvailable($notificationEventsAvailable))) {
            throw new \InvalidArgumentException($notificationEventsAvailableArrayErrorMessage, __LINE__);
        }
        $this->NotificationEventsAvailable = $notificationEventsAvailable;
        return $this;
    }
    /**
     * Add item to NotificationEventsAvailable value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToNotificationEventsAvailable($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues())), __LINE__);
        }
        $this->NotificationEventsAvailable[] = $item;
        return $this;
    }
    /**
     * Get SplitShipmentParts value
     * @return \cosolis\StructType\CosolisTrackSplitShipmentPart[]|null
     */
    public function getSplitShipmentParts()
    {
        return $this->SplitShipmentParts;
    }
    /**
     * This method is responsible for validating the values passed to the setSplitShipmentParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSplitShipmentParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSplitShipmentPartsForArrayConstraintsFromSetSplitShipmentParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailSplitShipmentPartsItem) {
            // validation for constraint: itemType
            if (!$trackDetailSplitShipmentPartsItem instanceof \cosolis\StructType\CosolisTrackSplitShipmentPart) {
                $invalidValues[] = is_object($trackDetailSplitShipmentPartsItem) ? get_class($trackDetailSplitShipmentPartsItem) : sprintf('%s(%s)', gettype($trackDetailSplitShipmentPartsItem), var_export($trackDetailSplitShipmentPartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SplitShipmentParts property can only contain items of type \cosolis\StructType\CosolisTrackSplitShipmentPart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SplitShipmentParts value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSplitShipmentPart[] $splitShipmentParts
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setSplitShipmentParts(array $splitShipmentParts = array())
    {
        // validation for constraint: array
        if ('' !== ($splitShipmentPartsArrayErrorMessage = self::validateSplitShipmentPartsForArrayConstraintsFromSetSplitShipmentParts($splitShipmentParts))) {
            throw new \InvalidArgumentException($splitShipmentPartsArrayErrorMessage, __LINE__);
        }
        $this->SplitShipmentParts = $splitShipmentParts;
        return $this;
    }
    /**
     * Add item to SplitShipmentParts value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSplitShipmentPart $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToSplitShipmentParts(\cosolis\StructType\CosolisTrackSplitShipmentPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackSplitShipmentPart) {
            throw new \InvalidArgumentException(sprintf('The SplitShipmentParts property can only contain items of type \cosolis\StructType\CosolisTrackSplitShipmentPart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SplitShipmentParts[] = $item;
        return $this;
    }
    /**
     * Get DeliveryOptionEligibilityDetails value
     * @return \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail[]|null
     */
    public function getDeliveryOptionEligibilityDetails()
    {
        return $this->DeliveryOptionEligibilityDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryOptionEligibilityDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryOptionEligibilityDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryOptionEligibilityDetailsForArrayConstraintsFromSetDeliveryOptionEligibilityDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailDeliveryOptionEligibilityDetailsItem) {
            // validation for constraint: itemType
            if (!$trackDetailDeliveryOptionEligibilityDetailsItem instanceof \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail) {
                $invalidValues[] = is_object($trackDetailDeliveryOptionEligibilityDetailsItem) ? get_class($trackDetailDeliveryOptionEligibilityDetailsItem) : sprintf('%s(%s)', gettype($trackDetailDeliveryOptionEligibilityDetailsItem), var_export($trackDetailDeliveryOptionEligibilityDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryOptionEligibilityDetails property can only contain items of type \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryOptionEligibilityDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail[] $deliveryOptionEligibilityDetails
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setDeliveryOptionEligibilityDetails(array $deliveryOptionEligibilityDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryOptionEligibilityDetailsArrayErrorMessage = self::validateDeliveryOptionEligibilityDetailsForArrayConstraintsFromSetDeliveryOptionEligibilityDetails($deliveryOptionEligibilityDetails))) {
            throw new \InvalidArgumentException($deliveryOptionEligibilityDetailsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryOptionEligibilityDetails = $deliveryOptionEligibilityDetails;
        return $this;
    }
    /**
     * Add item to DeliveryOptionEligibilityDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToDeliveryOptionEligibilityDetails(\cosolis\StructType\CosolisDeliveryOptionEligibilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail) {
            throw new \InvalidArgumentException(sprintf('The DeliveryOptionEligibilityDetails property can only contain items of type \cosolis\StructType\CosolisDeliveryOptionEligibilityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryOptionEligibilityDetails[] = $item;
        return $this;
    }
    /**
     * Get Events value
     * @return \cosolis\StructType\CosolisTrackEvent[]|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * This method is responsible for validating the values passed to the setEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsForArrayConstraintsFromSetEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackDetailEventsItem) {
            // validation for constraint: itemType
            if (!$trackDetailEventsItem instanceof \cosolis\StructType\CosolisTrackEvent) {
                $invalidValues[] = is_object($trackDetailEventsItem) ? get_class($trackDetailEventsItem) : sprintf('%s(%s)', gettype($trackDetailEventsItem), var_export($trackDetailEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Events property can only contain items of type \cosolis\StructType\CosolisTrackEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Events value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackEvent[] $events
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function setEvents(array $events = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsArrayErrorMessage = self::validateEventsForArrayConstraintsFromSetEvents($events))) {
            throw new \InvalidArgumentException($eventsArrayErrorMessage, __LINE__);
        }
        $this->Events = $events;
        return $this;
    }
    /**
     * Add item to Events value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackEvent $item
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public function addToEvents(\cosolis\StructType\CosolisTrackEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackEvent) {
            throw new \InvalidArgumentException(sprintf('The Events property can only contain items of type \cosolis\StructType\CosolisTrackEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Events[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisTrackDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
