<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringBarcode StructType
 * Meta information extracted from the WSDL
 * - documentation: Each instance of this data type represents a barcode whose content must be represented as ASCII text (i.e. not binary data).
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisStringBarcode extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The kind of barcode data in this instance.
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: The data content of this instance.
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for StringBarcode
     * @uses CosolisStringBarcode::setType()
     * @uses CosolisStringBarcode::setValue()
     * @param string $type
     * @param string $value
     */
    public function __construct($type = null, $value = null)
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \cosolis\EnumType\CosolisStringBarcodeType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisStringBarcodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \cosolis\StructType\CosolisStringBarcode
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisStringBarcodeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisStringBarcodeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \cosolis\EnumType\CosolisStringBarcodeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \cosolis\StructType\CosolisStringBarcode
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisStringBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
