<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialInstructionStatusDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisSpecialInstructionStatusDetail extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Specifies the status of the track special instructions requested.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusCreateTime
     * Meta information extracted from the WSDL
     * - documentation: Time when the status was changed.
     * - minOccurs: 0
     * @var string
     */
    public $StatusCreateTime;
    /**
     * Constructor method for SpecialInstructionStatusDetail
     * @uses CosolisSpecialInstructionStatusDetail::setStatus()
     * @uses CosolisSpecialInstructionStatusDetail::setStatusCreateTime()
     * @param string $status
     * @param string $statusCreateTime
     */
    public function __construct($status = null, $statusCreateTime = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCreateTime($statusCreateTime);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \cosolis\EnumType\CosolisSpecialInstructionsStatusCode::valueIsValid()
     * @uses \cosolis\EnumType\CosolisSpecialInstructionsStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \cosolis\StructType\CosolisSpecialInstructionStatusDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisSpecialInstructionsStatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisSpecialInstructionsStatusCode', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \cosolis\EnumType\CosolisSpecialInstructionsStatusCode::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCreateTime value
     * @return string|null
     */
    public function getStatusCreateTime()
    {
        return $this->StatusCreateTime;
    }
    /**
     * Set StatusCreateTime value
     * @param string $statusCreateTime
     * @return \cosolis\StructType\CosolisSpecialInstructionStatusDetail
     */
    public function setStatusCreateTime($statusCreateTime = null)
    {
        // validation for constraint: string
        if (!is_null($statusCreateTime) && !is_string($statusCreateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCreateTime, true), gettype($statusCreateTime)), __LINE__);
        }
        $this->StatusCreateTime = $statusCreateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisSpecialInstructionStatusDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
