<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureImageDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisSignatureImageDetail extends AbstractStructBase
{
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisNotification[]
     */
    public $Notifications;
    /**
     * Constructor method for SignatureImageDetail
     * @uses CosolisSignatureImageDetail::setImage()
     * @uses CosolisSignatureImageDetail::setNotifications()
     * @param string $image
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     */
    public function __construct($image = null, array $notifications = array())
    {
        $this
            ->setImage($image)
            ->setNotifications($notifications);
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \cosolis\StructType\CosolisSignatureImageDetail
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \cosolis\StructType\CosolisNotification[]|null
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signatureImageDetailNotificationsItem) {
            // validation for constraint: itemType
            if (!$signatureImageDetailNotificationsItem instanceof \cosolis\StructType\CosolisNotification) {
                $invalidValues[] = is_object($signatureImageDetailNotificationsItem) ? get_class($signatureImageDetailNotificationsItem) : sprintf('%s(%s)', gettype($signatureImageDetailNotificationsItem), var_export($signatureImageDetailNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @return \cosolis\StructType\CosolisSignatureImageDetail
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification $item
     * @return \cosolis\StructType\CosolisSignatureImageDetail
     */
    public function addToNotifications(\cosolis\StructType\CosolisNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisNotification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisSignatureImageDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
