<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentEventNotificationSpecification StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisShipmentEventNotificationSpecification extends AbstractStructBase
{
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Role;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Events;
    /**
     * The NotificationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisNotificationDetail
     */
    public $NotificationDetail;
    /**
     * The FormatSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisShipmentNotificationFormatSpecification
     */
    public $FormatSpecification;
    /**
     * Constructor method for ShipmentEventNotificationSpecification
     * @uses CosolisShipmentEventNotificationSpecification::setRole()
     * @uses CosolisShipmentEventNotificationSpecification::setEvents()
     * @uses CosolisShipmentEventNotificationSpecification::setNotificationDetail()
     * @uses CosolisShipmentEventNotificationSpecification::setFormatSpecification()
     * @param string $role
     * @param string[] $events
     * @param \cosolis\StructType\CosolisNotificationDetail $notificationDetail
     * @param \cosolis\StructType\CosolisShipmentNotificationFormatSpecification $formatSpecification
     */
    public function __construct($role = null, array $events = array(), \cosolis\StructType\CosolisNotificationDetail $notificationDetail = null, \cosolis\StructType\CosolisShipmentNotificationFormatSpecification $formatSpecification = null)
    {
        $this
            ->setRole($role)
            ->setEvents($events)
            ->setNotificationDetail($notificationDetail)
            ->setFormatSpecification($formatSpecification);
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @uses \cosolis\EnumType\CosolisShipmentNotificationRoleType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisShipmentNotificationRoleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisShipmentNotificationRoleType::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisShipmentNotificationRoleType', is_array($role) ? implode(', ', $role) : var_export($role, true), implode(', ', \cosolis\EnumType\CosolisShipmentNotificationRoleType::getValidValues())), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
    /**
     * Get Events value
     * @return string[]|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * This method is responsible for validating the values passed to the setEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsForArrayConstraintsFromSetEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentEventNotificationSpecificationEventsItem) {
            // validation for constraint: enumeration
            if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($shipmentEventNotificationSpecificationEventsItem)) {
                $invalidValues[] = is_object($shipmentEventNotificationSpecificationEventsItem) ? get_class($shipmentEventNotificationSpecificationEventsItem) : sprintf('%s(%s)', gettype($shipmentEventNotificationSpecificationEventsItem), var_export($shipmentEventNotificationSpecificationEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Events value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $events
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public function setEvents(array $events = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsArrayErrorMessage = self::validateEventsForArrayConstraintsFromSetEvents($events))) {
            throw new \InvalidArgumentException($eventsArrayErrorMessage, __LINE__);
        }
        $this->Events = $events;
        return $this;
    }
    /**
     * Add item to Events value
     * @uses \cosolis\EnumType\CosolisNotificationEventType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public function addToEvents($item)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationEventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationEventType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \cosolis\EnumType\CosolisNotificationEventType::getValidValues())), __LINE__);
        }
        $this->Events[] = $item;
        return $this;
    }
    /**
     * Get NotificationDetail value
     * @return \cosolis\StructType\CosolisNotificationDetail|null
     */
    public function getNotificationDetail()
    {
        return $this->NotificationDetail;
    }
    /**
     * Set NotificationDetail value
     * @param \cosolis\StructType\CosolisNotificationDetail $notificationDetail
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public function setNotificationDetail(\cosolis\StructType\CosolisNotificationDetail $notificationDetail = null)
    {
        $this->NotificationDetail = $notificationDetail;
        return $this;
    }
    /**
     * Get FormatSpecification value
     * @return \cosolis\StructType\CosolisShipmentNotificationFormatSpecification|null
     */
    public function getFormatSpecification()
    {
        return $this->FormatSpecification;
    }
    /**
     * Set FormatSpecification value
     * @param \cosolis\StructType\CosolisShipmentNotificationFormatSpecification $formatSpecification
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public function setFormatSpecification(\cosolis\StructType\CosolisShipmentNotificationFormatSpecification $formatSpecification = null)
    {
        $this->FormatSpecification = $formatSpecification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
