<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentEventNotificationDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisShipmentEventNotificationDetail extends AbstractStructBase
{
    /**
     * The AggregationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AggregationType;
    /**
     * The PersonalMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PersonalMessage;
    /**
     * The EventNotifications
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisShipmentEventNotificationSpecification[]
     */
    public $EventNotifications;
    /**
     * Constructor method for ShipmentEventNotificationDetail
     * @uses CosolisShipmentEventNotificationDetail::setAggregationType()
     * @uses CosolisShipmentEventNotificationDetail::setPersonalMessage()
     * @uses CosolisShipmentEventNotificationDetail::setEventNotifications()
     * @param string $aggregationType
     * @param string $personalMessage
     * @param \cosolis\StructType\CosolisShipmentEventNotificationSpecification[] $eventNotifications
     */
    public function __construct($aggregationType = null, $personalMessage = null, array $eventNotifications = array())
    {
        $this
            ->setAggregationType($aggregationType)
            ->setPersonalMessage($personalMessage)
            ->setEventNotifications($eventNotifications);
    }
    /**
     * Get AggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->AggregationType;
    }
    /**
     * Set AggregationType value
     * @uses \cosolis\EnumType\CosolisShipmentNotificationAggregationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisShipmentNotificationAggregationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aggregationType
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisShipmentNotificationAggregationType::valueIsValid($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisShipmentNotificationAggregationType', is_array($aggregationType) ? implode(', ', $aggregationType) : var_export($aggregationType, true), implode(', ', \cosolis\EnumType\CosolisShipmentNotificationAggregationType::getValidValues())), __LINE__);
        }
        $this->AggregationType = $aggregationType;
        return $this;
    }
    /**
     * Get PersonalMessage value
     * @return string|null
     */
    public function getPersonalMessage()
    {
        return $this->PersonalMessage;
    }
    /**
     * Set PersonalMessage value
     * @param string $personalMessage
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public function setPersonalMessage($personalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($personalMessage) && !is_string($personalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalMessage, true), gettype($personalMessage)), __LINE__);
        }
        $this->PersonalMessage = $personalMessage;
        return $this;
    }
    /**
     * Get EventNotifications value
     * @return \cosolis\StructType\CosolisShipmentEventNotificationSpecification[]|null
     */
    public function getEventNotifications()
    {
        return $this->EventNotifications;
    }
    /**
     * This method is responsible for validating the values passed to the setEventNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventNotificationsForArrayConstraintsFromSetEventNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentEventNotificationDetailEventNotificationsItem) {
            // validation for constraint: itemType
            if (!$shipmentEventNotificationDetailEventNotificationsItem instanceof \cosolis\StructType\CosolisShipmentEventNotificationSpecification) {
                $invalidValues[] = is_object($shipmentEventNotificationDetailEventNotificationsItem) ? get_class($shipmentEventNotificationDetailEventNotificationsItem) : sprintf('%s(%s)', gettype($shipmentEventNotificationDetailEventNotificationsItem), var_export($shipmentEventNotificationDetailEventNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventNotifications property can only contain items of type \cosolis\StructType\CosolisShipmentEventNotificationSpecification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventNotifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisShipmentEventNotificationSpecification[] $eventNotifications
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public function setEventNotifications(array $eventNotifications = array())
    {
        // validation for constraint: array
        if ('' !== ($eventNotificationsArrayErrorMessage = self::validateEventNotificationsForArrayConstraintsFromSetEventNotifications($eventNotifications))) {
            throw new \InvalidArgumentException($eventNotificationsArrayErrorMessage, __LINE__);
        }
        $this->EventNotifications = $eventNotifications;
        return $this;
    }
    /**
     * Add item to EventNotifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisShipmentEventNotificationSpecification $item
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public function addToEventNotifications(\cosolis\StructType\CosolisShipmentEventNotificationSpecification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisShipmentEventNotificationSpecification) {
            throw new \InvalidArgumentException(sprintf('The EventNotifications property can only contain items of type \cosolis\StructType\CosolisShipmentEventNotificationSpecification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventNotifications[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
