<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendNotificationsRequest StructType
 * Meta information extracted from the WSDL
 * - type: ns:SendNotificationsRequest
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisSendNotificationsRequest extends AbstractStructBase
{
    /**
     * The WebAuthenticationDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data to be used in authentication of the sender's identity (and right to use FedEx web services).
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public $WebAuthenticationDetail;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data identifying the client submitting the transaction.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisClientDetail
     */
    public $ClientDetail;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - documentation: The tracking number to which the notifications will be triggered from.
     * - minOccurs: 1
     * @var string
     */
    public $TrackingNumber;
    /**
     * The SenderContactName
     * Meta information extracted from the WSDL
     * - documentation: Included in the email notification identifying the requester of this notification.
     * - minOccurs: 1
     * @var string
     */
    public $SenderContactName;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Contains a free form field that is echoed back in the reply to match requests with replies and data that governs the data payload language/translations
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The MultiPiece
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to return tracking information for all associated packages.
     * - minOccurs: 0
     * @var bool
     */
    public $MultiPiece;
    /**
     * The PagingToken
     * Meta information extracted from the WSDL
     * - documentation: When the MoreDataAvailable field is true in a TrackNotificationReply the PagingToken must be sent in the subsequent TrackNotificationRequest to retrieve the next page of data.
     * - minOccurs: 0
     * @var string
     */
    public $PagingToken;
    /**
     * The TrackingNumberUniqueId
     * Meta information extracted from the WSDL
     * - documentation: Use this field when your original request informs you that there are duplicates of this tracking number. If you get duplicates you will also receive some information about each of the duplicate tracking numbers to enable you to chose
     * one and resend that number along with the TrackingNumberUniqueId to get notifications for that tracking number.
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumberUniqueId;
    /**
     * The ShipDateRangeBegin
     * Meta information extracted from the WSDL
     * - documentation: To narrow the search to a period in time the ShipDateRangeBegin and ShipDateRangeEnd can be used to help eliminate duplicates.
     * - minOccurs: 0
     * @var string
     */
    public $ShipDateRangeBegin;
    /**
     * The ShipDateRangeEnd
     * Meta information extracted from the WSDL
     * - documentation: To narrow the search to a period in time the ShipDateRangeBegin and ShipDateRangeEnd can be used to help eliminate duplicates.
     * - minOccurs: 0
     * @var string
     */
    public $ShipDateRangeEnd;
    /**
     * The SenderEMailAddress
     * Meta information extracted from the WSDL
     * - documentation: Included in the email notification identifying the requester of this notification.
     * - minOccurs: 0
     * @var string
     */
    public $SenderEMailAddress;
    /**
     * The EventNotificationDetail
     * Meta information extracted from the WSDL
     * - documentation: This replaces eMailNotificationDetail
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisShipmentEventNotificationDetail
     */
    public $EventNotificationDetail;
    /**
     * Constructor method for SendNotificationsRequest
     * @uses CosolisSendNotificationsRequest::setWebAuthenticationDetail()
     * @uses CosolisSendNotificationsRequest::setClientDetail()
     * @uses CosolisSendNotificationsRequest::setVersion()
     * @uses CosolisSendNotificationsRequest::setTrackingNumber()
     * @uses CosolisSendNotificationsRequest::setSenderContactName()
     * @uses CosolisSendNotificationsRequest::setTransactionDetail()
     * @uses CosolisSendNotificationsRequest::setMultiPiece()
     * @uses CosolisSendNotificationsRequest::setPagingToken()
     * @uses CosolisSendNotificationsRequest::setTrackingNumberUniqueId()
     * @uses CosolisSendNotificationsRequest::setShipDateRangeBegin()
     * @uses CosolisSendNotificationsRequest::setShipDateRangeEnd()
     * @uses CosolisSendNotificationsRequest::setSenderEMailAddress()
     * @uses CosolisSendNotificationsRequest::setEventNotificationDetail()
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param string $trackingNumber
     * @param string $senderContactName
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param bool $multiPiece
     * @param string $pagingToken
     * @param string $trackingNumberUniqueId
     * @param string $shipDateRangeBegin
     * @param string $shipDateRangeEnd
     * @param string $senderEMailAddress
     * @param \cosolis\StructType\CosolisShipmentEventNotificationDetail $eventNotificationDetail
     */
    public function __construct(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null, \cosolis\StructType\CosolisClientDetail $clientDetail = null, \cosolis\StructType\CosolisVersionId $version = null, $trackingNumber = null, $senderContactName = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, $multiPiece = null, $pagingToken = null, $trackingNumberUniqueId = null, $shipDateRangeBegin = null, $shipDateRangeEnd = null, $senderEMailAddress = null, \cosolis\StructType\CosolisShipmentEventNotificationDetail $eventNotificationDetail = null)
    {
        $this
            ->setWebAuthenticationDetail($webAuthenticationDetail)
            ->setClientDetail($clientDetail)
            ->setVersion($version)
            ->setTrackingNumber($trackingNumber)
            ->setSenderContactName($senderContactName)
            ->setTransactionDetail($transactionDetail)
            ->setMultiPiece($multiPiece)
            ->setPagingToken($pagingToken)
            ->setTrackingNumberUniqueId($trackingNumberUniqueId)
            ->setShipDateRangeBegin($shipDateRangeBegin)
            ->setShipDateRangeEnd($shipDateRangeEnd)
            ->setSenderEMailAddress($senderEMailAddress)
            ->setEventNotificationDetail($eventNotificationDetail);
    }
    /**
     * Get WebAuthenticationDetail value
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public function getWebAuthenticationDetail()
    {
        return $this->WebAuthenticationDetail;
    }
    /**
     * Set WebAuthenticationDetail value
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setWebAuthenticationDetail(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null)
    {
        $this->WebAuthenticationDetail = $webAuthenticationDetail;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \cosolis\StructType\CosolisClientDetail
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setClientDetail(\cosolis\StructType\CosolisClientDetail $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get SenderContactName value
     * @return string
     */
    public function getSenderContactName()
    {
        return $this->SenderContactName;
    }
    /**
     * Set SenderContactName value
     * @param string $senderContactName
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setSenderContactName($senderContactName = null)
    {
        // validation for constraint: string
        if (!is_null($senderContactName) && !is_string($senderContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderContactName, true), gettype($senderContactName)), __LINE__);
        }
        $this->SenderContactName = $senderContactName;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get MultiPiece value
     * @return bool|null
     */
    public function getMultiPiece()
    {
        return $this->MultiPiece;
    }
    /**
     * Set MultiPiece value
     * @param bool $multiPiece
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setMultiPiece($multiPiece = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiPiece) && !is_bool($multiPiece)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiPiece, true), gettype($multiPiece)), __LINE__);
        }
        $this->MultiPiece = $multiPiece;
        return $this;
    }
    /**
     * Get PagingToken value
     * @return string|null
     */
    public function getPagingToken()
    {
        return $this->PagingToken;
    }
    /**
     * Set PagingToken value
     * @param string $pagingToken
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setPagingToken($pagingToken = null)
    {
        // validation for constraint: string
        if (!is_null($pagingToken) && !is_string($pagingToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagingToken, true), gettype($pagingToken)), __LINE__);
        }
        $this->PagingToken = $pagingToken;
        return $this;
    }
    /**
     * Get TrackingNumberUniqueId value
     * @return string|null
     */
    public function getTrackingNumberUniqueId()
    {
        return $this->TrackingNumberUniqueId;
    }
    /**
     * Set TrackingNumberUniqueId value
     * @param string $trackingNumberUniqueId
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setTrackingNumberUniqueId($trackingNumberUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberUniqueId) && !is_string($trackingNumberUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumberUniqueId, true), gettype($trackingNumberUniqueId)), __LINE__);
        }
        $this->TrackingNumberUniqueId = $trackingNumberUniqueId;
        return $this;
    }
    /**
     * Get ShipDateRangeBegin value
     * @return string|null
     */
    public function getShipDateRangeBegin()
    {
        return $this->ShipDateRangeBegin;
    }
    /**
     * Set ShipDateRangeBegin value
     * @param string $shipDateRangeBegin
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setShipDateRangeBegin($shipDateRangeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($shipDateRangeBegin) && !is_string($shipDateRangeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDateRangeBegin, true), gettype($shipDateRangeBegin)), __LINE__);
        }
        $this->ShipDateRangeBegin = $shipDateRangeBegin;
        return $this;
    }
    /**
     * Get ShipDateRangeEnd value
     * @return string|null
     */
    public function getShipDateRangeEnd()
    {
        return $this->ShipDateRangeEnd;
    }
    /**
     * Set ShipDateRangeEnd value
     * @param string $shipDateRangeEnd
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setShipDateRangeEnd($shipDateRangeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($shipDateRangeEnd) && !is_string($shipDateRangeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDateRangeEnd, true), gettype($shipDateRangeEnd)), __LINE__);
        }
        $this->ShipDateRangeEnd = $shipDateRangeEnd;
        return $this;
    }
    /**
     * Get SenderEMailAddress value
     * @return string|null
     */
    public function getSenderEMailAddress()
    {
        return $this->SenderEMailAddress;
    }
    /**
     * Set SenderEMailAddress value
     * @param string $senderEMailAddress
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setSenderEMailAddress($senderEMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderEMailAddress) && !is_string($senderEMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderEMailAddress, true), gettype($senderEMailAddress)), __LINE__);
        }
        $this->SenderEMailAddress = $senderEMailAddress;
        return $this;
    }
    /**
     * Get EventNotificationDetail value
     * @return \cosolis\StructType\CosolisShipmentEventNotificationDetail|null
     */
    public function getEventNotificationDetail()
    {
        return $this->EventNotificationDetail;
    }
    /**
     * Set EventNotificationDetail value
     * @param \cosolis\StructType\CosolisShipmentEventNotificationDetail $eventNotificationDetail
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public function setEventNotificationDetail(\cosolis\StructType\CosolisShipmentEventNotificationDetail $eventNotificationDetail = null)
    {
        $this->EventNotificationDetail = $eventNotificationDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisSendNotificationsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
