<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendNotificationsReply StructType
 * Meta information extracted from the WSDL
 * - type: ns:SendNotificationsReply
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisSendNotificationsReply extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - documentation: This contains the severity type of the most severe Notification in the Notifications array.
     * - minOccurs: 1
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - documentation: Information about the request/reply such was the transaction successful or not, and any additional information relevant to the request and/or reply. There may be multiple Notifications in a reply.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisNotification[]
     */
    public $Notifications;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Contains the version of the reply being used.
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Contains the CustomerTransactionDetail that is echoed back to the caller for matching requests and replies and a Localization element for defining the language/translation used in the reply data.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The DuplicateWaybill
     * Meta information extracted from the WSDL
     * - documentation: True if duplicate packages (more than one package with the same tracking number) have been found, the packages array contains information about each duplicate. Use this information to determine which of the tracking numbers is the
     * one you need and resend your request using the tracking number and TrackingNumberUniqueIdentifier for that package.
     * - minOccurs: 0
     * @var bool
     */
    public $DuplicateWaybill;
    /**
     * The MoreDataAvailable
     * Meta information extracted from the WSDL
     * - documentation: True if additional packages remain to be retrieved.
     * - minOccurs: 0
     * @var bool
     */
    public $MoreDataAvailable;
    /**
     * The PagingToken
     * Meta information extracted from the WSDL
     * - documentation: Value that must be passed in a TrackNotification request to retrieve the next set of packages (when MoreDataAvailable = true).
     * - minOccurs: 0
     * @var string
     */
    public $PagingToken;
    /**
     * The Packages
     * Meta information extracted from the WSDL
     * - documentation: Information about the notifications that are available for this tracking number. If there are duplicates the ship date and destination address information is returned for determining which TrackingNumberUniqueIdentifier to use on a
     * subsequent request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackNotificationPackage[]
     */
    public $Packages;
    /**
     * Constructor method for SendNotificationsReply
     * @uses CosolisSendNotificationsReply::setHighestSeverity()
     * @uses CosolisSendNotificationsReply::setNotifications()
     * @uses CosolisSendNotificationsReply::setVersion()
     * @uses CosolisSendNotificationsReply::setTransactionDetail()
     * @uses CosolisSendNotificationsReply::setDuplicateWaybill()
     * @uses CosolisSendNotificationsReply::setMoreDataAvailable()
     * @uses CosolisSendNotificationsReply::setPagingToken()
     * @uses CosolisSendNotificationsReply::setPackages()
     * @param string $highestSeverity
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param bool $duplicateWaybill
     * @param bool $moreDataAvailable
     * @param string $pagingToken
     * @param \cosolis\StructType\CosolisTrackNotificationPackage[] $packages
     */
    public function __construct($highestSeverity = null, array $notifications = array(), \cosolis\StructType\CosolisVersionId $version = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, $duplicateWaybill = null, $moreDataAvailable = null, $pagingToken = null, array $packages = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setDuplicateWaybill($duplicateWaybill)
            ->setMoreDataAvailable($moreDataAvailable)
            ->setPagingToken($pagingToken)
            ->setPackages($packages);
    }
    /**
     * Get HighestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \cosolis\EnumType\CosolisNotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \cosolis\StructType\CosolisNotification[]
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendNotificationsReplyNotificationsItem) {
            // validation for constraint: itemType
            if (!$sendNotificationsReplyNotificationsItem instanceof \cosolis\StructType\CosolisNotification) {
                $invalidValues[] = is_object($sendNotificationsReplyNotificationsItem) ? get_class($sendNotificationsReplyNotificationsItem) : sprintf('%s(%s)', gettype($sendNotificationsReplyNotificationsItem), var_export($sendNotificationsReplyNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification[] $notifications
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisNotification $item
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function addToNotifications(\cosolis\StructType\CosolisNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisNotification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \cosolis\StructType\CosolisNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get DuplicateWaybill value
     * @return bool|null
     */
    public function getDuplicateWaybill()
    {
        return $this->DuplicateWaybill;
    }
    /**
     * Set DuplicateWaybill value
     * @param bool $duplicateWaybill
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setDuplicateWaybill($duplicateWaybill = null)
    {
        // validation for constraint: boolean
        if (!is_null($duplicateWaybill) && !is_bool($duplicateWaybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($duplicateWaybill, true), gettype($duplicateWaybill)), __LINE__);
        }
        $this->DuplicateWaybill = $duplicateWaybill;
        return $this;
    }
    /**
     * Get MoreDataAvailable value
     * @return bool|null
     */
    public function getMoreDataAvailable()
    {
        return $this->MoreDataAvailable;
    }
    /**
     * Set MoreDataAvailable value
     * @param bool $moreDataAvailable
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setMoreDataAvailable($moreDataAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreDataAvailable) && !is_bool($moreDataAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreDataAvailable, true), gettype($moreDataAvailable)), __LINE__);
        }
        $this->MoreDataAvailable = $moreDataAvailable;
        return $this;
    }
    /**
     * Get PagingToken value
     * @return string|null
     */
    public function getPagingToken()
    {
        return $this->PagingToken;
    }
    /**
     * Set PagingToken value
     * @param string $pagingToken
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setPagingToken($pagingToken = null)
    {
        // validation for constraint: string
        if (!is_null($pagingToken) && !is_string($pagingToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagingToken, true), gettype($pagingToken)), __LINE__);
        }
        $this->PagingToken = $pagingToken;
        return $this;
    }
    /**
     * Get Packages value
     * @return \cosolis\StructType\CosolisTrackNotificationPackage[]|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendNotificationsReplyPackagesItem) {
            // validation for constraint: itemType
            if (!$sendNotificationsReplyPackagesItem instanceof \cosolis\StructType\CosolisTrackNotificationPackage) {
                $invalidValues[] = is_object($sendNotificationsReplyPackagesItem) ? get_class($sendNotificationsReplyPackagesItem) : sprintf('%s(%s)', gettype($sendNotificationsReplyPackagesItem), var_export($sendNotificationsReplyPackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Packages property can only contain items of type \cosolis\StructType\CosolisTrackNotificationPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Packages value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackNotificationPackage[] $packages
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Add item to Packages value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackNotificationPackage $item
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public function addToPackages(\cosolis\StructType\CosolisTrackNotificationPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackNotificationPackage) {
            throw new \InvalidArgumentException(sprintf('The Packages property can only contain items of type \cosolis\StructType\CosolisTrackNotificationPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Packages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisSendNotificationsReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
