<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceCountVerificationDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisPieceCountVerificationDetail extends AbstractStructBase
{
    /**
     * The CountLocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountLocationType;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PieceCountVerificationDetail
     * @uses CosolisPieceCountVerificationDetail::setCountLocationType()
     * @uses CosolisPieceCountVerificationDetail::setCount()
     * @uses CosolisPieceCountVerificationDetail::setDescription()
     * @param string $countLocationType
     * @param int $count
     * @param string $description
     */
    public function __construct($countLocationType = null, $count = null, $description = null)
    {
        $this
            ->setCountLocationType($countLocationType)
            ->setCount($count)
            ->setDescription($description);
    }
    /**
     * Get CountLocationType value
     * @return string|null
     */
    public function getCountLocationType()
    {
        return $this->CountLocationType;
    }
    /**
     * Set CountLocationType value
     * @uses \cosolis\EnumType\CosolisPieceCountLocationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisPieceCountLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countLocationType
     * @return \cosolis\StructType\CosolisPieceCountVerificationDetail
     */
    public function setCountLocationType($countLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisPieceCountLocationType::valueIsValid($countLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisPieceCountLocationType', is_array($countLocationType) ? implode(', ', $countLocationType) : var_export($countLocationType, true), implode(', ', \cosolis\EnumType\CosolisPieceCountLocationType::getValidValues())), __LINE__);
        }
        $this->CountLocationType = $countLocationType;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \cosolis\StructType\CosolisPieceCountVerificationDetail
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \cosolis\StructType\CosolisPieceCountVerificationDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisPieceCountVerificationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
