<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagingDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisPagingDetail extends AbstractStructBase
{
    /**
     * The PagingToken
     * Meta information extracted from the WSDL
     * - documentation: When the MoreData field = true in a TrackReply the PagingToken must be sent in the subsequent TrackRequest to retrieve the next page of data.
     * - minOccurs: 0
     * @var string
     */
    public $PagingToken;
    /**
     * The NumberOfResultsPerPage
     * Meta information extracted from the WSDL
     * - documentation: Specifies the number of results to display per page when the there is more than one page in the subsequent TrackReply.
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfResultsPerPage;
    /**
     * Constructor method for PagingDetail
     * @uses CosolisPagingDetail::setPagingToken()
     * @uses CosolisPagingDetail::setNumberOfResultsPerPage()
     * @param string $pagingToken
     * @param int $numberOfResultsPerPage
     */
    public function __construct($pagingToken = null, $numberOfResultsPerPage = null)
    {
        $this
            ->setPagingToken($pagingToken)
            ->setNumberOfResultsPerPage($numberOfResultsPerPage);
    }
    /**
     * Get PagingToken value
     * @return string|null
     */
    public function getPagingToken()
    {
        return $this->PagingToken;
    }
    /**
     * Set PagingToken value
     * @param string $pagingToken
     * @return \cosolis\StructType\CosolisPagingDetail
     */
    public function setPagingToken($pagingToken = null)
    {
        // validation for constraint: string
        if (!is_null($pagingToken) && !is_string($pagingToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagingToken, true), gettype($pagingToken)), __LINE__);
        }
        $this->PagingToken = $pagingToken;
        return $this;
    }
    /**
     * Get NumberOfResultsPerPage value
     * @return int|null
     */
    public function getNumberOfResultsPerPage()
    {
        return $this->NumberOfResultsPerPage;
    }
    /**
     * Set NumberOfResultsPerPage value
     * @param int $numberOfResultsPerPage
     * @return \cosolis\StructType\CosolisPagingDetail
     */
    public function setNumberOfResultsPerPage($numberOfResultsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfResultsPerPage) && !(is_int($numberOfResultsPerPage) || ctype_digit($numberOfResultsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfResultsPerPage, true), gettype($numberOfResultsPerPage)), __LINE__);
        }
        $this->NumberOfResultsPerPage = $numberOfResultsPerPage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisPagingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
