<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationDetail StructType
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisNotificationDetail extends AbstractStructBase
{
    /**
     * The NotificationType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of notification that will be sent.
     * - minOccurs: 0
     * @var string
     */
    public $NotificationType;
    /**
     * The EmailDetail
     * Meta information extracted from the WSDL
     * - documentation: Specifies the email notification details.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisEMailDetail
     */
    public $EmailDetail;
    /**
     * The Localization
     * Meta information extracted from the WSDL
     * - documentation: Specifies the localization for this notification.
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisLocalization
     */
    public $Localization;
    /**
     * Constructor method for NotificationDetail
     * @uses CosolisNotificationDetail::setNotificationType()
     * @uses CosolisNotificationDetail::setEmailDetail()
     * @uses CosolisNotificationDetail::setLocalization()
     * @param string $notificationType
     * @param \cosolis\StructType\CosolisEMailDetail $emailDetail
     * @param \cosolis\StructType\CosolisLocalization $localization
     */
    public function __construct($notificationType = null, \cosolis\StructType\CosolisEMailDetail $emailDetail = null, \cosolis\StructType\CosolisLocalization $localization = null)
    {
        $this
            ->setNotificationType($notificationType)
            ->setEmailDetail($emailDetail)
            ->setLocalization($localization);
    }
    /**
     * Get NotificationType value
     * @return string|null
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * Set NotificationType value
     * @uses \cosolis\EnumType\CosolisNotificationType::valueIsValid()
     * @uses \cosolis\EnumType\CosolisNotificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notificationType
     * @return \cosolis\StructType\CosolisNotificationDetail
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: enumeration
        if (!\cosolis\EnumType\CosolisNotificationType::valueIsValid($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \cosolis\EnumType\CosolisNotificationType', is_array($notificationType) ? implode(', ', $notificationType) : var_export($notificationType, true), implode(', ', \cosolis\EnumType\CosolisNotificationType::getValidValues())), __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Get EmailDetail value
     * @return \cosolis\StructType\CosolisEMailDetail|null
     */
    public function getEmailDetail()
    {
        return $this->EmailDetail;
    }
    /**
     * Set EmailDetail value
     * @param \cosolis\StructType\CosolisEMailDetail $emailDetail
     * @return \cosolis\StructType\CosolisNotificationDetail
     */
    public function setEmailDetail(\cosolis\StructType\CosolisEMailDetail $emailDetail = null)
    {
        $this->EmailDetail = $emailDetail;
        return $this;
    }
    /**
     * Get Localization value
     * @return \cosolis\StructType\CosolisLocalization|null
     */
    public function getLocalization()
    {
        return $this->Localization;
    }
    /**
     * Set Localization value
     * @param \cosolis\StructType\CosolisLocalization $localization
     * @return \cosolis\StructType\CosolisNotificationDetail
     */
    public function setLocalization(\cosolis\StructType\CosolisLocalization $localization = null)
    {
        $this->Localization = $localization;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisNotificationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
