<?php

namespace cosolis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTrackingDocumentsRequest StructType
 * Meta information extracted from the WSDL
 * - type: ns:GetTrackingDocumentsRequest
 * @package Cosolis
 * @subpackage Structs
 */
class CosolisGetTrackingDocumentsRequest extends AbstractStructBase
{
    /**
     * The WebAuthenticationDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data to be used in authentication of the sender's identity (and right to use FedEx web services).
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public $WebAuthenticationDetail;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisClientDetail
     */
    public $ClientDetail;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \cosolis\StructType\CosolisVersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTransactionDetail
     */
    public $TransactionDetail;
    /**
     * The SelectionDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackSelectionDetail[]
     */
    public $SelectionDetails;
    /**
     * The TrackingDocumentSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \cosolis\StructType\CosolisTrackingDocumentSpecification
     */
    public $TrackingDocumentSpecification;
    /**
     * Constructor method for GetTrackingDocumentsRequest
     * @uses CosolisGetTrackingDocumentsRequest::setWebAuthenticationDetail()
     * @uses CosolisGetTrackingDocumentsRequest::setClientDetail()
     * @uses CosolisGetTrackingDocumentsRequest::setVersion()
     * @uses CosolisGetTrackingDocumentsRequest::setTransactionDetail()
     * @uses CosolisGetTrackingDocumentsRequest::setSelectionDetails()
     * @uses CosolisGetTrackingDocumentsRequest::setTrackingDocumentSpecification()
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @param \cosolis\StructType\CosolisVersionId $version
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @param \cosolis\StructType\CosolisTrackSelectionDetail[] $selectionDetails
     * @param \cosolis\StructType\CosolisTrackingDocumentSpecification $trackingDocumentSpecification
     */
    public function __construct(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null, \cosolis\StructType\CosolisClientDetail $clientDetail = null, \cosolis\StructType\CosolisVersionId $version = null, \cosolis\StructType\CosolisTransactionDetail $transactionDetail = null, array $selectionDetails = array(), \cosolis\StructType\CosolisTrackingDocumentSpecification $trackingDocumentSpecification = null)
    {
        $this
            ->setWebAuthenticationDetail($webAuthenticationDetail)
            ->setClientDetail($clientDetail)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setSelectionDetails($selectionDetails)
            ->setTrackingDocumentSpecification($trackingDocumentSpecification);
    }
    /**
     * Get WebAuthenticationDetail value
     * @return \cosolis\StructType\CosolisWebAuthenticationDetail
     */
    public function getWebAuthenticationDetail()
    {
        return $this->WebAuthenticationDetail;
    }
    /**
     * Set WebAuthenticationDetail value
     * @param \cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setWebAuthenticationDetail(\cosolis\StructType\CosolisWebAuthenticationDetail $webAuthenticationDetail = null)
    {
        $this->WebAuthenticationDetail = $webAuthenticationDetail;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \cosolis\StructType\CosolisClientDetail
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \cosolis\StructType\CosolisClientDetail $clientDetail
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setClientDetail(\cosolis\StructType\CosolisClientDetail $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Version value
     * @return \cosolis\StructType\CosolisVersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \cosolis\StructType\CosolisVersionId $version
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setVersion(\cosolis\StructType\CosolisVersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \cosolis\StructType\CosolisTransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \cosolis\StructType\CosolisTransactionDetail $transactionDetail
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setTransactionDetail(\cosolis\StructType\CosolisTransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get SelectionDetails value
     * @return \cosolis\StructType\CosolisTrackSelectionDetail[]|null
     */
    public function getSelectionDetails()
    {
        return $this->SelectionDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionDetailsForArrayConstraintsFromSetSelectionDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getTrackingDocumentsRequestSelectionDetailsItem) {
            // validation for constraint: itemType
            if (!$getTrackingDocumentsRequestSelectionDetailsItem instanceof \cosolis\StructType\CosolisTrackSelectionDetail) {
                $invalidValues[] = is_object($getTrackingDocumentsRequestSelectionDetailsItem) ? get_class($getTrackingDocumentsRequestSelectionDetailsItem) : sprintf('%s(%s)', gettype($getTrackingDocumentsRequestSelectionDetailsItem), var_export($getTrackingDocumentsRequestSelectionDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionDetails property can only contain items of type \cosolis\StructType\CosolisTrackSelectionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSelectionDetail[] $selectionDetails
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setSelectionDetails(array $selectionDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionDetailsArrayErrorMessage = self::validateSelectionDetailsForArrayConstraintsFromSetSelectionDetails($selectionDetails))) {
            throw new \InvalidArgumentException($selectionDetailsArrayErrorMessage, __LINE__);
        }
        $this->SelectionDetails = $selectionDetails;
        return $this;
    }
    /**
     * Add item to SelectionDetails value
     * @throws \InvalidArgumentException
     * @param \cosolis\StructType\CosolisTrackSelectionDetail $item
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function addToSelectionDetails(\cosolis\StructType\CosolisTrackSelectionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \cosolis\StructType\CosolisTrackSelectionDetail) {
            throw new \InvalidArgumentException(sprintf('The SelectionDetails property can only contain items of type \cosolis\StructType\CosolisTrackSelectionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionDetails[] = $item;
        return $this;
    }
    /**
     * Get TrackingDocumentSpecification value
     * @return \cosolis\StructType\CosolisTrackingDocumentSpecification|null
     */
    public function getTrackingDocumentSpecification()
    {
        return $this->TrackingDocumentSpecification;
    }
    /**
     * Set TrackingDocumentSpecification value
     * @param \cosolis\StructType\CosolisTrackingDocumentSpecification $trackingDocumentSpecification
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public function setTrackingDocumentSpecification(\cosolis\StructType\CosolisTrackingDocumentSpecification $trackingDocumentSpecification = null)
    {
        $this->TrackingDocumentSpecification = $trackingDocumentSpecification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \cosolis\StructType\CosolisGetTrackingDocumentsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
